/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class DimRelGraphNode {
    private String dimNum;
    private long memId;
    private String memNum;
    private final int hashCode;
    private List<Pair<Long, Long>> periodList;

    public DimRelGraphNode(String dimNum, Long memId, String memNum) {
        this.dimNum = dimNum;
        this.memId = memId;
        this.memNum = memNum;
        this.hashCode = (this.dimNum + this.memId + this.memNum).hashCode();
    }

    public String getDimNum() {
        return this.dimNum;
    }

    public void setDimNum(String dimNum) {
        this.dimNum = dimNum;
    }

    public String getMemNum() {
        return this.memNum;
    }

    public void setMemNum(String memNum) {
        this.memNum = memNum;
    }

    public long getMemId() {
        return this.memId;
    }

    public void setMemId(long memId) {
        this.memId = memId;
    }

    public List<Pair<Long, Long>> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Pair<Long, Long>> periodList) {
        this.periodList = periodList;
    }

    public void addPeriod(Long startPeriod, Long endPeriod) {
        if (this.periodList == null) {
            this.periodList = new ArrayList<Pair<Long, Long>>(10);
            this.periodList.add((Pair<Long, Long>)Pair.of((Object)startPeriod, (Object)endPeriod));
        } else {
            Optional<Pair> periodOptional = this.periodList.stream().filter(p -> startPeriod.compareTo((Long)p.getLeft()) == 0 && endPeriod.compareTo((Long)p.getRight()) == 0).findAny();
            if (!periodOptional.isPresent()) {
                this.periodList.add((Pair<Long, Long>)Pair.of((Object)startPeriod, (Object)endPeriod));
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimRelGraphNode)) {
            return false;
        }
        DimRelGraphNode model = (DimRelGraphNode)obj;
        return this.dimNum.equals(model.getDimNum()) && this.memId == model.getMemId() && this.memNum.equals(model.getMemNum());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.dimNum + "-" + this.memId + "-" + this.memNum;
    }
}

