/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationEntry;

public class DimRelation
implements Serializable {
    private static final long serialVersionUID = 603712484300060983L;
    private Long relationId;
    private Long version;
    private Boolean status;
    private String affectRange;
    private Map<String, DimRelationEntry> dimMap = new LinkedHashMap<String, DimRelationEntry>(16);
    private Map<String, Set<String>> dimRelMap = new LinkedHashMap<String, Set<String>>(16);
    private List<Long> bizModel;

    public DimRelation() {
    }

    public DimRelation(Long relateId) {
        this.relationId = relateId;
        this.version = 0L;
        this.status = Boolean.TRUE;
        this.affectRange = "1";
    }

    public DimRelation(long modelId, DynamicObject relation) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        this.relationId = relation.getLong("id");
        this.version = relation.getLong("version");
        this.status = relation.getBoolean("enable");
        this.affectRange = relation.getString("affectrange");
        DynamicObjectCollection relationEntry = relation.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : relationEntry) {
            Long dimensionId = dynamicObject.getLong("dimension_id");
            DynamicObjectCollection viewList = dynamicObject.getDynamicObjectCollection("dimviews");
            List<Long> viewIds = viewList.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toList());
            Long propertyId = dynamicObject.getLong("dimproperty_id");
            int seq = dynamicObject.getInt("seq");
            Dimension dimension = modelCache.getDimension(dimensionId);
            if (dimension == null) continue;
            String dimNumber = dimension.getNumber();
            DimRelationEntry entry = new DimRelationEntry(dimensionId, dimNumber, viewIds, propertyId);
            this.dimMap.put("dimension" + seq, entry);
        }
        for (DimRelationEntry entry : this.dimMap.values()) {
            String dimNumber = entry.getDimNumber();
            for (DimRelationEntry subEntry : this.dimMap.values()) {
                String relDimNum = subEntry.getDimNumber();
                if (relDimNum.equals(dimNumber)) continue;
                Set relDimSet = this.dimRelMap.computeIfAbsent(dimNumber, k -> new LinkedHashSet(16));
                relDimSet.add(relDimNum);
            }
        }
    }

    public Long getRelationId() {
        return this.relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getAffectRange() {
        return this.affectRange;
    }

    public void setAffectRange(String affectRange) {
        this.affectRange = affectRange;
    }

    public Map<String, DimRelationEntry> getDimMap() {
        return this.dimMap;
    }

    public void setDimMap(Map<String, DimRelationEntry> dimMap) {
        this.dimMap = dimMap;
    }

    public Map<String, Set<String>> getDimRelMap() {
        return this.dimRelMap;
    }

    public void setDimRelMap(Map<String, Set<String>> dimRelMap) {
        this.dimRelMap = dimRelMap;
    }

    public List<Long> getBizModel() {
        return this.bizModel;
    }

    public void setBizModel(List<Long> bizModel) {
        this.bizModel = bizModel;
    }
}

