/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation;

import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraph;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraphHelper;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraphNode;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelation;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationEntry;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimMemRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelUpdateDao;
import kd.epm.eb.common.enums.PropRangeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;

public class DimRelationCache {
    public static final Log log = LogFactory.getLog(DimRelationCache.class);
    public static final long MAX_SIZE = 30L;
    public static final long OVER_TIME = 30L;
    private static final LoadingCache<String, DimRelation> relCache = CacheBuilder.newBuilder().maximumSize(30L).expireAfterAccess(30L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, DimRelation>(){

        public DimRelation load(String key) {
            return DimRelationCache.initDimRel(key);
        }
    });
    private static final LoadingCache<String, DimRelGraph> graphCache = CacheBuilder.newBuilder().maximumSize(30L).expireAfterAccess(30L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, DimRelGraph>(){

        public DimRelGraph load(String key) {
            return DimRelationCache.initGraph(key);
        }
    });
    private static final ThreadLocal<Map<String, DimRelation>> localRelation = new ThreadLocal();
    private static final ThreadLocal<Map<String, DimRelGraph>> localGraph = new ThreadLocal();

    public static void removeThreadLocal() {
        localRelation.remove();
        localGraph.remove();
    }

    public static DimRelation getDimRelation(long modelId, long relationId) {
        String cacheKey = DimRelationCache.buildCacheKey(modelId, relationId);
        return DimRelationCache.getDimRelationFromThreadLocal(cacheKey, modelId, relationId);
    }

    private static DimRelation getDimRelationFromThreadLocal(String cacheKey, long modelId, long relationId) {
        Map<String, DimRelation> map = localRelation.get();
        if (map == null) {
            map = new HashMap<String, DimRelation>(16);
            localRelation.set(map);
        }
        return map.computeIfAbsent(cacheKey, k -> DimRelationCache.getDimRelationFromCache(cacheKey, modelId, relationId));
    }

    private static DimRelation getDimRelationFromCache(String cacheKey, long modelId, long relationId) {
        DimRelation dimRel;
        try {
            dimRel = (DimRelation)relCache.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        Long versionNo = DimRelDao.getInstance().getVersion(modelId, relationId);
        if (versionNo.compareTo(dimRel.getVersion()) != 0) {
            log.info("Relation cache reload because version change. oldRelVer:{} newRelVer:{} ", (Object)dimRel.getVersion(), (Object)versionNo);
            relCache.invalidate((Object)cacheKey);
            try {
                dimRel = (DimRelation)relCache.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return dimRel;
    }

    public static DimRelGraph getDimRelationGraph(long modelId, long relationId) {
        String cacheKey = DimRelationCache.buildCacheKey(modelId, relationId);
        return DimRelationCache.getDimRelationGraphFromThreadLocal(cacheKey, modelId, relationId);
    }

    public static DimRelGraph getDimRelationGraphFromThreadLocal(String cacheKey, long modelId, long relationId) {
        Map<String, DimRelGraph> map = localGraph.get();
        if (map == null) {
            map = new HashMap<String, DimRelGraph>(16);
            localGraph.set(map);
        }
        return map.computeIfAbsent(cacheKey, k -> DimRelationCache.getDimRelationGraphFromCache(cacheKey, modelId, relationId));
    }

    public static DimRelGraph getDimRelationGraphFromCache(String cacheKey, long modelId, long relationId) {
        DimRelGraph dimRelGraph;
        try {
            dimRelGraph = (DimRelGraph)graphCache.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        Long versionNo = DimRelDao.getInstance().getVersion(modelId, relationId);
        boolean needRebuild = false;
        if (versionNo.compareTo(dimRelGraph.getVersion()) != 0) {
            log.info("DimGraph rebuild because relation version change. oldRelVer:{} newRelVer:{} ", (Object)dimRelGraph.getVersion(), (Object)versionNo);
            needRebuild = true;
        } else if (dimRelGraph.getEnable().booleanValue()) {
            Long dimensionId;
            for (Map.Entry<Long, Long> entry : dimRelGraph.getDimVerMap().entrySet()) {
                dimensionId = entry.getKey();
                Long oldDimVer = entry.getValue();
                Long newDimVer = CubeUtils.getDimensionVersionNo(dimensionId);
                if (newDimVer.compareTo(oldDimVer) == 0) continue;
                log.info("DimGraph rebuild because dimension version change. oldDimVer:{} newDimVer:{}", (Object)oldDimVer, (Object)newDimVer);
                needRebuild = true;
                break;
            }
            if (!needRebuild) {
                for (Map.Entry<Long, Object> entry : dimRelGraph.getDimPropVerMap().entrySet()) {
                    dimensionId = entry.getKey();
                    String oldPropVer = (String)entry.getValue();
                    String newPropVer = MemberPropCacheService.getVersion(modelId, dimensionId);
                    if (newPropVer.equals(oldPropVer)) continue;
                    log.info("DimGraph rebuild because dimensionProp version change. oldPropVer:{} newPropVer:{}", (Object)oldPropVer, (Object)newPropVer);
                    needRebuild = true;
                    break;
                }
            }
        }
        if (needRebuild) {
            graphCache.invalidate((Object)cacheKey);
            try {
                dimRelGraph = (DimRelGraph)graphCache.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return dimRelGraph;
    }

    private static String buildCacheKey(long modelId, long relationId) {
        return RequestContext.get().getAccountId() + '_' + modelId + '_' + relationId;
    }

    private static DimRelation initDimRel(String key) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("init dimension relation cache, key:{}", (Object)key);
        String[] keyArr = key.split(String.valueOf('_'));
        long modelId = Long.parseLong(keyArr[1]);
        long relationId = Long.parseLong(keyArr[2]);
        DimRelUpdateDao.getInstance().updateRel(modelId, Collections.singletonList(relationId));
        DynamicObject relation = DimRelDao.getInstance().getRelationById(modelId, relationId);
        if (relation == null) {
            log.info("init dimension relation cache, relation null, key:{}", (Object)key);
            return null;
        }
        DimRelation dimRel = new DimRelation(modelId, relation);
        log.info("init dimension relation cache complete cost:{}ms key:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)key);
        return dimRel;
    }

    private static DimRelGraph initGraph(String key) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("init dimension relation graph cache, key:{}", (Object)key);
        String[] keyArr = key.split(String.valueOf('_'));
        long modelId = Long.parseLong(keyArr[1]);
        long relationId = Long.parseLong(keyArr[2]);
        DynamicObject relation = DimRelDao.getInstance().getRelationById(modelId, relationId);
        if (relation == null) {
            log.info("init dimension relation graph cache, relation null, key:{}", (Object)key);
            return null;
        }
        long relVersion = relation.getLong("version");
        boolean enable = relation.getBoolean("enable");
        DimRelGraph dimRelGraph = new DimRelGraph(relationId);
        dimRelGraph.setEnable(enable);
        dimRelGraph.setVersion(relVersion);
        if (!enable) {
            dimRelGraph.build();
            return dimRelGraph;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        DimRelation dimRel = new DimRelation(modelId, relation);
        dimRelGraph.setDimSet(dimRel.getDimRelMap().keySet());
        Map<String, List<Long>> dimViewMap = dimRel.getDimMap().values().stream().collect(Collectors.toMap(DimRelationEntry::getDimNumber, DimRelationEntry::getViewIds, (o1, o2) -> o2));
        dimRelGraph.setDimViewMap(dimViewMap);
        Map<Long, Long> dimVerMap = dimRel.getDimMap().values().stream().collect(Collectors.toMap(DimRelationEntry::getDimensionId, v -> CubeUtils.getDimensionVersionNo(v.getDimensionId()), (o1, o2) -> o2));
        dimRelGraph.setDimVerMap(dimVerMap);
        Map<Long, String> dimPropVerMap = dimRel.getDimMap().values().stream().filter(entry -> IDUtils.isNotEmptyLong(entry.getPropertyId())).collect(Collectors.toMap(DimRelationEntry::getDimensionId, v -> MemberPropCacheService.getVersion(modelId, v.getDimensionId()), (o1, o2) -> o2));
        dimRelGraph.setDimPropVerMap(dimPropVerMap);
        DataSet rows = DimMemRelDao.getInstance().queryDimMemRel(relationId);
        AtomicInteger count = new AtomicInteger(0);
        block0: while (rows.hasNext()) {
            Row row = rows.next();
            long startPeriod = row.getLong("startperiod");
            long endPeriod = row.getLong("endperiod");
            Map<String, DimRelationEntry> dimMap = dimRel.getDimMap();
            ArrayList nodeListList = new ArrayList(dimMap.size());
            for (Map.Entry<String, DimRelationEntry> entry2 : dimMap.entrySet()) {
                String dimKey = entry2.getKey();
                DimRelationEntry relationEntry = entry2.getValue();
                String dimNumber = relationEntry.getDimNumber();
                long memberId = row.getLong(dimKey);
                int range = row.getInteger(dimKey + "range");
                Long viewId = row.getLong(dimKey + "view");
                List<Member> members = DimRelationCache.getRelationMembers(memberPropCache, modelCache, relationEntry, viewId, memberId, range);
                List nodeList = members.stream().map(member -> new DimRelGraphNode(dimNumber, member.getId(), member.getNumber())).collect(Collectors.toList());
                nodeListList.add(nodeList);
            }
            List lists = Lists.cartesianProduct(nodeListList);
            for (List list : lists) {
                int relCount = count.incrementAndGet();
                if (relCount > 3000000) {
                    log.warn("init dimension relation graph cache, exceed 300w relCount:{} key:{}", (Object)lists.size(), (Object)key);
                    continue block0;
                }
                for (int i = 0; i < list.size(); ++i) {
                    DimRelGraphNode fromNode = (DimRelGraphNode)list.get(i);
                    for (int j = i + 1; j < list.size(); ++j) {
                        DimRelGraphNode toNode = (DimRelGraphNode)list.get(j);
                        DimRelGraphNode[] preOrderNodes = new DimRelGraphNode[]{};
                        if (list.size() > 2) {
                            HashSet set = new HashSet(list);
                            set.remove(fromNode);
                            set.remove(toNode);
                            preOrderNodes = set.toArray(new DimRelGraphNode[0]);
                        }
                        DimRelGraphHelper.addNode2Graph(dimRelGraph, fromNode, toNode, startPeriod, endPeriod, preOrderNodes);
                    }
                }
            }
        }
        dimRelGraph.build();
        log.info("init dimension relation graph cache complete cost:{}ms key:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)key);
        return dimRelGraph;
    }

    public static List<Member> getRelationMembers(MemberPropCache memberPropCache, IModelCacheHelper modelCache, DimRelationEntry relationEntry, Long viewId, Long memberId, Integer rangeVal) {
        List<Member> members = null;
        String dimNumber = relationEntry.getDimNumber();
        if (relationEntry.getPropertyId() != null && relationEntry.getPropertyId() != 0L) {
            members = memberPropCache.getMembersByPropValues(relationEntry.getDimensionId(), viewId, memberId);
            if (viewId != null && viewId != 0L) {
                List<Member> viewMembers = modelCache.getMembers(viewId, relationEntry.getDimNumber());
                long startTime = System.currentTimeMillis();
                int propMemSize = members.size();
                int viewMemSize = viewMembers.size();
                HashSet<Member> memberSet = new HashSet<Member>(members);
                HashSet<Member> viewMemberSet = new HashSet<Member>(viewMembers);
                memberSet.retainAll(viewMemberSet);
                members = new ArrayList<Member>(memberSet);
                log.info("propMember:{} retainAll viewMember:{} result:{} cost:{}ms", new Object[]{propMemSize, viewMemSize, members.size(), System.currentTimeMillis() - startTime});
            }
            PropRangeEnum propRange = PropRangeEnum.PROP_ALL;
            if (rangeVal != null && rangeVal > 0) {
                propRange = PropRangeEnum.getRangeByVal(rangeVal);
            }
            if (PropRangeEnum.PROP_DETAIL == propRange) {
                members = members.stream().filter(Member::isLeaf).collect(Collectors.toList());
            } else if (PropRangeEnum.PROP_NOT_DETAIL == propRange) {
                members = members.stream().filter(mem -> !mem.isLeaf()).collect(Collectors.toList());
            }
        } else {
            RangeEnum rangeEnum = RangeEnum.ONLY;
            if (rangeVal != null && rangeVal > 0) {
                rangeEnum = RangeEnum.getRangeByVal(rangeVal);
            }
            if (viewId != null && viewId != 0L) {
                Member member = modelCache.getMember(dimNumber, viewId, memberId);
                if (member != null) {
                    members = modelCache.getMember(dimNumber, viewId, member.getNumber(), rangeEnum.getIndex());
                }
            } else {
                Member member = modelCache.getMember(dimNumber, (Long)0L, memberId);
                if (member != null) {
                    members = modelCache.getMember(dimNumber, (Long)0L, member.getNumber(), rangeEnum.getIndex());
                }
            }
        }
        if (members == null) {
            return new ArrayList<Member>(10);
        }
        return members;
    }
}

