/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraph;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraphHelper;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelGraphNode;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelation;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationCache;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationEntry;
import kd.epm.eb.common.dimension.dimensionrelation.PropertyInfo;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimMemRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelDao;
import kd.epm.eb.common.enums.PropRangeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.CellDropdown;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionRelationUtils {
    private static final Log log = LogFactory.getLog(DimensionRelationUtils.class);
    public static final Set<RangeEnum> VALID_RANGE = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new RangeEnum[]{RangeEnum.ONLY, RangeEnum.ALL, RangeEnum.ALL_DETAIL, RangeEnum.ALL_NOTDETAIL}));
    public static final Set<PropRangeEnum> VALID_PROP_RANGE = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new PropRangeEnum[]{PropRangeEnum.PROP_DETAIL, PropRangeEnum.PROP_NOT_DETAIL, PropRangeEnum.PROP_ALL}));

    public static List<Long> getRelationList(Long modelId, Long bizModelId) {
        if (bizModelId != null && bizModelId > 0L) {
            return DimRelDao.getInstance().getRelationIdByBizModel(modelId, bizModelId);
        }
        return DimRelDao.getInstance().getRelationIdByModel(modelId);
    }

    public static Map<String, Set<String>> getRelationMap(Long modelId, Long bizModelId, List<Long> relationIds) {
        List<Long> relIds;
        if (relationIds == null) {
            relationIds = new ArrayList<Long>(16);
        }
        if (bizModelId != null && bizModelId > 0L && CollectionUtils.isNotEmpty(relIds = DimRelDao.getInstance().getRelationIdByBizModel(modelId, bizModelId))) {
            relationIds.addAll(relIds);
        }
        LinkedHashMap<String, Set<String>> relMap = new LinkedHashMap<String, Set<String>>(16);
        relationIds.forEach(relationId -> {
            DimRelation dimRel = DimRelationCache.getDimRelation(modelId, relationId);
            if (dimRel != null && dimRel.getStatus().booleanValue()) {
                Map<String, Set<String>> dimRelMap = dimRel.getDimRelMap();
                dimRelMap.forEach((dim, memSet) -> {
                    Set allMemSet = relMap.computeIfAbsent((String)dim, k -> new HashSet(16));
                    allMemSet.addAll(memSet);
                });
            }
        });
        return relMap;
    }

    public static Set<Long> getRelationMemId(IModelCacheHelper modelCache, Long bizModelId, String dimNumber, Long currPeriodId, Map<String, String> preDimMap, Map<String, Set<String>> dimRelMap, List<Long> dimRelList) {
        Set<DimRelGraphNode> relNodes = DimensionRelationUtils.getRelationNode(modelCache, bizModelId, dimNumber, currPeriodId, preDimMap, dimRelMap, dimRelList);
        return relNodes.stream().map(DimRelGraphNode::getMemId).collect(Collectors.toSet());
    }

    public static Set<String> getRelationMemNum(IModelCacheHelper modelCache, Long bizModelId, String dimNumber, Long currPeriodId, Map<String, String> preDimMap, Map<String, Set<String>> dimRelMap, List<Long> dimRelList) {
        Set<DimRelGraphNode> relNodes = DimensionRelationUtils.getRelationNode(modelCache, bizModelId, dimNumber, currPeriodId, preDimMap, dimRelMap, dimRelList);
        return relNodes.stream().map(DimRelGraphNode::getMemNum).collect(Collectors.toSet());
    }

    private static Set<DimRelGraphNode> getRelationNode(IModelCacheHelper modelCache, Long bizModelId, String dimNumber, Long currPeriodId, Map<String, String> preDimMap, Map<String, Set<String>> dimRelMap, List<Long> dimRelList) {
        if (CollectionUtils.isEmpty(dimRelList)) {
            return Collections.emptySet();
        }
        long modelId = modelCache.getModelobj().getId();
        List<String> preRelDims = DimensionRelationUtils.getPreRelationDim(dimNumber, preDimMap.keySet(), dimRelMap);
        DimRelGraphNode[] totalPreNodes = (DimRelGraphNode[])preRelDims.stream().map(preDim -> {
            String preDimMem = (String)preDimMap.get(preDim);
            Dimension dimension = modelCache.getDimension((String)preDim);
            Member preMember = dimension.getStructOfMember(preDimMem);
            if (preMember != null) {
                return new DimRelGraphNode((String)preDim, preMember.getId(), preDimMem);
            }
            return null;
        }).filter(Objects::nonNull).distinct().toArray(DimRelGraphNode[]::new);
        Sets.SetView result = new HashSet(16);
        for (Long relationId : dimRelList) {
            DimRelGraph dimRelGraph = DimRelationCache.getDimRelationGraph(modelId, relationId);
            if (dimRelGraph == null || !dimRelGraph.getDimSet().contains(dimNumber)) continue;
            DimRelGraphNode[] preNodes = new DimRelGraphNode[]{};
            if (totalPreNodes.length > 0 && (preNodes = (DimRelGraphNode[])Arrays.stream(totalPreNodes).filter(node -> dimRelGraph.getDimSet().contains(node.getDimNum())).toArray(DimRelGraphNode[]::new)).length == 0) continue;
            Set<DimRelGraphNode> postNode = DimRelGraphHelper.getPostNode(modelCache, bizModelId, currPeriodId, dimNumber, dimRelGraph, preNodes);
            if (CollectionUtils.isEmpty(postNode)) {
                return Collections.emptySet();
            }
            if (CollectionUtils.isEmpty(result)) {
                result.addAll(postNode);
                continue;
            }
            Sets.SetView intersection = Sets.intersection(result, postNode);
            if (CollectionUtils.isEmpty((Collection)intersection)) {
                return Collections.emptySet();
            }
            result = intersection;
        }
        return result;
    }

    public static boolean isValidRelation(IModelCacheHelper modelCache, long bizModelId, Long currPeriodId, Map<String, String> memberMap, Map<String, Set<String>> dimRelMap, List<Long> dimRelList) {
        if (CollectionUtils.isEmpty(dimRelList)) {
            return true;
        }
        Long modelId = modelCache.getModelobj().getId();
        DimRelGraphNode[] totalRelNodes = (DimRelGraphNode[])memberMap.entrySet().stream().map(entry -> {
            String dimNum = (String)entry.getKey();
            if (dimRelMap.containsKey(dimNum)) {
                String memNum = (String)entry.getValue();
                Dimension dimension = modelCache.getDimension(dimNum);
                Member member = dimension.getStructOfMember(memNum);
                if (member != null) {
                    return new DimRelGraphNode(dimNum, member.getId(), memNum);
                }
            }
            return null;
        }).filter(Objects::nonNull).distinct().toArray(DimRelGraphNode[]::new);
        for (Long relationId : dimRelList) {
            DimRelGraphNode[] relNodes;
            boolean validRel;
            DimRelGraph dimRelGraph = DimRelationCache.getDimRelationGraph(modelId, relationId);
            if (dimRelGraph == null || (validRel = DimRelGraphHelper.isValidRel(modelCache, bizModelId, currPeriodId, dimRelGraph, relNodes = (DimRelGraphNode[])Arrays.stream(totalRelNodes).filter(node -> dimRelGraph.getDimSet().contains(node.getDimNum())).toArray(DimRelGraphNode[]::new)))) continue;
            return false;
        }
        return true;
    }

    private static List<String> getPreRelationDim(String dimNumber, Set<String> preDimSet, Map<String, Set<String>> relationMap) {
        ArrayList<String> relationDimList = new ArrayList<String>(10);
        Set<String> set = relationMap.get(dimNumber);
        if (set == null) {
            return relationDimList;
        }
        return new ArrayList<String>((Collection<String>)Sets.intersection(set, preDimSet));
    }

    public static boolean isCircle(Long modelId, Long bizModelId, List<Long> relationIds) {
        List<DimRelation> relationList = DimensionRelationUtils.getRelationSchemeList(modelId, bizModelId, relationIds);
        HashMap<String, Set<String>> relationMap = new HashMap<String, Set<String>>(16);
        for (DimRelation dimRelation : relationList) {
            Map<String, DimRelationEntry> dimMap = dimRelation.getDimMap();
            List dimList = dimMap.values().stream().map(DimRelationEntry::getDimNumber).collect(Collectors.toList());
            for (String dim : dimList) {
                HashSet<String> dimRelationSet = new HashSet<String>(16);
                DimensionRelationUtils.getDimRelationChain(dimRelationSet, dim, relationMap);
                dimRelationSet.remove(dim);
                if (Sets.intersection(dimRelationSet, new HashSet(dimList)).isEmpty()) continue;
                return true;
            }
            DimensionRelationUtils.putDimRelationIntoRelationMap(dimRelation, relationMap);
        }
        return false;
    }

    private static void putDimRelationIntoRelationMap(DimRelation dimRelation, Map<String, Set<String>> relationMap) {
        Map<String, DimRelationEntry> dimMap = dimRelation.getDimMap();
        for (DimRelationEntry entry : dimMap.values()) {
            String dimNumber = entry.getDimNumber();
            Set dimNumberList = relationMap.getOrDefault(dimNumber, new LinkedHashSet(10));
            for (DimRelationEntry entry1 : dimMap.values()) {
                String dimNumber1 = entry1.getDimNumber();
                if (dimNumber.equals(dimNumber1)) continue;
                dimNumberList.add(dimNumber1);
            }
            relationMap.put(dimNumber, dimNumberList);
        }
    }

    private static void getDimRelationChain(Set<String> dimRelationSet, String dim, Map<String, Set<String>> relationMap) {
        Set<String> dimList = relationMap.get(dim);
        if (dimList != null && !dimList.isEmpty()) {
            dimRelationSet.add(dim);
            for (String relationDim : dimList) {
                if (dimRelationSet.contains(relationDim)) continue;
                DimensionRelationUtils.getDimRelationChain(dimRelationSet, relationDim, relationMap);
            }
            dimRelationSet.addAll(dimList);
        }
    }

    public static boolean isDimPropertyNotSameType(Long modelId, Long bizModelId, List<Long> relationIds) {
        List<DimRelation> relationList = DimensionRelationUtils.getRelationSchemeList(modelId, bizModelId, relationIds);
        if (relationList.size() <= 1) {
            return false;
        }
        HashMap<String, Set> map = new HashMap<String, Set>(16);
        for (DimRelation dimRelation : relationList) {
            Map<String, DimRelationEntry> dimMap = dimRelation.getDimMap();
            for (DimRelationEntry entry : dimMap.values()) {
                String property = entry.getPropertyId() == 0L ? "0" : "1";
                String key = entry.getDimensionId() + "_" + entry.getViewId();
                Set set = map.getOrDefault(key, new HashSet(16));
                set.add(property);
                if (set.size() > 1) {
                    return true;
                }
                map.put(key, set);
            }
        }
        return false;
    }

    public static boolean isDimRepeat(Long modelId, Long bizModelId, List<Long> relationIds) {
        List<DimRelation> relationList = DimensionRelationUtils.getRelationSchemeList(modelId, bizModelId, relationIds);
        if (relationList.size() <= 1) {
            return false;
        }
        for (int i = 0; i < relationList.size(); ++i) {
            DimRelation dimRelation1 = relationList.get(i);
            Map<String, DimRelationEntry> dimMap = dimRelation1.getDimMap();
            for (int j = i + 1; j < relationList.size(); ++j) {
                DimRelation dimRelation2 = relationList.get(j);
                Map<String, DimRelationEntry> dimMap1 = dimRelation2.getDimMap();
                if (!DimensionRelationUtils.dimRepeat2Times(dimMap, dimMap1)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean dimRepeat2Times(Map<String, DimRelationEntry> dimMap1, Map<String, DimRelationEntry> dimMap2) {
        HashSet<Long> set = new HashSet<Long>(16);
        int repeatCount = 0;
        for (DimRelationEntry entry : dimMap1.values()) {
            set.add(entry.getDimensionId());
        }
        for (DimRelationEntry entry2 : dimMap2.values()) {
            if (set.add(entry2.getDimensionId()) || ++repeatCount < 2) continue;
            return true;
        }
        return false;
    }

    private static List<DimRelation> getRelationSchemeList(Long modelId, Long bizModelId, List<Long> relationIds) {
        DynamicObject[] relationSchemes = DimRelDao.getInstance().getRelation(modelId, bizModelId, relationIds);
        return Arrays.stream(relationSchemes).map(e -> new DimRelation(modelId, (DynamicObject)e)).collect(Collectors.toList());
    }

    public static Pair<List<String[]>, List<CellDropdown>> getHeadDataInfo(String schemeId) {
        DynamicObjectCollection dimCollection = DimensionRelationUtils.getRelationDimension(schemeId);
        ArrayList<String> headDates = new ArrayList<String>(dimCollection.size() * 2 + 3);
        boolean hasPeriodDim = false;
        String affectRange = "";
        int rangeColIndex = -1;
        ArrayList<CellDropdown> cellDropdownList = new ArrayList<CellDropdown>(6);
        for (DynamicObject object : dimCollection) {
            affectRange = object.getString("affectrange");
            String dimName = object.getString("entryentity.dimension.name");
            String dimNumber = object.getString("entryentity.dimension.number");
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                hasPeriodDim = true;
            }
            rangeColIndex += 3;
            String dimPropName = object.getString("entryentity.dimproperty.name");
            if (dimPropName != null) {
                dimName = dimName + new LocaleString(ResManager.loadKDString((String)"-", (String)"DimensionRelationUtils_01", (String)"epm-eb-common", (Object[])new Object[0]));
                dimName = dimName + dimPropName;
                cellDropdownList.add(DimensionRelationUtils.getDimPropRangeDropdown(rangeColIndex));
            } else {
                cellDropdownList.add(DimensionRelationUtils.getDimRangeDropdown(rangeColIndex));
            }
            headDates.add(String.format(ResManager.loadKDString((String)"*%1$s\u5185\u7801(%2$s)", (String)"DimensionRelationUtils_04", (String)"epm-eb-common", (Object[])new Object[0]), dimName, dimNumber));
            headDates.add(String.format(ResManager.loadKDString((String)"%1$s\u540d\u79f0(%2$s)", (String)"DimensionRelationUtils_05", (String)"epm-eb-common", (Object[])new Object[0]), dimName, dimNumber));
            headDates.add(String.format(ResManager.loadKDString((String)"*%1$s\u8303\u56f4(%2$s)", (String)"DimensionRelationUtils_07", (String)"epm-eb-common", (Object[])new Object[0]), dimName, dimNumber + "Range"));
            if (!StringUtils.isEmpty(dimPropName) || View.NoViewDimNums.contains(dimNumber)) continue;
            headDates.add(String.format(ResManager.loadKDString((String)"*%1$s\u89c6\u56fe\u7f16\u7801(%2$s)", (String)"DimensionRelationUtils_10", (String)"epm-eb-common", (Object[])new Object[0]), dimName, dimNumber + "view"));
            headDates.add(String.format(ResManager.loadKDString((String)"%1$s\u89c6\u56fe\u540d\u79f0(%2$s)", (String)"DimensionRelationUtils_11", (String)"epm-eb-common", (Object[])new Object[0]), dimName, dimNumber + "view"));
            rangeColIndex += 2;
        }
        headDates.add(ResManager.loadResFormat((String)"\u72b6\u6001%1", (String)"DimensionRelationUtils_06", (String)"epm-eb-common", (Object[])new Object[]{"(status)"}));
        String[] statusArr = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"DimensionRelationUtils_08", (String)"epm-eb-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528", (String)"DimensionRelationUtils_09", (String)"epm-eb-common", (Object[])new Object[0])};
        cellDropdownList.add(new CellDropdown(headDates.size() - 1, statusArr));
        if (!hasPeriodDim && !DimRelationScope.BIZMODEL.getIndex().equals(affectRange)) {
            headDates.add(ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4(startperiod)", (String)"DimensionRelationUtils_02", (String)"epm-eb-common", (Object[])new Object[0]));
            headDates.add(ResManager.loadKDString((String)"\u7981\u7528\u671f\u95f4(endperiod)", (String)"DimensionRelationUtils_03", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        String[] headData = headDates.toArray(new String[0]);
        ArrayList<String[]> headDataList = new ArrayList<String[]>(16);
        headDataList.add(headData);
        return Pair.of(headDataList, cellDropdownList);
    }

    private static CellDropdown getDimRangeDropdown(int colIndex) {
        CellDropdown cellDropdown = new CellDropdown();
        cellDropdown.setColIndex(colIndex);
        cellDropdown.setValues((String[])VALID_RANGE.stream().map(RangeEnum::getName).toArray(String[]::new));
        return cellDropdown;
    }

    private static CellDropdown getDimPropRangeDropdown(int colIndex) {
        CellDropdown cellDropdown = new CellDropdown();
        cellDropdown.setColIndex(colIndex);
        cellDropdown.setValues((String[])VALID_PROP_RANGE.stream().map(PropRangeEnum::getName).toArray(String[]::new));
        return cellDropdown;
    }

    public static DynamicObjectCollection getRelationDimension(String relationId) {
        return DimRelDao.getInstance().getRelationDimension(relationId);
    }

    public static void mergeNotLeafMember(IModelCacheHelper modelCache, Long viewId, String dimNumber, Set<String> relationMembers) {
        List<Member> members = modelCache.getMembers(viewId, dimNumber);
        relationMembers.addAll(members.stream().filter(member -> !member.isLeaf()).map(BaseCache::getNumber).collect(Collectors.toList()));
    }

    public static Map<Long, PropertyInfo> getPropertyInfoMap(List<DynamicObject> docs, DimRelation curRelation) {
        HashSet<Long> ids = new HashSet<Long>(docs.size());
        for (DynamicObject doc : docs) {
            Map<String, DimRelationEntry> dimMap = curRelation.getDimMap();
            for (Map.Entry<String, DimRelationEntry> entry : dimMap.entrySet()) {
                DimRelationEntry relationEntry = entry.getValue();
                Long propertyId = relationEntry.getPropertyId();
                long memberId = doc.getLong(entry.getKey());
                if (propertyId == null || propertyId == 0L) continue;
                ids.add(memberId);
            }
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"eb_custompropertyvalue", (String)"id, name, number", (QFilter[])qFilter.toArray());
        HashMap<Long, PropertyInfo> propertyInfoMap = new HashMap<Long, PropertyInfo>(objs.size());
        for (DynamicObject object : objs.values()) {
            long id = object.getLong("id");
            String number = object.getString("number");
            String name = object.getString("name");
            propertyInfoMap.put(id, new PropertyInfo(id, number, name));
        }
        return propertyInfoMap;
    }

    public static int getMaxSeq(Long relationId) {
        return DimMemRelDao.getInstance().getMaxSeq(relationId);
    }
}

