/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation.dao;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimMemRelDao;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.cache.Cache;
import org.apache.commons.lang3.StringUtils;

public class DimRelDao {
    private static final Log log = LogFactory.getLog(DimRelDao.class);
    private static final String ENTITY_NAME = "epm_dimensionrelation";
    public static final String CACHE_DIM_RELATION_VER = "CACHE_DIM_RELATION_VER";
    private static final String selectField = "id, affectrange, enable,update, version, businessmodel,entryentity, entryentity.dimension, entryentity.dimension.number, entryentity.dimension.name, entryentity.dimview, entryentity.dimviews, entryentity.dimproperty, entryentity.dimproperty.name, entryentity.seq";

    public static DimRelDao getInstance() {
        return InnerClass.instance;
    }

    private static Long loadVersion(long modelId, long relationId) {
        long version = 0L;
        QFilter qFilter = new QFilter("id", "=", (Object)relationId);
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"version", (QFilter[])qFilter.toArray());
        if (dyObj != null) {
            version = dyObj.getLong("version");
            Cache.get().set(DimRelDao.buildCacheKey(modelId, relationId), String.valueOf(version), 2, TimeUnit.HOURS);
        }
        return version;
    }

    private static String buildCacheKey(long modelId, long relationId) {
        return "CACHE_DIM_RELATION_VER_" + RequestContext.get().getAccountId() + '_' + modelId + '_' + relationId;
    }

    public Long getVersion(long modelId, long relationId) {
        long versionId = 0L;
        try {
            String version = Cache.get().get(DimRelDao.buildCacheKey(modelId, relationId));
            versionId = StringUtils.isBlank((CharSequence)version) ? DimRelDao.loadVersion(modelId, relationId).longValue() : IDUtils.toLong(version).longValue();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return versionId;
    }

    public void updateVersion(long modelId, long relationId) {
        if (IDUtils.isEmptyLong(relationId).booleanValue()) {
            return;
        }
        Long versionId = DBServiceHelper.genGlobalLongId();
        log.info("update dimension relation ver, relationId:{} newVer:{}", (Object)relationId, (Object)versionId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"id, version", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relationId)});
        dynamicObject.set("version", (Object)versionId);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        DimRelDao.loadVersion(modelId, relationId);
    }

    public DynamicObject getRelationById(Long modelId, Long relationId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("id", "=", (Object)relationId));
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
    }

    public List<Long> getRelationIdByModel(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] dyObjs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
        if (dyObjs.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(dyObjs).map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getRelationIdByBizModel(Long modelId, Long bizModelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("businessmodel.fbasedataid_id", "=", (Object)bizModelId).and(new QFilter("affectrange", "=", (Object)DimRelationScope.BIZMODEL.getIndex()));
        DynamicObject[] dyObjs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
        if (dyObjs.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(dyObjs).map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObjectCollection getRelationDimension(String relationId) {
        QFilter[] qFilters = new QFilter("id", "=", (Object)Long.parseLong(relationId)).toArray();
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilters, (String)"entryentity.seq");
    }

    public DynamicObject[] getRelation(Long modelId, Long bizModelId, List<Long> relationIds) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter qFilter1 = null;
        if (relationIds != null && !relationIds.isEmpty()) {
            qFilter1 = new QFilter("id", "in", relationIds);
        }
        if (bizModelId != null && bizModelId != 0L) {
            QFilter qFilter2 = new QFilter("businessmodel.fbasedataid_id", "=", (Object)bizModelId).and(new QFilter("affectrange", "=", (Object)DimRelationScope.BIZMODEL.getIndex()));
            if (qFilter1 == null) {
                qFilter1 = qFilter2;
            } else {
                qFilter1.or(qFilter2);
            }
        }
        qFilter.and(qFilter1);
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] getNeedUpdateRelation(Long modelId, List<Long> relationIds) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("update", "=", (Object)"0");
        if (CollectionUtils.isNotEmpty(relationIds)) {
            qFilter.and("id", "in", relationIds);
        }
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectField, (QFilter[])qFilter.toArray());
    }

    public void deleteRelation(long relationId) {
        try (TXHandle tx = TX.required();){
            try {
                int size = DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relationId)});
                if (size > 0) {
                    DimMemRelDao.getInstance().deleteByRelation(relationId);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final DimRelDao instance = new DimRelDao();

        private InnerClass() {
        }
    }
}

