/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.dimension.dimensionrelation.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimMemRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelDao;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DimRelUpdateDao {
    private static final Log log = LogFactory.getLog(DimRelUpdateDao.class);

    public static DimRelUpdateDao getInstance() {
        return InnerClass.instance;
    }

    public void updateRel(Long modelId, List<Long> relationIds) {
        DynamicObject[] relations = DimRelDao.getInstance().getNeedUpdateRelation(modelId, relationIds);
        if (relations.length == 0) {
            return;
        }
        List relIds = Arrays.stream(relations).map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("relationid", "in", relIds);
        List<DynamicObject> oldMember = DimMemRelDao.getInstance().getData(qFilter, 0, 0);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        oldMember.forEach(old -> {
            Long relationId = old.getLong("relationid.id");
            Optional<DynamicObject> relation = Arrays.stream(relations).filter(e -> relationId.equals(e.getLong("id"))).findFirst();
            if (relation.isPresent()) {
                DynamicObject dynamicObject = relation.get();
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject dimension : entry) {
                    String dimNumber = dimension.getString("dimension.number");
                    Long viewId = dimension.getLong("dimview.id");
                    int seq = dimension.getInt("seq");
                    String fieldName = "dimension" + seq + "view";
                    if (!View.NoViewDimNums.contains(dimNumber) && IDUtils.isEmptyLong(viewId).booleanValue()) {
                        viewId = modelCache.getDefaultViewIdOnDim(dimNumber);
                    }
                    if (!IDUtils.isEmptyLong(old.getLong(fieldName + ".id")).booleanValue() || View.NoViewDimNums.contains(dimNumber)) continue;
                    old.set(fieldName, (Object)viewId);
                }
            }
        });
        ArrayList<Object[]> newViewData = new ArrayList<Object[]>(16);
        for (DynamicObject relation : relations) {
            relation.set("update", (Object)"1");
            DynamicObjectCollection entry = relation.getDynamicObjectCollection("entryentity");
            for (DynamicObject dimension : entry) {
                Long id = GlobalIdUtil.genGlobalLongId();
                Long entryId = dimension.getLong("id");
                Long viewId = dimension.getLong("dimview.id");
                String dimNumber = dimension.getString("dimension.number");
                if (View.NoViewDimNums.contains(dimNumber)) continue;
                if (IDUtils.isEmptyLong(viewId).booleanValue()) {
                    viewId = modelCache.getDefaultViewIdOnDim(dimNumber);
                }
                Object[] newRowData = new Object[]{id, entryId, viewId};
                newViewData.add(newRowData);
            }
        }
        String viewInsertSql = "insert into t_eb_dimensionrelation_v(fpkid,fentryid,fbasedataid) values (?,?,?)";
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])relations);
                if (CollectionUtils.isNotEmpty(oldMember)) {
                    SaveServiceHelper.save((DynamicObject[])oldMember.toArray(new DynamicObject[0]));
                }
                if (CollectionUtils.isNotEmpty(newViewData)) {
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)viewInsertSql, newViewData);
                }
            }
            catch (Throwable e2) {
                tx.markRollback();
                log.error(e2.getMessage(), e2);
                throw new KDBizException(e2.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final DimRelUpdateDao instance = new DimRelUpdateDao();

        private InnerClass() {
        }
    }
}

