/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSObject;
import kd.epm.eb.common.ebComputing.ScopeInfo;
import kd.epm.eb.common.ebComputing.ScriptDimension;
import kd.epm.eb.common.ebComputing.ScriptMember;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.properties.IProperty;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;

@KSObject
public class ComputingContext
implements ScriptObject {
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private final Map<String, Pair<Long, String>> scopeItems;
    private final Stack<ScopeInfo> scopeStack = new Stack();
    private static final Map<String, IProperty> properties = new HashMap<String, IProperty>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private String runtime_Fy;
    private String runtime_Period;
    private Map<String, String> shortNumber2NumberMap = null;
    private Set<String> numberSet = null;

    public ComputingContext(OlapConnection olapConnection, IOutline outline, Map<String, Pair<Long, String>> scopeItems) {
        this.olapConnection = olapConnection;
        this.outline = outline;
        this.scopeItems = scopeItems;
        if (scopeItems != null) {
            ScopeInfo globalScope = new ScopeInfo();
            scopeItems.entrySet().forEach(e -> {
                globalScope.getFilters().add(new DimensionFilterItem((String)e.getKey(), (List)Lists.newArrayList((Object[])new String[]{(String)((Pair)e.getValue()).p2})));
                if (DimTypesEnum.YEAR.getNumber().equals(e.getKey())) {
                    this.runtime_Fy = (String)((Pair)e.getValue()).p2;
                } else if (DimTypesEnum.PERIOD.getNumber().equals(e.getKey())) {
                    this.runtime_Period = (String)((Pair)e.getValue()).p2;
                }
            });
            this.scopeStack.push(globalScope);
        }
    }

    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty()) {
            String number;
            if (this.shortNumber2NumberMap == null) {
                this.shortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap(this.outline.getModelNum());
                this.numberSet = new HashSet<String>(this.shortNumber2NumberMap.values());
            }
            if (this.numberSet.contains(propertyName)) {
                number = propertyName;
            } else {
                number = this.shortNumber2NumberMap.get(propertyName);
                if (number == null) {
                    throw new UnsupportedOperationException(String.format("ctx not supported property [%s] operate", propertyName));
                }
            }
            String cacheKey = String.format("%s|%s", this.outline.getModelNum(), number);
            Object v = this.cache.get(cacheKey);
            if (v != null) {
                if (v instanceof UnspecifiedDimension) {
                    return null;
                }
                return v;
            }
            IProperty p = properties.get(number);
            if (p != null) {
                v = p.get(propertyName, this.scopeItems, this.outline, this.olapConnection);
                if (v == null) {
                    this.cache.put(cacheKey, UnspecifiedDimension.instance);
                    return null;
                }
                this.cache.put(cacheKey, v);
                return v;
            }
            this.cache.put(cacheKey, UnspecifiedDimension.instance);
            return null;
        }
        throw new UnsupportedOperationException(String.format("ctx not supported property [%s] operate", propertyName));
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public IOutline getOutline() {
        return this.outline;
    }

    public Map<String, Pair<Long, String>> getScopeItems() {
        return this.scopeItems;
    }

    public void pushScope(ScopeInfo scope) {
        this.scopeStack.push(scope);
    }

    public void popScope() {
        if (this.scopeStack.size() <= 1) {
            throw new RuntimeException("endFix flag is not compared .");
        }
        this.scopeStack.pop();
    }

    public ScopeInfo getRuntimeScope(ScopeInfo info) {
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>(this.scopeStack);
        if (info != null) {
            scopes.add(info);
        }
        Collections.reverse(scopes);
        ScopeInfo runtimeScope = ScopeInfo.mergeReduce(scopes.toArray(new ScopeInfo[0]));
        runtimeScope.getFilters().forEach(f -> {
            if (DimTypesEnum.YEAR.getNumber().equals(f.getName())) {
                this.runtime_Fy = (String)f.getValues().get(0);
            } else if (DimTypesEnum.PERIOD.getNumber().equals(f.getName())) {
                this.runtime_Period = (String)f.getValues().get(0);
            }
        });
        if (info != null && !info.getExcludeFilterSet().isEmpty()) {
            runtimeScope.getFilters().removeIf(df -> info.getExcludeFilterSet().contains(df.getName()));
        }
        return runtimeScope;
    }

    public String getRuntimeFy() {
        return this.runtime_Fy;
    }

    public String getRuntimePeriod() {
        return this.runtime_Period;
    }

    private static void initProperties() {
        Pair[] ctxDims;
        for (Pair ctxDim : ctxDims = new Pair[]{Pair.onePair(DimTypesEnum.ENTITY, "epm_entitymembertree"), Pair.onePair(DimTypesEnum.CURRENCY, "epm_currencymembertree"), Pair.onePair(DimTypesEnum.YEAR, "epm_yearmembertree"), Pair.onePair(DimTypesEnum.PERIOD, "epm_periodmembertree"), Pair.onePair(DimTypesEnum.PROCESS, "epm_processmembertree"), Pair.onePair(DimTypesEnum.SCENARIO, "epm_scenemembertree")}) {
            String dimNumber = ((DimTypesEnum)((Object)ctxDim.p1)).getNumber();
            IProperty p = (name, scopeItems, outline, olapConnection) -> {
                Pair v = (Pair)scopeItems.get(dimNumber);
                if (v != null) {
                    Long id = (Long)v.p1;
                    IDNumberTreeNode node = MemberReader.findMemberById(outline.getModelNum(), (String)ctxDim.p2, id);
                    if (node != null) {
                        return ScriptMember.create(node.getNumber(), new ScriptDimension(dimNumber, olapConnection, outline), id);
                    }
                }
                return null;
            };
            properties.put(dimNumber, p);
        }
    }

    public String toString() {
        return this.scopeStack.toString();
    }

    static {
        ComputingContext.initProperties();
    }

    private static class UnspecifiedDimension {
        public static final UnspecifiedDimension instance = new UnspecifiedDimension();

        private UnspecifiedDimension() {
        }
    }
}

