/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.script.ScriptExecutor;
import kd.epm.eb.common.ebComputing.ComputingContext;
import kd.epm.eb.common.ebComputing.ScriptAnalyzeException;
import kd.epm.eb.common.ebComputing.VarProviderImpl;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.datasource.JavaScriptLoader;
import kd.epm.eb.common.ebComputing.datasource.Outline;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.ebcommon.common.threadlocal.ThreadLocalFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class ComputingEngine {
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(true, ComputingEngine.class);

    public ComputingEngine(OlapConnection olapConnection) {
        this.olapConnection = olapConnection;
        this.outline = new Outline(olapConnection);
    }

    public ComputingEngine(OlapConnection olapConnection, IOutline outline) {
        this.olapConnection = olapConnection;
        this.outline = outline;
    }

    private void initComputingContext4Outline(Map<String, Object> args) {
        this.outline.setComputingContext((ComputingContext)args.get("ctx"));
        if (this.outline.getComputingContext() == null) {
            this.outline.setComputingContext(new ComputingContext(this.olapConnection, this.outline, new HashMap<String, Pair<Long, String>>()));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String script, Map<String, Object> args) {
        log.startWatch();
        ScriptExecutor executor = ScriptExecutor.create();
        this.initComputingContext4Outline(args);
        VarProviderImpl varProvider = new VarProviderImpl(this.olapConnection, args, this.outline);
        String builtInScript = JavaScriptLoader.getInstance().getBizRuleScript();
        executor.init(ctx -> ctx.setVarProvider(varProvider));
        try {
            executor.begin();
            ((Context)executor.getContext()).getWrapFactory().setJavaPrimitiveWrap(false);
            executor.exec(new String[]{builtInScript});
            executor.exec(new String[]{script});
        }
        catch (ClassCastException e1) {
            try {
                log.error(e1);
                throw new RuntimeException(ResManager.loadKDString((String)"\u811a\u672c\u6216\u8005\u4f20\u53c2\u9519\u8bef\uff1a\u8bf7\u786e\u8ba4\u76f8\u5173\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"ComputingEngine_0", (String)"epm-eb-common", (Object[])new Object[0]), e1);
                catch (EvaluatorException e2) {
                    log.error(e2);
                    throw new RuntimeException(ResManager.loadResFormat((String)"\u811a\u672c[%1]\u6216\u8005\u4f20\u53c2\u9519\u8bef\uff1a%2", (String)"ComputingEngine_1", (String)"epm-eb-common", (Object[])new Object[]{script, e2.getMessage()}), e2);
                }
                catch (ScriptAnalyzeException e3) {
                    log.error(e3);
                    throw new RuntimeException(ResManager.loadResFormat((String)"\u811a\u672c\u89e3\u6790\u51fa\u9519\uff1a%1", (String)"ComputingEngine_2", (String)"epm-eb-common", (Object[])new Object[]{e3.getMessage()}), e3);
                }
                catch (Exception e4) {
                    log.error(e4);
                    throw new RuntimeException(ResManager.loadResFormat((String)"OLAP \u64cd\u4f5c\u5931\u8d25\uff1a%1", (String)"ComputingEngine_3", (String)"epm-eb-common", (Object[])new Object[]{e4.getMessage()}), e4);
                }
            }
            catch (Throwable throwable) {
                executor.end();
                log.info(String.format("%s,\u6267\u884c\u811a\u672c[%s],%s\u8017\u65f6", ThreadLocalFactory.getThreadLocalOprt(), script, args.toString()));
                throw throwable;
            }
        }
        executor.end();
        log.info(String.format("%s,\u6267\u884c\u811a\u672c[%s],%s\u8017\u65f6", ThreadLocalFactory.getThreadLocalOprt(), script, args.toString()));
    }
}

