/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebComputing.ScriptAnalyzeException;
import kd.epm.eb.common.ebComputing.ScriptMember;
import kd.epm.eb.common.ebComputing.datasource.OutlineNode;

public class ScopeInfo {
    private final Collection<DimensionFilterItem> filters;
    private final Set<String> excludeFilterSet = new HashSet<String>(1);

    public ScopeInfo() {
        this.filters = new ArrayList<DimensionFilterItem>();
    }

    public Set<String> getExcludeFilterSet() {
        return this.excludeFilterSet;
    }

    public ScopeInfo(Collection<DimensionFilterItem> filters) {
        this.filters = filters;
    }

    public final Collection<DimensionFilterItem> getFilters() {
        return this.filters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopeInfo{");
        if (this.filters != null) {
            this.filters.forEach(f -> sb.append(String.format("%s:[%s],", f.getName(), String.join((CharSequence)",", f.getValues()))));
        }
        sb.append('}');
        return sb.toString();
    }

    @Deprecated
    private ScopeInfo and(ScopeInfo ... scopes) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>();
        for (DimensionFilterItem filter : this.filters) {
            List values = filter.getValues();
            if (values.isEmpty()) continue;
            HashSet filterValues = new HashSet(values);
            tempMap.put(filter.getName(), filterValues);
        }
        this.mergeScope(scopes, tempMap);
        ArrayList<DimensionFilterItem> tempFilter = new ArrayList<DimensionFilterItem>(tempMap.size());
        for (Map.Entry entry : tempMap.entrySet()) {
            DimensionFilterItem filterItem = new DimensionFilterItem();
            filterItem.setName((String)entry.getKey());
            Set values = (Set)entry.getValue();
            ArrayList newValues = new ArrayList();
            values.forEach(e -> {
                if (StringUtils.isNotEmpty((String)e)) {
                    newValues.add(e);
                }
            });
            filterItem.addAllValues(newValues);
            tempFilter.add(filterItem);
        }
        return new ScopeInfo(tempFilter);
    }

    private void mergeScope(ScopeInfo[] scopes, Map<String, Set<String>> tempMap) {
        for (ScopeInfo scope : scopes) {
            for (DimensionFilterItem filter : scope.getFilters()) {
                String dimName = filter.getName();
                Set<String> filterValues = tempMap.get(dimName);
                if (filterValues == null) {
                    filterValues = new HashSet<String>();
                }
                filterValues.addAll(filter.getValues());
                tempMap.put(dimName, filterValues);
            }
        }
    }

    public ScopeInfo and(Object ... anys) {
        return this.scope(anys);
    }

    public ScopeInfo scope(Object ... anys) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>();
        for (DimensionFilterItem filter : this.filters) {
            List values = filter.getValues();
            if (values.isEmpty()) continue;
            HashSet filterValues = new HashSet(values);
            tempMap.put(filter.getName(), filterValues);
        }
        if (anys[0] instanceof Object[] && anys.length == 1) {
            Object items = anys[0];
            this.merge(new Object[]{items}, tempMap);
        } else {
            this.merge(anys, tempMap);
        }
        ArrayList<DimensionFilterItem> tempFilter = new ArrayList<DimensionFilterItem>(tempMap.size());
        for (Map.Entry entry : tempMap.entrySet()) {
            DimensionFilterItem filterItem = new DimensionFilterItem();
            filterItem.setName((String)entry.getKey());
            Set values = (Set)entry.getValue();
            ArrayList newValues = new ArrayList();
            values.forEach(e -> {
                if (StringUtils.isNotEmpty((String)e)) {
                    newValues.add(e);
                }
            });
            filterItem.addAllValues(newValues);
            tempFilter.add(filterItem);
        }
        return new ScopeInfo(tempFilter);
    }

    private void merge(Object[] anys, Map<String, Set<String>> tempMap) {
        for (Object any : anys) {
            if (any instanceof ScriptMember) {
                Set members = tempMap.computeIfAbsent(((ScriptMember)any).getDimension().getNumber(), k -> new HashSet());
                members.add(((ScriptMember)any).getNumber());
                continue;
            }
            if (any instanceof ScopeInfo) {
                for (DimensionFilterItem filter : ((ScopeInfo)any).getFilters()) {
                    List values = filter.getValues();
                    String dimName = filter.getName();
                    Set members = tempMap.computeIfAbsent(dimName, k -> new HashSet());
                    members.addAll(values);
                }
                continue;
            }
            if (any instanceof String) {
                int beforeIndex = ((String)any).indexOf(91);
                int afterIndex = ((String)any).indexOf(93);
                if (beforeIndex < 0 || afterIndex < 0) {
                    throw new RuntimeException("the format of string: " + any + " is unSupport");
                }
                String dimName = ((String)any).substring(0, beforeIndex).trim();
                String subStr = ((String)any).substring(beforeIndex + 1, afterIndex).trim();
                String[] array = subStr.split(",");
                Set members = tempMap.computeIfAbsent(dimName, k -> new HashSet());
                members.addAll(Arrays.asList(array));
                continue;
            }
            if (any instanceof List) {
                for (Object obj : (List)any) {
                    Set members;
                    if (obj instanceof OutlineNode) {
                        members = tempMap.computeIfAbsent(((OutlineNode)obj).getDimension(), k -> new HashSet());
                        members.add(((OutlineNode)obj).getNumber());
                        continue;
                    }
                    if (obj instanceof ScriptMember) {
                        members = tempMap.computeIfAbsent(((ScriptMember)any).getDimension().getNumber(), k -> new HashSet());
                        members.add(((ScriptMember)any).getNumber());
                        continue;
                    }
                    if (obj instanceof Object[]) {
                        this.merge((Object[])obj, tempMap);
                        continue;
                    }
                    if (!(obj instanceof List)) continue;
                    this.merge(((List)obj).toArray(), tempMap);
                }
                continue;
            }
            if (any instanceof Object[]) {
                this.merge((Object[])any, tempMap);
                continue;
            }
            throw new ScriptAnalyzeException(ResManager.loadResFormat((String)"\u6784\u9020\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u65f6\uff0c\u4f7f\u7528\u4e86\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b\uff1a%1", (String)"ScopeInfo_0", (String)"epm-eb-common", (Object[])new Object[]{any.getClass()}));
        }
    }

    public static boolean instance(Object arg) {
        return arg instanceof ScopeInfo;
    }

    public static ScopeInfo create(Object ... scopeInfo) {
        ScopeInfo newScopeInfo = new ScopeInfo();
        newScopeInfo = newScopeInfo.scope(scopeInfo);
        return newScopeInfo;
    }

    public static ScopeInfo mergeReduce(ScopeInfo ... infos) {
        ScopeInfo newScope = new ScopeInfo();
        for (ScopeInfo s : infos) {
            ScopeInfo.mergeReduceFilter(newScope, s);
        }
        return newScope;
    }

    public static ScopeInfo doMergeReduce(ScopeInfo scope1, ScopeInfo scope2, boolean isReturnNewScope) {
        if (isReturnNewScope) {
            ScopeInfo newScope = new ScopeInfo();
            ScopeInfo.mergeReduceFilter(newScope, scope1);
            ScopeInfo.mergeReduceFilter(newScope, scope2);
            return newScope;
        }
        ScopeInfo.mergeReduceFilter(scope1, scope2);
        return scope1;
    }

    private static void mergeReduceFilter(ScopeInfo scope1, ScopeInfo scope2) {
        Collection<DimensionFilterItem> filters1 = scope1.getFilters();
        Collection<DimensionFilterItem> filters2 = scope2.getFilters();
        HashSet dimNames = new HashSet(filters1.size());
        filters1.forEach(f -> dimNames.add(f.getName()));
        filters2.forEach(f -> {
            if (!dimNames.contains(f.getName())) {
                filters1.add(new DimensionFilterItem(f.getName(), f.getValues()));
            }
        });
    }

    public ScopeInfo exclude(String dimNum) {
        this.excludeFilterSet.add(dimNum);
        return this;
    }
}

