/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.LambdaExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebComputing.LambdaParser;
import kd.epm.eb.common.ebComputing.ScopeInfo;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.datasource.ScriptAgg;
import kd.epm.eb.common.ebComputing.member.ScriptCellSet;
import kd.epm.eb.common.ebComputing.util.OlapQueryHelper;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.msservice.param.ConvertParam;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ScriptBuiltin {
    public static final String tracer_type = "olap";
    public static final String audit_name = "olap_cost";
    public static final String tracer_dbroutekey = "route";
    public static final String tracer_sql = "sql";
    public static final int cellSet_max_count = 100000;
    private final OlapConnection olapConnection;
    private final Map<String, Object> args;
    private final IOutline outline;
    private static List<String> dims = Arrays.asList(PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM);

    public ScriptBuiltin(OlapConnection olapConnection, Map<String, Object> args, IOutline outline) {
        this.olapConnection = olapConnection;
        this.args = args;
        this.outline = outline;
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public IOutline getOutline() {
        return this.outline;
    }

    public String[] split(String s, String regex) {
        return s.split(regex);
    }

    @KSMethod
    @Deprecated
    public void compute(String engineType, String mainDimension, ScopeInfo scopeInfo, String expression, String ... memberNames) {
        String member;
        int index;
        FelLambdaExpressionItem item;
        if (StringUtils.isEmpty((String)engineType)) {
            engineType = "fel";
        }
        ComputingCommandInfo command = new ComputingCommandInfo();
        command.setFilter((List)scopeInfo.getFilters());
        if ("fel".equals(engineType)) {
            item = new FelLambdaExpressionItem();
        } else if ("js".equals(engineType)) {
            item = new LambdaExpressionItem();
        } else {
            throw new RuntimeException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5f15\u64ce\u7c7b\u578b\u201c%1\u201d\u3002", (String)"ScriptBuiltin_0", (String)"epm-eb-common", (Object[])new Object[]{engineType}));
        }
        if ("fel".equals(engineType)) {
            Pair<String, String> pair = LambdaParser.parseExpression(expression);
            item.setExpressLeft((String)pair.getLeft());
            item.setExpression((String)pair.getRight());
            for (index = 0; index < memberNames.length; ++index) {
                member = memberNames[index];
                if (member == null) continue;
                item.addExpressRight(member);
            }
        } else if ("js".equals(engineType)) {
            item.setExpression(expression);
            if (memberNames.length <= 0) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u6ca1\u6709\u4f20\u5165\u8868\u8fbe\u5f0f\u5de6\u4fa7\u53ca\u53f3\u4fa7\u7684\u8ba1\u7b97\u56e0\u5b50\u3002", (String)"ScriptBuiltin_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            String leftMember = memberNames[0];
            if (leftMember == null || leftMember.isEmpty()) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u5de6\u4fa7\u8868\u8fbe\u5f0f\u7f3a\u5931\u3002", (String)"ScriptBuiltin_2", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            item.setExpressLeft(leftMember);
            for (index = 1; index < memberNames.length; ++index) {
                member = memberNames[index];
                if (member == null) continue;
                item.addExpressRight(member);
            }
        }
        ArrayList<FelLambdaExpressionItem> list = new ArrayList<FelLambdaExpressionItem>();
        list.add(item);
        command.getExpressionItems().addAll(list);
        command.setMainDimName(mainDimension);
        command.setMainMeaName("FMONEY");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, ShrekIdCodeUtils.getDefaultIdCodes(null));
        OlapCommand cmd = new OlapCommand(this.olapConnection, (CommandInfo)command);
        try (MemSpanTrace span = MemSpanTrace.create((String)tracer_type, (String)"compute");
             TraceSpan ts = Tracer.create((String)tracer_type, (String)"compute");
             Auditable audit = Audit.audit((String)audit_name, (Object[])new Object[]{"compute", command});){
            if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)tracer_type)) {
                ts.addTag(tracer_sql, command.toString());
            }
            cmd.executeCompute();
        }
    }

    @KSMethod
    public void compute(String engineType, String mainDimension, ScopeInfo scopeInfo, String ... expressions) {
        if (StringUtils.isEmpty((String)engineType)) {
            engineType = "fel";
        }
        ComputingCommandInfo command = new ComputingCommandInfo();
        command.setFilter((List)scopeInfo.getFilters());
        ArrayList<FelLambdaExpressionItem> list = new ArrayList<FelLambdaExpressionItem>(expressions.length);
        for (String expression : expressions) {
            if (!"fel".equals(engineType)) {
                throw new RuntimeException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5f15\u64ce\u7c7b\u578b\u201c%1\u201d\u3002", (String)"ScriptBuiltin_0", (String)"epm-eb-common", (Object[])new Object[]{engineType}));
            }
            FelLambdaExpressionItem item = new FelLambdaExpressionItem();
            if ("fel".equals(engineType)) {
                Pair<String, String> pair = LambdaParser.parseExpression(expression);
                item.setExpressLeft((String)pair.getLeft());
                item.setExpression((String)pair.getRight());
            }
            list.add(item);
        }
        command.getExpressionItems().addAll(list);
        command.setMainDimName(mainDimension);
        command.setMainMeaName("FMONEY");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, ShrekIdCodeUtils.getDefaultIdCodes(null));
        OlapCommand cmd = new OlapCommand(this.olapConnection, (CommandInfo)command);
        cmd.executeCompute();
    }

    @KSMethod
    public void computeSerial(String engineType, String mainDimension, ScopeInfo scopeInfo, String ... expressions) {
        if (StringUtils.isEmpty((String)engineType)) {
            engineType = "fel";
        }
        ComputingCommandInfo command = new ComputingCommandInfo();
        command.setFilter((List)scopeInfo.getFilters());
        command.setMainDimName(mainDimension);
        command.setMainMeaName("FMONEY");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, ShrekIdCodeUtils.getDefaultIdCodes(null));
        for (String expression : expressions) {
            FelLambdaExpressionItem item = new FelLambdaExpressionItem();
            Pair<String, String> pair = LambdaParser.parseExpression(expression);
            item.setExpressLeft((String)pair.getLeft());
            item.setExpression((String)pair.getRight());
            command.getExpressionItems().clear();
            command.getExpressionItems().add(item);
            OlapCommand cmd = new OlapCommand(this.olapConnection, (CommandInfo)command);
            cmd.executeCompute();
        }
    }

    @KSMethod
    public void agg(ScopeInfo scopeInfo, String ... memberNames) {
        ScriptAgg scriptAgg = new ScriptAgg(this.olapConnection, this.outline);
        scriptAgg.agg(scopeInfo, memberNames);
    }

    @KSMethod
    public ScopeInfo create(Object ... scopeInfo) {
        return ScopeInfo.create(scopeInfo);
    }

    @KSMethod
    public ScopeInfo mergeScope(ScopeInfo scope, ScopeInfo pageIncomeScope, String expression) {
        ScopeInfo newScope = new ScopeInfo();
        newScope.getFilters().addAll(scope.getFilters());
        if (pageIncomeScope != null) {
            Collection<DimensionFilterItem> filters = pageIncomeScope.getFilters();
            for (DimensionFilterItem filterItem : filters) {
                boolean match;
                String dimNumber = filterItem.getName();
                if (expression.contains(dimNumber + ".") || expression.contains(dimNumber + "@") || (match = scope.getFilters().stream().map(DimensionFilterItem::getName).anyMatch(name -> name.equals(dimNumber)))) continue;
                DimensionFilterItem item = new DimensionFilterItem();
                item.setName(dimNumber);
                item.getValues().addAll(filterItem.getValues());
                newScope.getFilters().add(item);
            }
        }
        return newScope;
    }

    @KSMethod
    public BigDecimal evalOld(ScopeInfo scopeInfo, String expression) {
        Map<String, String> short2NumMap = MemberReader.getDimensionShortNumber2NumberMap(this.outline.getModelNum());
        String[] dimMembers = expression.split(",");
        Collection<DimensionFilterItem> filters = scopeInfo.getFilters();
        HashMap<String, List> map = new HashMap<String, List>(dimMembers.length + filters.size());
        filters.forEach(filter -> {
            String dimNum = short2NumMap.getOrDefault(filter.getName(), filter.getName());
            map.put(dimNum, filter.getValues());
        });
        for (String dimMenber : dimMembers) {
            String[] dimMenberSplit = dimMenber.contains("@") ? dimMenber.split("@") : dimMenber.split("\\.");
            if (dimMenberSplit.length != 2) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"ScriptBuiltin_3", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            String key = dimMenberSplit[0];
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(dimMenberSplit[1]);
            String dimNum = short2NumMap.getOrDefault(key, key);
            map.put(dimNum, list);
        }
        SelectCommandInfo commandInfo = new SelectCommandInfo();
        map.forEach((k, v) -> {
            String dimNum = short2NumMap.containsKey(k) ? (String)short2NumMap.get(k) : k;
            commandInfo.addDims(new String[]{dimNum});
            commandInfo.addFilter(dimNum, v.toArray(new String[0]));
        });
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        commandInfo.setTop(2);
        List<Map<String, Object>> resultList = OlapQueryHelper.queryData(commandInfo, this.olapConnection);
        if (resultList.size() == 1) {
            Map<String, Object> result = resultList.get(0);
            if (result != null) {
                Object o = result.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
                return o instanceof Long ? BigDecimal.valueOf((Long)o) : (BigDecimal)o;
            }
        } else if (resultList.size() > 1) {
            throw new IllegalArgumentException(ResManager.loadResFormat((String)"\u201c%1\u201d\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5scope\u201c%2\u201d\u3002", (String)"ScriptBuiltin_4", (String)"epm-eb-common", (Object[])new Object[]{expression, scopeInfo}));
        }
        return BigDecimal.ZERO;
    }

    public Object eval(ScopeInfo scopeInfo, Object defaultValue) {
        ScopeInfo targetScope = this.getTargetScope(scopeInfo);
        Collection<DimensionFilterItem> targetFilters = targetScope.getFilters();
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        targetFilters.forEach(f -> {
            String key = f.getName();
            List values = f.getValues();
            if (values.size() > 1) {
                throw new IllegalArgumentException(ResManager.loadResFormat((String)"V\u51fd\u6570\u4e2d\u7ef4\u5ea6\u201c%1\u201d\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5Scope\u201c%2\u201d\u3002", (String)"ScriptBuiltin_5", (String)"epm-eb-common", (Object[])new Object[]{key, targetScope}));
            }
            if (values.size() == 0) {
                throw new IllegalArgumentException(ResManager.loadResFormat((String)"V\u51fd\u6570\u4e2d\u7ef4\u5ea6\u201c%1\u201d\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5Scope\u201c%2\u201d\u3002", (String)"ScriptBuiltin_5", (String)"epm-eb-common", (Object[])new Object[]{key, targetScope}));
            }
            selectCommandInfo.addFilter(key, values.toArray(new String[0]));
        });
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        List<Map<String, Object>> resultList = OlapQueryHelper.queryData(selectCommandInfo, this.olapConnection);
        if (resultList.size() == 1) {
            Map<String, Object> result = resultList.get(0);
            if (result != null) {
                Object measure = result.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (measure == null) {
                    return defaultValue instanceof Number ? new BigDecimal(defaultValue.toString()) : defaultValue;
                }
                if (measure instanceof BigDecimal) {
                    return measure;
                }
                return measure instanceof Number ? new BigDecimal(measure.toString()) : measure;
            }
        } else if (resultList.size() > 1) {
            throw new IllegalArgumentException(ResManager.loadResFormat((String)"V\u51fd\u6570\u53d6\u6570\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5Scope\u201c%1\u201d\u3002", (String)"ScriptBuiltin_6", (String)"epm-eb-common", (Object[])new Object[]{scopeInfo}));
        }
        if (defaultValue == null) {
            return null;
        }
        return defaultValue instanceof Number ? new BigDecimal(defaultValue.toString()) : defaultValue;
    }

    private ScopeInfo getTargetScope(ScopeInfo scopeInfo) {
        Collection<String> dimNumbers = MemberReader.getDimensionShortNumber2NumberMap(this.outline.getModelNum()).values();
        ScopeInfo fixScope = this.outline.getComputingContext().getRuntimeScope(null);
        Collection<DimensionFilterItem> fixFilters = fixScope.getFilters();
        List fixNames = fixFilters.stream().map(map -> map.getName()).collect(Collectors.toList());
        Collection<DimensionFilterItem> filters = scopeInfo.getFilters();
        filters.forEach(f -> {
            String key = f.getName();
            if (fixNames.contains(key)) {
                throw new IllegalArgumentException(ResManager.loadResFormat((String)"FixScope\u5df2\u6307\u5b9a\u7ef4\u5ea6\u201c%1\u201d\uff0c\u8bf7\u68c0\u67e5Scope\u201c%2\u201d\u3002", (String)"ScriptBuiltin_7", (String)"epm-eb-common", (Object[])new Object[]{key, scopeInfo}));
            }
        });
        ScopeInfo targetScope = ScopeInfo.mergeReduce(scopeInfo, fixScope);
        Collection<DimensionFilterItem> targetFilters = targetScope.getFilters();
        if (dimNumbers.size() != targetFilters.size()) {
            List targetNames = targetFilters.stream().map(p -> p.getName()).collect(Collectors.toList());
            dimNumbers.forEach(dimNumber -> {
                if (!targetNames.contains(dimNumber)) {
                    throw new IllegalArgumentException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6307\u5b9a\u4e0d\u5168\uff0c\u8bf7\u8bbe\u7f6e\u7ef4\u5ea6\u201c%1\u201d\uff0cScope\u201c%2\u201d\u3002", (String)"ScriptBuiltin_8", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, targetScope}));
                }
            });
        }
        return targetScope;
    }

    public void save(ScopeInfo scopeInfo, Object value) {
    }

    public ScriptCellSet getCellSet(ScopeInfo scopeInfo) {
        ArrayList<String> selectDims = new ArrayList<String>(MemberReader.getDimensionShortNumber2NumberMap(this.outline.getModelNum()).values());
        Collection<DimensionFilterItem> targetFilters = scopeInfo.getFilters();
        ArrayList<DimensionFilterItem> fixDims = new ArrayList<DimensionFilterItem>();
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        for (DimensionFilterItem f : targetFilters) {
            String key = f.getName();
            List values = f.getValues();
            int size = values.size();
            if (size > 1) {
                selectCommandInfo.addFilter(key, values.toArray(new String[0]));
                memberMap.put(key, new HashSet(values));
                continue;
            }
            if (size != 1) continue;
            fixDims.add(new DimensionFilterItem(key, values));
            selectDims.remove(key);
            selectCommandInfo.addFilter(key, values.toArray(new String[0]));
        }
        if (selectDims.size() == 0) {
            throw new IllegalArgumentException(String.format("getCellSet method select Dimension length must more than 1,but it is %d", selectDims.size()));
        }
        selectCommandInfo.addDims(selectDims.toArray(new String[0]));
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapCommand olapCommand = new OlapCommand(this.olapConnection, (CommandInfo)selectCommandInfo);
        CellSet cellSet = olapCommand.executeCellSet((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
        if (cellSet.getCount() > 100000) {
            throw new IllegalArgumentException(String.format("getCellSet load data count must less than %d ,but count is %d", 100000, cellSet.getCount()));
        }
        return new ScriptCellSet(this.olapConnection, cellSet, fixDims, selectDims, memberMap);
    }

    public void runConvert(ScopeInfo scopeInfo, String srcCurrency, String targetCurrency) {
        if (srcCurrency.equals(targetCurrency)) {
            return;
        }
        String modelNum = this.outline.getModelNum();
        DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id", (QFilter[])new QFilter("number", "=", (Object)modelNum).toArray());
        if (doj == null) {
            return;
        }
        kd.epm.eb.common.ebcommon.common.Pair<Long, String> model = kd.epm.eb.common.ebcommon.common.Pair.onePair(doj.getLong("id"), modelNum);
        QFilter filter = new QFilter("model", "=", (Object)doj.getLong("id"));
        QFilter targetFilter = new QFilter("number", "=", (Object)targetCurrency);
        DynamicObject targetCurrencyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{filter, targetFilter});
        QFilter srcFilter = new QFilter("number", "=", (Object)srcCurrency);
        DynamicObject srcCurrencyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{filter, srcFilter});
        kd.epm.eb.common.ebcommon.common.Pair<Long, String> cvtCurrency = kd.epm.eb.common.ebcommon.common.Pair.onePair(targetCurrencyObj.getLong("id"), targetCurrency);
        ConvertParam param = new ConvertParam(null, cvtCurrency, model);
        for (DimensionFilterItem item : scopeInfo.getFilters()) {
            String dimNumber = item.getName();
            if (dims.contains(dimNumber)) {
                QFilter filter1 = new QFilter("number", "=", item.getValues().get(0));
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.getEnumByNumber(dimNumber).getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{filter, filter1});
                param.addFixScope(dimNumber, (String)item.getValues().get(0), obj.getLong("id"));
                continue;
            }
            param.addScope(item.getName(), item.getValues().toArray(new String[0]));
        }
        param.addFixScope(PresetConstant.CURRENCY_DIM, srcCurrency, srcCurrencyObj.getLong("id"));
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"ConvertService", (String)"convert", (Object[])new Object[]{param.toString()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

