/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.epm.eb.common.ebComputing.ScopeInfo;
import kd.epm.eb.common.ebComputing.ScriptAnalyzeException;
import kd.epm.eb.common.ebComputing.ScriptBuiltin;
import kd.epm.eb.common.ebComputing.ScriptMember;
import kd.epm.eb.common.ebComputing.ScriptNode;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.datasource.OutlineNode;
import kd.epm.eb.common.ebComputing.datasource.ScriptAgg;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;

@KSObject
public class ScriptDimension
extends ScriptNode {
    private OlapConnection olapConnection;
    private final IOutline outline;
    private final Map<String, ScriptMember> map = new HashMap<String, ScriptMember>();

    public ScriptDimension(String number, OlapConnection olapConnection, IOutline outline) {
        super(number);
        this.olapConnection = olapConnection;
        this.outline = outline;
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public void setOlapConnection(OlapConnection olapConnection) {
        this.olapConnection = olapConnection;
    }

    @Override
    public IOutline getOutline() {
        return this.outline;
    }

    public Map<String, ScriptMember> getMap() {
        return this.map;
    }

    public Object __getUndefinedElement(Object element) {
        if (element instanceof String) {
            String eleStr = (String)element;
            ScriptMember member = this.map.get(eleStr);
            if (member == null) {
                int firstExclamationMark = eleStr.indexOf("!");
                if (firstExclamationMark >= 0) {
                    String _longNumber = firstExclamationMark == 0 ? this.number + eleStr : this.number + '!' + eleStr;
                    String modelNum = this.outline.getModelNum();
                    IDNumberTreeNode node = MemberReader.findMemberByLongNumber(modelNum, this.number, _longNumber);
                    if (node == IDNumberTreeNode.NotFoundTreeNode) {
                        throw new ScriptAnalyzeException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e2d\u627e\u4e0d\u5230\u6210\u5458\uff1a%2\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"ScriptDimension_0", (String)"epm-eb-common", (Object[])new Object[]{this.number, _longNumber}));
                    }
                    member = ScriptMember.create(node.getNumber(), this, node.getId());
                    this.map.put(eleStr, member);
                    return member;
                }
                return this.__getUndefinedProperty(eleStr);
            }
            return member;
        }
        throw new UnsupportedOperationException(String.format("%s not supported property [%s] operate", this.number, element));
    }

    @Override
    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.trim().isEmpty()) {
            if ("number".equals(propertyName)) {
                return this.number;
            }
            if ("members".equals(propertyName)) {
                String modelNum = this.outline.getModelNum();
                Collection<IDNumberTreeNode> nodes = MemberReader.getAllNodeByDimNum(this.number, modelNum);
                ArrayList<ScriptMember> members = new ArrayList<ScriptMember>();
                for (IDNumberTreeNode node : nodes) {
                    members.add(ScriptMember.create(node.getNumber(), this, node.getId()));
                }
                return members.toArray();
            }
            ScriptMember member = this.map.get(propertyName);
            if (member == null) {
                OutlineNode memberNode = this.outline.tryGetNode(this.number + "@" + propertyName);
                if (memberNode != null) {
                    member = ScriptMember.create(memberNode.getNumber(), this, memberNode.getId());
                    this.map.put(propertyName, member);
                    return member;
                }
            } else {
                return member;
            }
        }
        throw new UnsupportedOperationException(String.format("%s not supported property [%s] operate", this.number, propertyName));
    }

    @KSMethod
    public ScopeInfo In(String ... memberNames) {
        DimensionFilterItem filterItem = new DimensionFilterItem();
        filterItem.setName(this.number);
        filterItem.getValues().addAll(Arrays.asList(memberNames));
        ArrayList<DimensionFilterItem> list = new ArrayList<DimensionFilterItem>();
        list.add(filterItem);
        return new ScopeInfo(list);
    }

    @KSMethod
    public ScopeInfo in(String ... memberNames) {
        return this.In(memberNames);
    }

    public AggPair member(String memberName) {
        return new AggPair(this.number, null);
    }

    @KSMethod
    public void agg(ScopeInfo scopeInfo, String ... memberNames) {
        ScriptAgg scriptAgg = new ScriptAgg(this.olapConnection);
        scriptAgg.agg(scopeInfo, memberNames);
    }

    @KSMethod
    public void compute(ScopeInfo scopeInfo, String expression, String ... memberNames) {
        ScriptBuiltin builtin = new ScriptBuiltin(this.olapConnection, null, this.outline);
        builtin.compute("js", this.number, scopeInfo, expression, memberNames);
    }

    @KSMethod
    public void run(ScopeInfo scopeInfo, String expression, String ... memberNames) {
        ScriptBuiltin builtin = new ScriptBuiltin(this.olapConnection, null, this.outline);
        builtin.compute("fel", this.number, scopeInfo, expression, memberNames);
    }

    @KSMethod
    public void run(ScopeInfo scopeInfo, String expression) {
        this.run(scopeInfo, expression, new String[0]);
    }
}

