/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.epm.eb.common.ebComputing.ScriptAnalyzeException;
import kd.epm.eb.common.ebComputing.ScriptDimension;
import kd.epm.eb.common.ebComputing.ScriptNode;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.member.ScriptMemberAccountNode;
import kd.epm.eb.common.ebComputing.member.ScriptMemberCurrencyNode;
import kd.epm.eb.common.ebComputing.member.ScriptMemberEntityNode;
import kd.epm.eb.common.ebComputing.member.ScriptMemberPeriodNode;
import kd.epm.eb.common.ebComputing.member.ScriptMemberProcessNode;
import kd.epm.eb.common.ebComputing.member.ScriptMemberScenarioNode;
import kd.epm.eb.common.ebComputing.member.ScriptMemberYearNode;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;

public class ScriptMember
extends ScriptNode
implements ScriptObject {
    private final ScriptDimension dimension;
    private final long id;
    private IDNumberTreeNode _currentNode = null;
    private Set<String> _dimensionPropSet = null;

    public ScriptDimension getDimension() {
        return this.dimension;
    }

    public ScriptMember(String number, ScriptDimension dimension, long id) {
        super(number);
        this.dimension = dimension;
        this.id = id;
    }

    public static ScriptMember create(String number, ScriptDimension dimension, long id) {
        if (DimTypesEnum.CURRENCY.getNumber().equals(dimension.number)) {
            return new ScriptMemberCurrencyNode(number, dimension, id);
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(dimension.number)) {
            return new ScriptMemberEntityNode(number, dimension, id);
        }
        if (DimTypesEnum.YEAR.getNumber().equals(dimension.number)) {
            return new ScriptMemberYearNode(number, dimension, id);
        }
        if (DimTypesEnum.PERIOD.getNumber().equals(dimension.number)) {
            return new ScriptMemberPeriodNode(number, dimension, id);
        }
        if (DimTypesEnum.PROCESS.getNumber().equals(dimension.number)) {
            return new ScriptMemberProcessNode(number, dimension, id);
        }
        if (DimTypesEnum.SCENARIO.getNumber().equals(dimension.number)) {
            return new ScriptMemberScenarioNode(number, dimension, id);
        }
        if (DimTypesEnum.ACCOUNT.getNumber().equals(dimension.number)) {
            return new ScriptMemberAccountNode(number, dimension, id);
        }
        return new ScriptMember(number, dimension, id);
    }

    @Override
    public IOutline getOutline() {
        return this.dimension.getOutline();
    }

    protected IDNumberTreeNode getIDNumberTreeNode() {
        if (this._currentNode == null) {
            IOutline outline = this.getOutline();
            String modelNum = outline.getModelNum();
            this._currentNode = this.getIDNumberTreeNode(modelNum, DimEntityNumEnum.getEntieyNumByNumber(this.dimension.number), this.id);
        }
        return this._currentNode;
    }

    protected IDNumberTreeNode getIDNumberTreeNode(String modelNum, String entityNum, Long id) {
        return MemberReader.findMemberById(modelNum, DimEntityNumEnum.getEntieyNumByNumber(this.dimension.number), id);
    }

    private Set<String> getDimensionPropSet() {
        if (this._dimensionPropSet == null) {
            IOutline outline = this.getOutline();
            String modelNum = outline.getModelNum();
            List<String> dimensionPropList = MemberReader.getDimensionProp(modelNum, this.dimension.number);
            this._dimensionPropSet = new HashSet<String>(dimensionPropList);
        }
        return this._dimensionPropSet;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ScriptMember) {
            ScriptMember other = (ScriptMember)obj;
            if (!this.dimension.getNumber().equals(other.dimension.getNumber())) {
                return false;
            }
        }
        return super.equals(obj);
    }

    @Override
    public int scriptCompareTo(Object o) {
        if (o instanceof ScriptMember) {
            ScriptMember other = (ScriptMember)o;
            if (!this.dimension.getNumber().equals(other.dimension.getNumber())) {
                return -1;
            }
        }
        return super.scriptCompareTo(o);
    }

    public Object __getUndefinedElement(Object element) {
        if (element instanceof String) {
            return this.__getUndefinedProperty((String)element);
        }
        throw new UnsupportedOperationException(String.format("%s not supported property [%s] operate", this.number, element));
    }

    @Override
    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.trim().isEmpty()) {
            if ("longNumber".equals(propertyName)) {
                return this.getIDNumberTreeNode().getLongNumber();
            }
            if ("aggOprt".equals(propertyName)) {
                return this.getIDNumberTreeNode().getAggOprt();
            }
            if ("storageType".equals(propertyName)) {
                return this.getIDNumberTreeNode().getStorageType().toString();
            }
            if ("dataType".equalsIgnoreCase(propertyName)) {
                return this.getIDNumberTreeNode().loadAndConsumerProp("datatype", dyna -> dyna.getInt("datatype"));
            }
            if (this.getDimensionPropSet().contains(propertyName)) {
                return this.getIDNumberTreeNode().getCustomPropVal(propertyName);
            }
        }
        return super.__getUndefinedProperty(propertyName);
    }

    @KSMethod
    public boolean isChild(String memberNumber) {
        this.checkNumberIsNotNull(memberNumber);
        IDNumberTreeNode parent = this.getIDNumberTreeNode().getParent();
        return parent != null && memberNumber.equalsIgnoreCase(parent.getNumber());
    }

    @KSMethod
    public boolean isChild(ScriptMember scriptMember) {
        return this.isChild(scriptMember.getNumber());
    }

    @KSMethod
    public boolean isDescendant(String memberNumber) {
        this.checkNumberIsNotNull(memberNumber);
        IDNumberTreeNode node = this.getIDNumberTreeNode();
        return this.isDescendantByNumber(node, memberNumber);
    }

    @KSMethod
    public boolean isDescendant(ScriptMember scriptMember) {
        return this.isDescendant(scriptMember.getNumber());
    }

    private boolean isDescendantByNumber(IDNumberTreeNode node, String memberNumber) {
        for (IDNumberTreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!memberNumber.equalsIgnoreCase(parent.getNumber())) continue;
            return true;
        }
        return false;
    }

    @KSMethod
    public boolean isBase(String memberNumber) {
        this.checkNumberIsNotNull(memberNumber);
        IDNumberTreeNode node = this.getIDNumberTreeNode();
        if (!node.isLeaf()) {
            return false;
        }
        return this.isDescendant(memberNumber);
    }

    @KSMethod
    public boolean isBase(ScriptMember scriptMember) {
        return this.isBase(scriptMember.getNumber());
    }

    @KSMethod
    public boolean isBase() {
        return this.getIDNumberTreeNode().isLeaf();
    }

    @KSMethod
    public ScriptMember[] children() {
        List<IDNumberTreeNode> children = this.getIDNumberTreeNode().getChildren();
        ScriptMember[] scriptMembers = new ScriptMember[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            IDNumberTreeNode node = children.get(i);
            scriptMembers[i] = ScriptMember.create(node.getNumber(), this.dimension, node.getId());
        }
        return scriptMembers;
    }

    @KSMethod
    public ScriptMember parent() {
        IDNumberTreeNode parent = this.getIDNumberTreeNode().getParent();
        if (parent != null) {
            return ScriptMember.create(parent.getNumber(), this.dimension, parent.getId());
        }
        return null;
    }

    @KSMethod
    public ScriptMember[] base() {
        List<IDNumberTreeNode> leafChildren = this.getIDNumberTreeNode().getAllChildren(2);
        ScriptMember[] scriptMembers = new ScriptMember[leafChildren.size()];
        for (int i = 0; i < leafChildren.size(); ++i) {
            IDNumberTreeNode node = leafChildren.get(i);
            scriptMembers[i] = ScriptMember.create(node.getNumber(), this.dimension, node.getId());
        }
        return scriptMembers;
    }

    @KSMethod
    public ScriptMember[] hierarchy() {
        List<IDNumberTreeNode> leafChildren = this.getIDNumberTreeNode().getAllChildren();
        ScriptMember[] scriptMembers = new ScriptMember[leafChildren.size() + 1];
        scriptMembers[0] = this;
        for (int i = 0; i < leafChildren.size(); ++i) {
            IDNumberTreeNode node = leafChildren.get(i);
            scriptMembers[i + 1] = ScriptMember.create(node.getNumber(), this.dimension, node.getId());
        }
        return scriptMembers;
    }

    @KSMethod
    public boolean isHierarchy(String memberNumber) {
        int firstExclamationMark = memberNumber.indexOf("!");
        if (firstExclamationMark >= 0) {
            Object memberObj = this.getDimension().__getUndefinedElement(memberNumber);
            if (memberObj instanceof ScriptMember) {
                ScriptMember member = (ScriptMember)memberObj;
                if (this.id == member.id) {
                    return true;
                }
                return this.isDescendant(member);
            }
            throw new ScriptAnalyzeException(ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u4e2d\u627e\u4e0d\u5230\u6210\u5458: %2\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\u3002", (String)"ScriptMember_0", (String)"epm-eb-common", (Object[])new Object[]{this.getDimension().getNumber(), memberNumber}));
        }
        if (this.getNumber().equalsIgnoreCase(memberNumber)) {
            return true;
        }
        return this.isDescendant(memberNumber);
    }

    @KSMethod
    public boolean isHierarchy(ScriptMember scriptMember) {
        if (this.id == scriptMember.id) {
            return true;
        }
        return this.isDescendant(scriptMember);
    }

    @KSMethod
    public ScriptMember[] descendant() {
        List<IDNumberTreeNode> leafChildren = this.getIDNumberTreeNode().getAllChildren();
        ScriptMember[] scriptMembers = new ScriptMember[leafChildren.size()];
        for (int i = 0; i < leafChildren.size(); ++i) {
            IDNumberTreeNode node = leafChildren.get(i);
            scriptMembers[i] = ScriptMember.create(node.getNumber(), this.dimension, node.getId());
        }
        return scriptMembers;
    }

    private void checkNumberIsNotNull(String number) {
        if (number == null || number.trim().isEmpty()) {
            throw new RuntimeException(String.format("number [%s] can't be null or empty", number));
        }
    }
}

