/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.script.VarProvider;
import kd.epm.eb.common.ebComputing.ScriptAnalyzeException;
import kd.epm.eb.common.ebComputing.ScriptBuiltin;
import kd.epm.eb.common.ebComputing.ScriptDimension;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.datasource.OutlineNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;

public class VarProviderImpl
implements VarProvider {
    private final OlapConnection olapConn;
    private final Map<String, Object> args;
    private final IOutline outline;
    private final ScriptBuiltin builtin;
    private Map<String, String> shortNumber2NumberMap = null;

    public VarProviderImpl(OlapConnection olapConn, Map<String, Object> args, IOutline outline) {
        this.olapConn = olapConn;
        this.args = args;
        this.outline = outline;
        this.builtin = new ScriptBuiltin(olapConn, args, outline);
    }

    public Object get(String name, Object p1) {
        if (name != null) {
            if ("__builtin__".equals(name)) {
                return this.builtin;
            }
            if (this.args != null && this.args.containsKey(name)) {
                Object argValue = this.args.get(name);
                if (argValue instanceof String) {
                    if (((String)argValue).length() > 1 && ((String)argValue).startsWith("\"") && ((String)argValue).endsWith("\"")) {
                        return ((String)argValue).substring(1, ((String)argValue).length() - 1);
                    }
                    return this.tryGetNode((String)argValue) != null ? this.tryGetNode((String)argValue) : argValue;
                }
                return argValue;
            }
            Object node = this.tryGetNode(name);
            if (node != null) {
                return node;
            }
        }
        throw new ScriptAnalyzeException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6216\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"VarProviderImpl_0", (String)"epm-eb-common", (Object[])new Object[]{name}));
    }

    private Object tryGetNode(String name) {
        OutlineNode node;
        String number;
        if (this.shortNumber2NumberMap == null) {
            this.shortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap(this.outline.getModelNum());
        }
        if ((number = this.shortNumber2NumberMap.get(name)) == null) {
            number = name;
        }
        if ((node = this.outline.tryGetNode(number)) != null) {
            if (MetadataTypes.Dimension == node.getNodeType()) {
                return new ScriptDimension(number, this.olapConn, this.outline);
            }
            if (MetadataTypes.Member == node.getNodeType()) {
                return new AggPair(number, null);
            }
        }
        return null;
    }
}

