/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing.bizrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.enums.CurrencyEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import org.apache.commons.lang3.StringUtils;

public class BizRuleExecParam {
    private Map<DimTypesEnum, List<String>> map = new HashMap<DimTypesEnum, List<String>>();
    private Map<DimTypesEnum, Long> idMap = new HashMap<DimTypesEnum, Long>();
    private Map<Long, String> csMap = new HashMap<Long, String>();
    private BizRuleExecCommonParam commonParam = new BizRuleExecCommonParam();
    private Map<String, Set<String>> ebMap = new HashMap<String, Set<String>>();
    private List<Pair<Long, String>> bizRuleList = new ArrayList<Pair<Long, String>>();
    private String modelNum;

    public Map<Long, String> getCsMap() {
        return this.csMap;
    }

    public void setCsMap(Map<Long, String> csMap) {
        this.csMap.putAll(csMap);
    }

    public Map<DimTypesEnum, List<String>> getCustormParam() {
        return this.map;
    }

    public Map<String, Set<String>> getEBCustormParam() {
        return this.ebMap;
    }

    public void setEBCustormParam(Map<String, Set<String>> map) {
        this.ebMap = map;
    }

    public BizRuleExecParam() {
    }

    public BizRuleExecParam(String modelNum) {
        this.modelNum = modelNum;
    }

    public BizRuleExecParam(String modelNum, String orgNum, String fyNum, String periodNum, String currencyNum, String sceneNum) {
        this.modelNum = modelNum;
        this.map.put(DimTypesEnum.ENTITY, Collections.singletonList(orgNum));
        this.map.put(DimTypesEnum.YEAR, Collections.singletonList(fyNum));
        this.map.put(DimTypesEnum.PERIOD, Collections.singletonList(periodNum));
        this.map.put(DimTypesEnum.CURRENCY, Collections.singletonList(currencyNum));
        this.map.put(DimTypesEnum.SCENARIO, Collections.singletonList(sceneNum));
    }

    public BizRuleExecParam(String modelNum, String orgNum, String fyNum, String periodNum, String currencyNum, String sceneNum, String processNum) {
        this(modelNum, orgNum, fyNum, periodNum, currencyNum, sceneNum);
        this.map.put(DimTypesEnum.PROCESS, Collections.singletonList(processNum));
    }

    public BizRuleExecParam(String modelNum, String[] orgNums, String fyNum, String periodNum, String currencyNum, String sceneNum, String processNum) {
        this(modelNum, orgNums, fyNum, periodNum, currencyNum, sceneNum);
        this.map.put(DimTypesEnum.PROCESS, Collections.singletonList(processNum));
    }

    public BizRuleExecParam(String modelNum, String[] orgNums, String fyNum, String periodNum, String currencyNum, String sceneNum) {
        this.modelNum = modelNum;
        this.map.put(DimTypesEnum.ENTITY, Arrays.asList(orgNums));
        this.map.put(DimTypesEnum.YEAR, Collections.singletonList(fyNum));
        this.map.put(DimTypesEnum.PERIOD, Collections.singletonList(periodNum));
        this.map.put(DimTypesEnum.CURRENCY, Collections.singletonList(currencyNum));
        this.map.put(DimTypesEnum.SCENARIO, Collections.singletonList(sceneNum));
    }

    public BizRuleExecParam(String modelNum, List<String> orgNums, List<String> fyNums, List<String> periodNums, List<String> currencyNums, List<String> sceneNums, List<String> processNums) {
        this.modelNum = modelNum;
        this.map.put(DimTypesEnum.ENTITY, orgNums);
        this.map.put(DimTypesEnum.YEAR, fyNums);
        this.map.put(DimTypesEnum.PERIOD, periodNums);
        this.map.put(DimTypesEnum.CURRENCY, currencyNums);
        this.map.put(DimTypesEnum.SCENARIO, sceneNums);
        this.map.put(DimTypesEnum.PROCESS, processNums);
    }

    public BizRuleExecParam(String modelNum, List<String> orgNums, List<String> fyNums, List<String> periodNums, List<String> sceneNums, List<String> currencyNums, List<String> processNums, List<String> auditTrailNums) {
        this.modelNum = modelNum;
        this.map.put(DimTypesEnum.ENTITY, orgNums);
        this.map.put(DimTypesEnum.YEAR, fyNums);
        this.map.put(DimTypesEnum.PERIOD, periodNums);
        this.map.put(DimTypesEnum.CURRENCY, currencyNums);
        this.map.put(DimTypesEnum.SCENARIO, sceneNums);
        this.map.put(DimTypesEnum.PROCESS, processNums);
        this.map.put(DimTypesEnum.AUDITTRIAL, auditTrailNums);
    }

    public void addParam(DimTypesEnum dim, String member) {
        this.map.put(dim, Collections.singletonList(member));
    }

    public void addParam(DimTypesEnum dim, List<String> members) {
        this.map.put(dim, members);
    }

    public void addIdParam(DimTypesEnum dim, Long id) {
        this.idMap.put(dim, id);
    }

    public BizRuleExecParam copy(BizRuleExecParam source) {
        BizRuleExecParam target = new BizRuleExecParam(source.getModelNum(), source.getOrgNums(), source.getFyNums(), source.getPeriodNums(), source.getCurrencyNums(), source.getSceneNums(), source.getProcessNums());
        target.setBizRuleList(source.getBizRuleList());
        return target;
    }

    public List<BizRuleExecParam> organizing() {
        boolean isFalse = false;
        ArrayList<BizRuleExecParam> result = new ArrayList<BizRuleExecParam>();
        if (CurrencyEnum.EC.getNumber().equals(this.getCurrencyNum())) {
            String fyNum = this.getFyNum();
            String periodNum = this.getPeriodNum();
            if (StringUtils.isEmpty((CharSequence)this.getOrgNum())) {
                QFBuilder currencyBuilder = new QFBuilder();
                currencyBuilder.add("model.number", "=", this.modelNum);
                currencyBuilder.add("isexchangerate", "=", isFalse);
                currencyBuilder.add("number", "!=", PresetConstant.ENTITY_DIM);
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"number,currency.number", (QFilter[])currencyBuilder.toArray(), null);
                for (DynamicObject org : orgs) {
                    BizRuleExecParam target = this.copy(this);
                    target.setCurrencyNum(org.getString("currency.number"));
                    target.setOrgNum(org.getString("number"));
                    result.add(target);
                }
            } else {
                QFBuilder currencyBuilder = new QFBuilder();
                currencyBuilder.add("number", "=", this.getOrgNum());
                currencyBuilder.add("model.number", "=", this.modelNum);
                DynamicObject org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"currency.number", (QFilter[])currencyBuilder.toArray());
                this.setCurrencyNum(org.getString("currency.number"));
                result.add(this);
            }
        } else {
            result.add(this);
        }
        return result;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public String getOrgNum() {
        return this.map.get((Object)DimTypesEnum.ENTITY).get(0);
    }

    public void setOrgNum(String orgNum) {
        this.map.put(DimTypesEnum.ENTITY, Collections.singletonList(orgNum));
    }

    public List<String> getOrgNums() {
        return this.map.get((Object)DimTypesEnum.ENTITY);
    }

    public String getFyNum() {
        return this.map.get((Object)DimTypesEnum.YEAR).get(0);
    }

    public List<String> getFyNums() {
        return this.map.get((Object)DimTypesEnum.YEAR);
    }

    public String getPeriodNum() {
        return this.map.get((Object)DimTypesEnum.PERIOD).get(0);
    }

    public List<String> getPeriodNums() {
        return this.map.get((Object)DimTypesEnum.PERIOD);
    }

    public String getCurrencyNum() {
        return this.map.get((Object)DimTypesEnum.CURRENCY).get(0);
    }

    public List<String> getCurrencyNums() {
        return this.map.get((Object)DimTypesEnum.CURRENCY);
    }

    public void setCurrencyNum(String currencyNum) {
        this.map.put(DimTypesEnum.CURRENCY, Collections.singletonList(currencyNum));
    }

    public String getProcessNum() {
        return this.map.get((Object)DimTypesEnum.PROCESS) == null ? null : this.map.get((Object)DimTypesEnum.PROCESS).get(0);
    }

    public List<String> getProcessNums() {
        return this.map.get((Object)DimTypesEnum.PROCESS);
    }

    public String getSceneNum() {
        return this.map.get((Object)DimTypesEnum.SCENARIO).get(0);
    }

    public List<String> getSceneNums() {
        return this.map.get((Object)DimTypesEnum.SCENARIO);
    }

    public List<Pair<Long, String>> getBizRuleList() {
        return this.bizRuleList;
    }

    public void setBizRuleList(List<Pair<Long, String>> bizRuleList) {
        this.bizRuleList = bizRuleList;
    }

    public void addBizRuleList(Pair<Long, String> bizRule) {
        this.bizRuleList.add(bizRule);
    }

    public Map<DimTypesEnum, Long> getIdParam() {
        return this.idMap;
    }

    public BizRuleExecCommonParam getCommonParam() {
        return this.commonParam;
    }

    public static class BizRuleExecCommonParam {
        private Map<String, Pair<Long, String>> params = new HashMap<String, Pair<Long, String>>();

        public BizRuleExecCommonParam addCommonParamPair(String dimNum, Long id, String number) {
            Objects.requireNonNull(id, "id request non-null");
            Objects.requireNonNull(number, "number request non-null");
            this.params.put(dimNum, Pair.onePair(id, number));
            return this;
        }

        public void addAllCommonParamPair(Map<String, Pair<Long, String>> param) {
            this.params.putAll(param);
        }

        public Map<String, Pair<Long, String>> getParams() {
            return this.params;
        }

        public Pair<Long, String> getDimMemberPair(String dimNum) {
            return this.params.get(dimNum);
        }
    }
}

