/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing.datasource;

import java.io.IOException;
import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;

public class JavaScriptLoader {
    private static final Log log = LogFactory.getLog(JavaScriptLoader.class);
    private final String jscontent = JavaScriptLoader.getStringFromResources("computing/js/biz_rule.js");

    private JavaScriptLoader() {
    }

    public String getBizRuleScript() {
        return this.jscontent;
    }

    public static final JavaScriptLoader getInstance() {
        return JavaScriptLoaderHolder.holder;
    }

    public static String getStringFromResources(String path) {
        InputStream in = null;
        try {
            in = JavaScriptLoader.class.getClassLoader().getResourceAsStream(path);
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new RuntimeException("load biz-rule.js failed!");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private static class JavaScriptLoaderHolder {
        private static final JavaScriptLoader holder = new JavaScriptLoader();

        private JavaScriptLoaderHolder() {
        }
    }
}

