/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing.datasource;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.metadata.MetadataTypes;
import kd.epm.eb.common.ebComputing.datasource.DimensionInfo;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.datasource.Outline;
import kd.epm.eb.common.ebComputing.util.TreeStructureServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.enums.AggOprtEnum;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.utils.ToStringHelper;
import org.apache.commons.lang3.StringUtils;

public class OutlineNode {
    private long id;
    private String number;
    private String aggOprt;
    private int seq;
    private int level;
    private DimensionInfo dimensionInfo;
    private StorageTypeEnum storageType;
    private boolean isShare = false;
    private volatile boolean hasExtend = false;
    private volatile boolean hasExtendAllChildren = false;
    private OutlineNode parent;
    private TreeMap<Integer, OutlineNode> children;
    private List<OutlineNode> directChildren = new ArrayList<OutlineNode>(0);
    private boolean isLeaf;
    private Object modelId;
    private OutlineNode baseMember;
    private boolean isSkipAggOprt = false;
    private int essBaseLevel = -100;
    private int sibling;

    public OutlineNode getBaseMember() {
        return this.baseMember;
    }

    public void setBaseMember(OutlineNode baseMember) {
        this.baseMember = baseMember;
    }

    public List<OutlineNode> getDirectChildren() {
        return this.directChildren;
    }

    public boolean hasExtend() {
        return this.hasExtend;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelId(Object modelId) {
        this.modelId = modelId;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        Preconditions.checkArgument((number != null ? 1 : 0) != 0);
        this.number = number;
    }

    public String getAggOprt() {
        return this.aggOprt;
    }

    public boolean isSkipAggOprt() {
        return this.isSkipAggOprt;
    }

    public int getSeq() {
        return this.seq;
    }

    public int getLevel() {
        return this.level;
    }

    private int getEssBaseLevel() {
        if (this.essBaseLevel == -100) {
            this.essBaseLevel = this.builtinEssBaseLevel();
        }
        return this.essBaseLevel;
    }

    private int builtinEssBaseLevel() {
        if (this.isShare) {
            if (this.baseMember == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9\u672a\u8bbe\u7f6e\u6307\u5411\u7684\u8282\u70b9\u3002", (String)"OutlineNode_0", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            return this.baseMember.getEssBaseLevel();
        }
        if (this.isLeaf) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (OutlineNode node : this.directChildren) {
            int t = node.getEssBaseLevel();
            if (t <= max) continue;
            max = t;
        }
        return max + 1;
    }

    public String getDimension() {
        return this.dimensionInfo.getDimensionNumber();
    }

    public StorageTypeEnum getStorageType() {
        return this.storageType;
    }

    public OutlineNode getParent() {
        return this.parent;
    }

    public void setParent(OutlineNode parent) {
        this.parent = parent;
    }

    public TreeMap<Integer, OutlineNode> getChildren() {
        return this.children;
    }

    public void setChildren(TreeMap<Integer, OutlineNode> children) {
        Preconditions.checkArgument((children != null ? 1 : 0) != 0);
        this.children = children;
    }

    public int getSibling() {
        return this.sibling;
    }

    public void setSibling(int sibling) {
        this.sibling = sibling;
    }

    public MetadataTypes getNodeType() {
        return this.number.equals(this.dimensionInfo.getDimensionNumber()) ? MetadataTypes.Dimension : MetadataTypes.Member;
    }

    public OutlineNode(long id, String number, String aggOprt, int seq, int level, DimensionInfo dimensionInfo, StorageTypeEnum storageType, boolean isLeaf, boolean isShare, Object modelId) {
        this.id = id;
        this.number = number;
        this.aggOprt = aggOprt;
        this.isSkipAggOprt = AggOprtEnum.SKIP.getName().equals(aggOprt);
        this.seq = seq;
        this.level = level;
        this.dimensionInfo = dimensionInfo;
        this.storageType = storageType;
        this.isLeaf = isLeaf;
        this.isShare = isShare;
        this.modelId = modelId;
    }

    public String toString() {
        return ToStringHelper.deepToString(this);
    }

    public boolean isDynamicType() {
        return this.storageType == StorageTypeEnum.DYNAMIC;
    }

    public void extendDirectChildren() {
        String entityNumber = this.dimensionInfo.getEntityNumber();
        if (!this.hasExtend || "epm_accountmembertree".equals(entityNumber)) {
            Outline outline = this.dimensionInfo.getOutline();
            if (!this.isShare) {
                if (!this.isLeaf) {
                    this.queryDirectChildren(entityNumber, this.id, outline);
                }
            } else {
                OutlineNode baseNode = outline.getAggNode(this.dimensionInfo.getDimensionNumber(), this.number);
                this.setBaseMember(baseNode);
                baseNode.extendAllChildren();
                if (!this.isLeaf) {
                    this.queryDirectChildren(entityNumber, this.id, outline);
                }
            }
            this.isLeaf = this.directChildren.isEmpty();
            this.hasExtend = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendAllChildren() {
        boolean isaccount = "epm_accountmembertree".equals(this.dimensionInfo.getEntityNumber());
        if (this.hasExtendAllChildren && !isaccount) {
            return;
        }
        Object object = this.modelId;
        synchronized (object) {
            List<OutlineNode> directChildren;
            if (this.hasExtendAllChildren && !isaccount) {
                return;
            }
            if (!this.hasExtend || isaccount) {
                this.extendDirectChildren();
            }
            if (!(directChildren = this.getDirectChildren()).isEmpty()) {
                directChildren.forEach(OutlineNode::extendAllChildren);
            }
            this.hasExtendAllChildren = true;
        }
    }

    public void collectNodesByLevel(Map<Integer, Set<OutlineNode>> essBaseLevelMap) {
        if (this.isShare) {
            if (!this.isSkipAggOprt()) {
                this.getBaseMember().collectNodesByLevel(essBaseLevelMap);
            }
        } else {
            int essLevel;
            List<OutlineNode> directChildren = this.getDirectChildren();
            if (!directChildren.isEmpty()) {
                directChildren.forEach(child -> child.collectNodesByLevel(essBaseLevelMap));
            }
            if ((essLevel = this.getEssBaseLevel()) > 0) {
                Set outlineNodeSet = essBaseLevelMap.computeIfAbsent(essLevel, k -> new HashSet());
                outlineNodeSet.add(this);
            }
        }
    }

    private void queryDirectChildren(String entityNumber, Object pid, IOutline outline) {
        String year = outline.getComputingContext().getRuntimeFy();
        String period = outline.getComputingContext().getRuntimePeriod();
        List<IDNumberTreeNode> chidren = entityNumber.equals("epm_accountmembertree") ? TreeStructureServiceHelper.getAccountDirectChild(pid, this.dimensionInfo.getOutline().getModelNum(), year, period) : TreeStructureServiceHelper.getDirectChild(entityNumber, pid, this.getSelectFields(), this.dimensionInfo.getOutline().getModelNum());
        this.directChildren.clear();
        chidren.forEach(entry -> {
            if (entry.isShare()) {
                this.directChildren.add(this.dimensionInfo.getOutline().trans2OutlineNode((IDNumberTreeNode)entry));
            } else {
                this.directChildren.add(this.dimensionInfo.getOutline().getOrCreateOutlineNode((IDNumberTreeNode)entry));
            }
        });
    }

    public OutlineNode convert2OutlineNode(DynamicObject obj) {
        return this.dimensionInfo.getOutline().trans2OutlineNode(obj);
    }

    private String getSelectFields() {
        return Outline.getSelectFields();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutlineNode bean = (OutlineNode)obj;
        return StringUtils.equals((CharSequence)bean.number, (CharSequence)this.number);
    }

    public int hashCode() {
        return Objects.hashCode(this.number);
    }
}

