/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing.datasource;

import java.util.HashMap;
import java.util.Map;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.Recorder;

public class StatisticsAnalysis {
    private Object processId;
    private AggStatistics aggStatistics = new AggStatistics();

    public StatisticsAnalysis(Object processId) {
        this.processId = processId;
    }

    private String outputFormat(Map.Entry<String, Pair<Integer, Long>> entry) {
        return String.format("{\"agg\":%s,\"count\":%d,\"spantime\":%s,\"avg\":%s},", StatisticsAnalysis.packField(entry.getKey()), entry.getValue().p1, StatisticsAnalysis.msecToTime((Long)entry.getValue().p2), StatisticsAnalysis.msecToTime((Long)entry.getValue().p2 / (long)((Integer)entry.getValue().p1).intValue()));
    }

    private static String packField(String v) {
        return "\"" + v + "\"";
    }

    public String toString() {
        return "{\"processid\":\"" + this.processId + "\",\"data\":[\n" + this.aggStatistics + "]}";
    }

    public static StatisticsAnalysis getInstance() {
        return GlobalCacheServiceHelper.getOrLoadNode("allInOne-Statistics", () -> new StatisticsAnalysis(GlobalCacheServiceHelper.getOrCreateCacheKey()));
    }

    public static String msecToTime(long time) {
        String timeStr = null;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long millisecond = 0L;
        if (time <= 0L) {
            return "0.0";
        }
        second = time / 1000L;
        minute = second / 60L;
        millisecond = time % 1000L;
        if (second < 60L) {
            timeStr = (second <= 0L ? "" : second + "s") + millisecond + "ms";
        } else if (minute < 60L) {
            timeStr = minute + "m" + (second %= 60L) + "s" + millisecond + "ms";
        } else {
            hour = minute / 60L;
            second = second - hour * 3600L - (minute %= 60L) * 60L;
            timeStr = hour + "h" + minute + "m" + second + "s" + millisecond + "ms";
        }
        return StatisticsAnalysis.packField(timeStr);
    }

    public AggStatistics getAggStatistics() {
        return this.aggStatistics;
    }

    class AggStatistics {
        private Map<String, Pair<Integer, Long>> execAnalysis = new HashMap<String, Pair<Integer, Long>>();
        private Map<String, Pair<Integer, Long>> parseAnaysis = new HashMap<String, Pair<Integer, Long>>();

        AggStatistics() {
        }

        void executeAnalyze(String key, long spantime) {
            this.execAnalysis.compute(key, (k, v) -> {
                if (v == null) {
                    return Pair.onePair(1, spantime);
                }
                return Pair.onePair((Integer)v.p1 + 1, (Long)v.p2 + spantime);
            });
        }

        void parseAnalyze(String key, long spantime) {
            this.parseAnaysis.compute(key, (k, v) -> {
                if (v == null) {
                    return Pair.onePair(1, spantime);
                }
                return Pair.onePair((Integer)v.p1 + 1, (Long)v.p2 + spantime);
            });
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formatAnalysis(this.parseAnaysis, "agg-parse-total"));
            sb.append(this.formatAnalysis(this.execAnalysis, "agg-execute-total"));
            return sb.toString();
        }

        private String formatAnalysis(Map<String, Pair<Integer, Long>> analysis, String totalTitle) {
            if (analysis.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Recorder<Pair<Integer, Long>> total = new Recorder<Pair<Integer, Long>>(Pair.onePair(0, 0L));
            int top = Math.min(analysis.size(), 10);
            Recorder<Integer> top10 = new Recorder<Integer>(top);
            analysis.entrySet().stream().sorted((c1, c2) -> (Integer)((Pair)c2.getValue()).p1 - (Integer)((Pair)c1.getValue()).p1).forEach(entry -> {
                total.setRecord(Pair.onePair((Integer)((Pair)total.getRecord()).p1 + (Integer)((Pair)entry.getValue()).p1, (Long)((Pair)total.getRecord()).p2 + (Long)((Pair)entry.getValue()).p2));
                if ((Integer)top10.getRecord() > 0) {
                    sb.append(StatisticsAnalysis.this.outputFormat(entry));
                    sb.append('\n');
                    top10.setRecord((Integer)top10.getRecord() - 1);
                }
            });
            top10.setRecord(Math.min(analysis.size(), 10));
            analysis.entrySet().stream().sorted((c1, c2) -> (int)((Long)((Pair)c2.getValue()).p2 - (Long)((Pair)c1.getValue()).p2)).limit(top).forEach(entry -> {
                sb.append(StatisticsAnalysis.this.outputFormat(entry));
                sb.append('\n');
            });
            int lastindex = sb.lastIndexOf(",");
            sb.deleteCharAt(lastindex);
            sb.insert(0, String.format("{\"%s\":%d,\"spantime\":%s,\"avg\":%s},\n", totalTitle, total.getRecord().p1, StatisticsAnalysis.msecToTime((Long)total.getRecord().p2), StatisticsAnalysis.msecToTime((Long)total.getRecord().p2 / (long)((Integer)total.getRecord().p1).intValue())));
            return sb.toString();
        }
    }
}

