/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing.member;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.script.ScriptFunction;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.epm.eb.common.ebComputing.ScriptMember;
import kd.epm.eb.common.ebComputing.member.ScriptCell;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kotlin.Pair;

@KSObject
public class ScriptCellSet {
    private CellSet cellSet;
    private List<DimensionFilterItem> fixDimensions;
    private List<String> dimensions;
    private OlapConnection olapConnection;
    private String defaultMember;
    private HashMap<String, Set<String>> memberMap;
    private HashMap<String, Integer> dimenisonIndexMap;
    private boolean zeroToNull = true;

    public CellSet getCellSet() {
        return this.cellSet;
    }

    public List<DimensionFilterItem> getFixDimensions() {
        return this.fixDimensions;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public String getDefaultMember() {
        return this.defaultMember;
    }

    public HashMap<String, Set<String>> getMemberMap() {
        return this.memberMap;
    }

    public HashMap<String, Integer> getDimenisonIndexMap() {
        return this.dimenisonIndexMap;
    }

    public ScriptCellSet(OlapConnection olapConnection, CellSet cellSet, List<DimensionFilterItem> fixDimensions, List<String> dimensions, HashMap<String, Set<String>> memberMap) {
        this.olapConnection = olapConnection;
        this.cellSet = cellSet;
        this.fixDimensions = fixDimensions;
        this.dimensions = dimensions;
        this.dimenisonIndexMap = this.initDimensionIndexMap();
        this.memberMap = memberMap;
    }

    public final HashMap<String, Integer> initDimensionIndexMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] dims = this.dimensions.toArray(new String[0]);
        for (int i = 0; i < dims.length; ++i) {
            map.put(dims[i], i);
        }
        return map;
    }

    public Object get(Object ... objects) {
        String[] rowKeys = this.getRowKeys(objects, 0);
        return this.cellSet.get(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField());
    }

    public void set(Object ... objects) {
        String[] rowKeys = this.getRowKeys(objects, 1);
        if (this.zeroToNull && this.isZero(objects[0])) {
            this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
        } else {
            this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), objects[0]);
        }
    }

    private boolean isZero(Object value) {
        if (value instanceof Integer) {
            return value == Integer.valueOf(0);
        }
        if (value instanceof Double) {
            return ((Double)value).compareTo(0.0) == 0;
        }
        if (value instanceof Long) {
            return value == Long.valueOf(0L);
        }
        if (value instanceof Float) {
            return ((Float)value).compareTo(Float.valueOf(0.0f)) == 0;
        }
        if (value instanceof Short) {
            return ((Short)value).compareTo((short)0) == 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.ZERO) == 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    public void setDefaultMember(Object defaultMember) {
        if (defaultMember instanceof String) {
            this.defaultMember = defaultMember.toString();
        } else if (defaultMember instanceof ScriptMember) {
            ScriptMember scriptMember = (ScriptMember)defaultMember;
            String dimNumber = scriptMember.getDimension().getNumber();
            String memberNumber = scriptMember.getNumber();
            this.defaultMember = dimNumber + "@" + memberNumber;
        } else {
            throw new IllegalArgumentException(String.format("cellSet setDefaultMember method param [%s] class type must be String or ScriptMember", defaultMember));
        }
    }

    @KSMethod
    public void setZeroToNull(boolean value) {
        this.zeroToNull = value;
    }

    public void save() {
        SaveCommandInfo saveCommandInfo = new SaveCommandInfo();
        saveCommandInfo.setDimensions(this.dimensions.toArray(new String[0]));
        saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        this.fixDimensions.forEach((? super T f) -> saveCommandInfo.addfixedDimension(new String[]{f.getName(), (String)f.getValues().get(0)}));
        OlapCommand olapCommand = new OlapCommand(this.olapConnection, (CommandInfo)saveCommandInfo);
        try (OlapDataWriter writer = olapCommand.CreateWriter();){
            this.cellSet.Save(writer);
        }
    }

    private String[] getRowKeys(Object[] objects, int startIndex) {
        String[] dimMemberSplit;
        int dimIndex;
        int i;
        int realLength = objects.length - startIndex;
        int rowKeyLength = this.dimensions.size();
        if (realLength > rowKeyLength) {
            throw new IllegalArgumentException(String.format("cellSet get or set method params length is too long : %s", Arrays.toString(objects)));
        }
        String[] rowKeys = new String[rowKeyLength];
        for (i = startIndex; i < objects.length; ++i) {
            String memberNumber;
            String dimNumber;
            Object object = objects[i];
            if (object instanceof String) {
                String[] dimMemberSplit2 = this.getDimMemberSplit(object.toString(), startIndex == 0);
                dimNumber = dimMemberSplit2[0];
                memberNumber = dimMemberSplit2[1];
                Integer dimIndex2 = this.dimenisonIndexMap.get(dimNumber);
                rowKeys[dimIndex2.intValue()] = memberNumber;
                continue;
            }
            if (object instanceof ScriptMember) {
                ScriptMember scriptMember = (ScriptMember)object;
                dimNumber = scriptMember.getDimension().getNumber();
                memberNumber = scriptMember.getNumber();
                if (startIndex == 0) {
                    this.checkLoadMember(dimNumber, memberNumber);
                }
                int dimIndex3 = this.dimenisonIndexMap.get(dimNumber);
                rowKeys[dimIndex3] = memberNumber;
                continue;
            }
            throw new IllegalArgumentException(String.format("cellSet get or set method param [%s] class type must be String or ScriptMember", object));
        }
        if (this.defaultMember != null && rowKeys[dimIndex = this.dimenisonIndexMap.get((dimMemberSplit = this.getDimMemberSplit(this.defaultMember, startIndex == 0))[0]).intValue()] == null) {
            rowKeys[dimIndex] = dimMemberSplit[1];
        }
        for (i = 0; i < rowKeys.length; ++i) {
            String rowKey = rowKeys[i];
            if (rowKey != null) continue;
            throw new IllegalArgumentException(String.format("cellSet get or set method param Dimension[%s] must be set member.", this.dimensions.get(i)));
        }
        return rowKeys;
    }

    private String[] getDimMemberSplit(String dimMember, boolean isGet) {
        String[] dimMemberSplit = dimMember.contains("@") ? dimMember.split("@") : dimMember.split("\\.");
        if (dimMemberSplit.length != 2) {
            throw new IllegalArgumentException(String.format("cellSet get or set method param [%s] error,format: dimName@member .", dimMember));
        }
        String dimName = dimMemberSplit[0];
        if (dimName != null && !this.dimensions.contains(dimName)) {
            throw new IllegalArgumentException(String.format("cellSet param error,Dimension[%s] is fixDimension.", dimName));
        }
        if (isGet) {
            this.checkLoadMember(dimName, dimMemberSplit[1]);
        }
        return dimMemberSplit;
    }

    private void checkLoadMember(String dimName, String memberName) {
        Set<String> members = this.memberMap.get(dimName);
        if (members != null && !members.contains(memberName)) {
            throw new IllegalArgumentException(String.format("cellSet getCellSet method not load Dimension[%s] Member[%s] data.", dimName, memberName));
        }
    }

    @KSMethod
    public void forEach(ScriptFunction func) {
        Iterator<ScriptCell> iter = this.iterator();
        ArrayList<ScriptCell> cells = new ArrayList<ScriptCell>();
        while (iter.hasNext()) {
            cells.add(iter.next());
        }
        int i = 0;
        for (ScriptCell cell : cells) {
            func.call(new Object[]{cell, i++});
        }
    }

    public String toString() {
        return this.cellSet.toString();
    }

    public Iterator<ScriptCell> iterator() {
        return new ScriptCellIterator();
    }

    private class ScriptCellIterator
    implements Iterator<ScriptCell> {
        private Iterator<Pair<MembersKey, Object>> iter;

        private ScriptCellIterator() {
            this.iter = ScriptCellSet.this.cellSet.getMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField());
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ScriptCell next() {
            Pair<MembersKey, Object> item = this.iter.next();
            return new ScriptCell(ScriptCellSet.this.dimenisonIndexMap, (MembersKey)item.component1(), item.component2());
        }
    }
}

