/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebComputing.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebComputing.ComputingContext;
import kd.epm.eb.common.ebComputing.ComputingEngine;
import kd.epm.eb.common.ebComputing.bizrule.BizRuleExecParam;
import kd.epm.eb.common.ebComputing.datasource.Outline;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.olapdao.ConnectionManager;

public class RuleExecuteServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(true, RuleExecuteServiceHelper.class);

    private static Map<String, Pair<Long, String>> buildComputContextCommonParam(BizRuleExecParam execParam) {
        HashMap<String, Pair<Long, String>> context = new HashMap<String, Pair<Long, String>>();
        context.putAll(execParam.getCommonParam().getParams());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, String> excuteScript4ReportParams(String cube, List<BizRuleExecParam> paramList, ApplicationTypeEnum app) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        OlapConnection olapConnection = ConnectionManager.getInstance().getConnection(cube, cube);
        olapConnection.Open();
        Outline outline = new Outline(olapConnection);
        ComputingEngine computingEngine = new ComputingEngine(olapConnection, outline);
        try {
            for (BizRuleExecParam execParam : paramList) {
                List<Pair<Long, String>> bizRuleList = execParam.getBizRuleList();
                Map<String, Pair<Long, String>> contextParam = RuleExecuteServiceHelper.buildComputContextCommonParam(execParam);
                for (Pair<Long, String> bizRule : bizRuleList) {
                    if (result.containsKey(bizRule.p1) || !StringUtils.isNotEmpty((String)((String)bizRule.p2))) continue;
                    ComputingContext ctx = new ComputingContext(olapConnection, outline, contextParam);
                    HashMap<String, Object> args = new HashMap<String, Object>(16);
                    args.put("ctx", ctx);
                    args.put("outline", outline);
                    if (ApplicationTypeEnum.isBGMDOrBGBDOrBGM(app)) {
                        args.put("ebCustormParam", execParam.getEBCustormParam());
                    } else {
                        args.put("custormParam", execParam.getCustormParam());
                    }
                    String str = (String)bizRule.p2;
                    try {
                        computingEngine.execute(str, args);
                    }
                    catch (Exception e) {
                        log.error("olap operator: excute script(" + str + "), result: failure, spendtime ", e);
                        Throwable throwable = e.getCause();
                        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
                        StackTraceElement[] stackTraceElements1 = e.getStackTrace();
                        ArrayList<String> message = new ArrayList<String>(stackTraceElements.length + stackTraceElements1.length + 3);
                        message.add(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a", (String)"RuleExecuteServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]));
                        message.add(e.getCause().toString());
                        for (StackTraceElement stackTraceElement : stackTraceElements) {
                            message.add("    at " + stackTraceElement);
                        }
                        message.add("Caused by : " + e);
                        for (StackTraceElement stackTraceElement : stackTraceElements1) {
                            message.add("    at " + stackTraceElement);
                        }
                        result.put((Long)bizRule.p1, e.getMessage() + "\n" + String.join((CharSequence)"\n", message.toArray(new String[0])));
                    }
                }
            }
        }
        finally {
            olapConnection.Close();
        }
        return result;
    }
}

