/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.cache.prop.MemberPropMamanger;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;

public class IDNumberTreeNode
implements Cloneable {
    private Long id;
    private String number;
    private Long copyFromId;
    private IDNumberTreeNode parent;
    private List<IDNumberTreeNode> children;
    private String aggOprt;
    private int dSeq = 0;
    private int level = 0;
    private Pair<Long, String> dim = null;
    private StorageTypeEnum storageType;
    private boolean isLeaf = true;
    private boolean isShare = false;
    private Pair<Long, String> model = null;
    private String longNumber = "";
    private String name;
    private String simplaname;
    private String currency;
    public static final IDNumberTreeNode NotFoundTreeNode = new IDNumberTreeNode(-1L, "not found", "", -1, -1, null, null, false, null, -1L, "", "");

    public IDNumberTreeNode(Long id, String number, String aggOprt, int dSeq, int level, Pair<Long, String> dim, StorageTypeEnum storageType, boolean isLeaf, Pair<Long, String> model, Long copyFromId, String name, String simplename) {
        this.id = id;
        this.number = number;
        this.copyFromId = copyFromId;
        this.aggOprt = aggOprt;
        this.dSeq = dSeq;
        this.level = level;
        this.dim = dim;
        this.storageType = storageType;
        this.isLeaf = isLeaf;
        this.isShare = StorageTypeEnum.isShare(storageType);
        this.model = model;
        this.name = name;
        this.simplaname = simplename;
    }

    public String getAggOprt() {
        return this.aggOprt;
    }

    public int getdSeq() {
        return this.dSeq;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDimNumber() {
        return (String)this.dim.p2;
    }

    public Long getDimId() {
        return (Long)this.dim.p1;
    }

    public StorageTypeEnum getStorageType() {
        return this.storageType;
    }

    public boolean isShare() {
        return this.isShare;
    }

    public Long getModelId() {
        return (Long)this.model.p1;
    }

    public String getModelNumber() {
        return (String)this.model.p2;
    }

    public void addChild(IDNumberTreeNode id) {
        if (this.children == null) {
            this.children = new ArrayList<IDNumberTreeNode>();
        }
        this.children.add(id);
    }

    public void setChildren(List<IDNumberTreeNode> nodeList) {
        this.children = nodeList;
    }

    public IDNumberTreeNode getParent() {
        return this.parent;
    }

    public void setParent(IDNumberTreeNode parent) {
        this.parent = parent;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public Long getCopyfromId() {
        return this.copyFromId;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public String getName() {
        return this.name;
    }

    public String getSimplaname() {
        if (StringUtils.isNotEmpty((String)this.simplaname)) {
            return this.simplaname;
        }
        return this.name;
    }

    public List<IDNumberTreeNode> getAllChildren(int childType) {
        ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>();
        if (this.children == null) {
            return nodes;
        }
        for (IDNumberTreeNode node : this.children) {
            switch (childType) {
                case 0: {
                    nodes.add(node);
                    break;
                }
                case 1: {
                    if (node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 2: {
                    if (!node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
            }
            if (node.isLeaf()) continue;
            nodes.addAll(node.getAllChildren(childType));
        }
        return nodes;
    }

    public List<IDNumberTreeNode> getAllChildren() {
        return this.getAllChildren(0);
    }

    public List<IDNumberTreeNode> getBrother() {
        ArrayList<IDNumberTreeNode> ids = new ArrayList<IDNumberTreeNode>();
        if (this.getParent() == null) {
            return ids;
        }
        for (IDNumberTreeNode node : this.getParent().getChildren()) {
            if (node.getId().equals(this.id)) continue;
            ids.add(node);
        }
        return ids;
    }

    public IDNumberTreeNode parent(Object id) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getId().equals(id)) {
            return this.parent;
        }
        return this.parent.parent(id);
    }

    public IDNumberTreeNode closest(Object id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.closest(id);
    }

    public List<IDNumberTreeNode> getChildren() {
        return this.children == null ? new ArrayList(0) : this.children;
    }

    public Set<Long> getChildrenIds() {
        HashSet<Long> ids = new HashSet<Long>();
        if (this.children != null) {
            for (IDNumberTreeNode node : this.children) {
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public Set<Long> getStorageAllChildrenIds(int childType, boolean isStorage) {
        HashSet<Long> ids = new HashSet<Long>();
        List<IDNumberTreeNode> allChildren = this.getAllChildren(childType);
        if (allChildren != null) {
            for (IDNumberTreeNode node : allChildren) {
                if (isStorage && node.getCopyfromId() != 0L) {
                    ids.add(node.getCopyfromId());
                    continue;
                }
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCustomPropVal(String dimPropName) {
        return MemberPropMamanger.getMemberPropMamanger(this.getDimId(), this.getDimNumber(), this.getModelNumber()).getPropVal(this.id, dimPropName);
    }

    public <T> T loadAndConsumerProp(String selectField, Function<DynamicObject, T> consumer) {
        String entity = MemberReader.getEntityNumberByDim(this.getModelNumber(), this.getDimNumber());
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getId(), (String)entity, (String)selectField);
        return consumer.apply(dyna);
    }

    public IDNumberTreeNode clone() {
        IDNumberTreeNode o = null;
        try {
            o = (IDNumberTreeNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException("IDNumberTreeNode clone not support");
        }
        return o;
    }
}

