/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.prop.DimPropList;
import kd.epm.eb.common.ebcommon.common.enums.AggOprtEnum;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class MemberReader {
    public static Map<Long, IDNumberTreeNode> getAllNodeFromCache(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberReader.getAllNode(entityNumber, modelNum));
    }

    public static Collection<IDNumberTreeNode> getAllNodeByDimNum(String dimNum, String modelNum) {
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        if ("epm_userdefinedmembertree".equals(entityNumber)) {
            ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>();
            MemberReader.getAllNodeFromCache(entityNumber, modelNum).values().forEach(n -> {
                if (dimNum.equals(n.getDimNumber())) {
                    nodes.add((IDNumberTreeNode)n);
                }
            });
            return nodes;
        }
        return MemberReader.getAllNodeFromCache(entityNumber, modelNum).values();
    }

    public static Map<Long, IDNumberTreeNode> getAccountAllNodeFromCache(String modelNum, String fy, String period) {
        String key = modelNum + fy + period;
        return (Map)ThreadCache.get((Object)key, () -> {
            Map<Long, IDNumberTreeNode> nodes = MemberReader.getAllNodeFromCache(DimEntityNumEnum.ACCOUNT.getEntityNum(), modelNum);
            HashMap<Long, IDNumberTreeNode> effectiveNodes = new HashMap<Long, IDNumberTreeNode>(16);
            DynamicObject[] bizchangerdsArray = BusinessDataServiceHelper.load((String)"epm_accountmembertree", (String)"id, bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate", (QFilter[])new QFilter[]{new QFilter("model.number", "=", (Object)modelNum)});
            HashMap<Long, DynamicObjectCollection> bizchangerdsMap = new HashMap<Long, DynamicObjectCollection>(16);
            for (DynamicObject dyn : bizchangerdsArray) {
                if (dyn.getDynamicObjectCollection("bizchangerds").size() <= 0) continue;
                bizchangerdsMap.put(dyn.getLong("id"), dyn.getDynamicObjectCollection("bizchangerds"));
            }
            Date expPeriodDate = PeriodUtils.calcStartAndEndDate(MemberReader.findModelIdByNum(modelNum), fy, period)[1];
            for (Map.Entry<Long, IDNumberTreeNode> entry : nodes.entrySet()) {
                DynamicObjectCollection bizchangerds = (DynamicObjectCollection)bizchangerdsMap.get(entry.getKey());
                if (bizchangerds != null && !MemberReader.isEffective(expPeriodDate, bizchangerds)) continue;
                IDNumberTreeNode treeNodeClone = entry.getValue().clone();
                MemberReader.setEffectiveChildrenNode(treeNodeClone, expPeriodDate, bizchangerdsMap);
                effectiveNodes.put(entry.getKey(), treeNodeClone);
            }
            return effectiveNodes;
        });
    }

    private static void setEffectiveChildrenNode(IDNumberTreeNode treeNode, Date expPeriodDate, Map<Long, DynamicObjectCollection> bizchangerdsMap) {
        if (treeNode.getChildren().size() == 0) {
            return;
        }
        ArrayList<IDNumberTreeNode> trueChildren = new ArrayList<IDNumberTreeNode>(10);
        for (IDNumberTreeNode node : treeNode.getChildren()) {
            DynamicObjectCollection bizchangerds = bizchangerdsMap.get(node.getId());
            if (bizchangerds != null && !MemberReader.isEffective(expPeriodDate, bizchangerds)) continue;
            IDNumberTreeNode nodeclone = node.clone();
            trueChildren.add(nodeclone);
            MemberReader.setEffectiveChildrenNode(nodeclone, expPeriodDate, bizchangerdsMap);
        }
        treeNode.setChildren(trueChildren);
    }

    public static boolean isEffective(Date expPeriodDate, DynamicObjectCollection bizchangerds) {
        for (DynamicObject dyn : bizchangerds) {
            Date effdate = dyn.getDate("bizeffdate");
            Date expdate = dyn.getDate("bizexpdate");
            if (effdate.after(expPeriodDate) || expdate != null && expdate.before(expPeriodDate)) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, IDNumberTreeNode> getAllNodeFromCache(String entityNumber, Object modelId) {
        String modelNum = "eb_definedpropertyvalue".equals(entityNumber) ? "" : MemberReader.findModelNumberById(modelId);
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberReader.getAllNode(entityNumber, modelNum));
    }

    public static IDNumberTreeNode findMemberById(String modelNum, String entityNumber, Long membId) {
        IDNumberTreeNode member = MemberReader.getAllNodeFromCache(entityNumber, modelNum).get(membId);
        if (member == null) {
            GlobalCacheServiceHelper.invalidateAllAboutDim(modelNum, entityNumber);
            member = MemberReader.getAllNodeFromCache(entityNumber, modelNum).get(membId);
            if (member == null) {
                member = IDNumberTreeNode.NotFoundTreeNode;
            }
        }
        return member;
    }

    public static IDNumberTreeNode findMemberById(long modelId, String entityNumber, Long membId) {
        IDNumberTreeNode member = MemberReader.getAllNodeFromCache(entityNumber, MemberReader.findModelNumberById(modelId)).get(membId);
        if (member == null) {
            GlobalCacheServiceHelper.invalidateAllAboutDim(MemberReader.findModelNumberById(modelId), entityNumber);
            member = MemberReader.getAllNodeFromCache(entityNumber, MemberReader.findModelNumberById(modelId)).get(membId);
            if (member == null) {
                member = IDNumberTreeNode.NotFoundTreeNode;
            }
        }
        return member;
    }

    public static IDNumberTreeNode findMemberByNumber(String modelNum, String dimNum, String number) {
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        IDNumberTreeNode m = MemberReader.searchMemberByNumber(modelNum, entityNumber, dimNum, number);
        if (m == null) {
            GlobalCacheServiceHelper.invalidateAllAboutDim(modelNum, entityNumber);
            m = MemberReader.searchMemberByNumber(modelNum, entityNumber, dimNum, number);
            if (m == null) {
                m = IDNumberTreeNode.NotFoundTreeNode;
            }
        }
        return m;
    }

    private static IDNumberTreeNode searchMemberByNumber(String modelNum, String entityNumber, String dimNum, String number) {
        for (IDNumberTreeNode m : MemberReader.getAllNodeFromCache(entityNumber, modelNum).values()) {
            if (!m.getNumber().equals(number) || !m.getDimNumber().equals(dimNum) || m.getCopyfromId() != 0L) continue;
            return m;
        }
        return null;
    }

    public static String findModelNumberById(Object id) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_id_2_number_" + id.toString(), () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id.toString()), (String)"epm_model", (String)"number");
            return dyna.getString("number");
        });
    }

    public static Long findModelIdByNum(String number) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_id_2_number_" + number, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{number}).toArray());
            return dyna.getLong("id");
        });
    }

    public static IDNumberTreeNode findFyMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "epm_yearmembertree", membId);
    }

    public static IDNumberTreeNode findPeriodMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "epm_periodmembertree", membId);
    }

    public static IDNumberTreeNode findScenaMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "epm_scenemembertree", membId);
    }

    public static IDNumberTreeNode findCurrencyMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "epm_currencymembertree", membId);
    }

    public static IDNumberTreeNode findMemberByLongNumber(String modelNum, String dimNum, String longNumber) {
        IDNumberTreeNode node = MemberReader.findMemberByPredicate(modelNum, dimNum, m -> longNumber.equals(m.getLongNumber()));
        return node == null ? IDNumberTreeNode.NotFoundTreeNode : node;
    }

    public static IDNumberTreeNode findMemberByPredicate(String modelNum, String dimNum, Predicate<IDNumberTreeNode> pre) {
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        for (IDNumberTreeNode m : MemberReader.getAllNodeFromCache(entityNumber, modelNum).values()) {
            if (!pre.test(m)) continue;
            return m;
        }
        return null;
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-number-short-" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static List<String> getDimensionProp(String modelNum, String dimNum) {
        long dimensionId = GlobalCacheServiceHelper.getOrLoadNode("Dimension-id" + modelNum + dimNum, () -> BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (String)"id", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).and("number", "=", (Object)dimNum).toArray()).getLong("id"));
        return DimPropList.getDimPropList(dimensionId).getPropList();
    }

    public static Set<Long> change2BaseMember(String entity, Set<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new HashSet<Long>(0);
        }
        return MemberReader.change2BaseMember(0L, entity, ids);
    }

    public static Set<Long> change2BaseMember(long modelId, String entity, Set<Long> ids) {
        if (entity.equals(SysDimensionEnum.Entity.getMemberTreemodel())) {
            HashSet<Long> baseIds = new HashSet<Long>();
            Map shareMemb = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"eb_dimsharemember");
            for (Long id : ids) {
                DynamicObject m = (DynamicObject)shareMemb.get(id);
                if (m != null) {
                    baseIds.add(m.getLong("memberid"));
                    continue;
                }
                baseIds.add(id);
            }
            ids = baseIds;
        }
        return ids;
    }

    private static Map<Long, IDNumberTreeNode> getAllNode(String entityname, String modelNum) {
        QFilter qf = null;
        boolean isCust = "eb_definedpropertyvalue".equals(entityname);
        boolean isEntity = "epm_entitymembertree".equals(entityname);
        if (!isCust) {
            qf = new QFilter("model.number", "=", (Object)modelNum).and(new QFilter("status", "!=", (Object)"A"));
        }
        String parent = isCust ? "parentid" : "parent";
        String copyFromId = isCust ? "" : ",copyfrom.id,aggoprt,dseq,storagetype,isleaf";
        String longNumberSeletor = isEntity ? ",longnumber,currency.number" : "";
        String simpleName = isCust ? "" : ",simplename";
        Map dcs = BusinessDataServiceHelper.loadFromCache((String)entityname, (String)(MemberReader.getSelectFields() + "," + parent + copyFromId + longNumberSeletor + simpleName), (QFilter[])(qf == null ? null : qf.toArray()), null);
        HashMap<Long, IDNumberTreeNode> nodes = new HashMap<Long, IDNumberTreeNode>(10);
        Pair<Long, String> model = null;
        HashMap<String, Pair> dimMap = new HashMap<String, Pair>(10);
        IDNumberTreeNode node = null;
        for (Map.Entry entry : dcs.entrySet()) {
            DynamicObject dyna = (DynamicObject)entry.getValue();
            if (model == null) {
                model = Pair.onePair(dyna.getLong("model.id"), modelNum);
            }
            if (isCust) {
                node = new IDNumberTreeNode(dyna.getLong("id"), dyna.getString("number"), "", 0, dyna.getInt("level"), dimMap.compute(dyna.getString("dimension.number"), (k, v) -> v == null ? Pair.onePair(((DynamicObject)entry.getValue()).getLong("dimension.id"), k) : v), StorageTypeEnum.DEFAULT, true, model, 0L, dyna.getString("name"), null);
            } else {
                String aggOprt = StringUtils.isEmpty((String)dyna.getString("aggoprt")) || "0".equals(dyna.getString("aggoprt").trim()) ? "" : AggOprtEnum.getAggOprtEnumBySign(dyna.getString("aggoprt")).getName();
                node = new IDNumberTreeNode(dyna.getLong("id"), dyna.getString("number"), aggOprt, dyna.getInt("dseq"), dyna.getInt("level"), dimMap.compute(dyna.getString("dimension.number"), (k, v) -> v == null ? Pair.onePair(((DynamicObject)entry.getValue()).getLong("dimension.id"), k) : v), StorageTypeEnum.stringToStorageType(dyna.getString("storagetype")), dyna.getBoolean("isleaf"), model, dyna.getLong("copyfrom.id"), dyna.getString("name"), dyna.getString("simplename"));
                node.setLongNumber(dyna.getString("longnumber"));
                if (isEntity) {
                    node.setCurrency(dyna.getString("currency.number"));
                }
            }
            nodes.put((Long)entry.getKey(), node);
        }
        for (DynamicObject obj : dcs.values()) {
            node = (IDNumberTreeNode)nodes.get(obj.getLong("id"));
            IDNumberTreeNode pNode = (IDNumberTreeNode)nodes.get(obj.getLong(parent + "_id"));
            if (pNode == null) continue;
            node.setParent(pNode);
            pNode.addChild(node);
        }
        return nodes;
    }

    public static String getSelectFields() {
        return "id,number,longnumber,name,dimension.number,dimension.id,model.id,level";
    }

    public static String getEntityNumberByDim(String modelNum, String dimensionNumber) {
        String entityNumByNumber = DimEntityNumEnum.getEntieyNumByNumber(dimensionNumber);
        if (dimensionNumber.equals("Version")) {
            entityNumByNumber = GlobalCacheServiceHelper.getOrLoadNode("Version-entity", () -> {
                String entityNumByNumbernew = DimEntityNumEnum.getEntieyNumByNumber(dimensionNumber);
                DynamicObject doj = QueryServiceHelper.queryOne((String)"epm_model", (String)"reporttype", (QFilter[])new QFilter("number", "=", (Object)modelNum).toArray());
                if (doj != null && ApplicationTypeEnum.isEBOrBGMDOrBGBDOrBGM(doj.getString("reporttype"))) {
                    entityNumByNumbernew = "epm_versionmembertree";
                }
                return entityNumByNumbernew;
            });
        }
        return entityNumByNumber;
    }
}

