/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.cache.prop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.cache.prop.DimPropList;
import kd.epm.eb.common.ebcommon.common.cache.prop.MemberPropValList;
import kd.epm.eb.common.ebcommon.common.cache.prop.PropFieldIterator;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;

public class MemberPropMamanger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long dimensionId;
    private Map<Long, MemberPropValList> memberPropMap = new HashMap<Long, MemberPropValList>(16);

    public MemberPropMamanger(long dimensionId, String dimNumber, String modelNumber) {
        this.dimensionId = dimensionId;
        this.load(dimNumber, modelNumber);
    }

    public static MemberPropMamanger getMemberPropMamanger(long dimensionId, String dimNumber, String modelNumber) {
        return GlobalCacheServiceHelper.getOrLoadNode("MemberPropMamanger:" + dimensionId, () -> new MemberPropMamanger(dimensionId, dimNumber, modelNumber));
    }

    private void load(String dimNumber, String modelNumber) {
        QFBuilder qf = new QFBuilder();
        qf.add("dimension.id", "=", this.dimensionId);
        QFBuilder orqf = new QFBuilder();
        PropFieldIterator.getFieldMapList().forEach(f -> orqf.or((String)f, "!=", 0L));
        qf.and(orqf);
        BusinessDataServiceHelper.loadFromCache((String)MemberReader.getEntityNumberByDim(modelNumber, dimNumber), (String)this.getSelector(), (QFilter[])qf.toArray()).values().forEach(m -> this.memberPropMap.put(m.getLong("id"), new MemberPropValList((DynamicObject)m)));
    }

    private String getSelector() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("id,");
        sb.append(String.join((CharSequence)",", PropFieldIterator.getFieldMapList()));
        return sb.toString();
    }

    public String getPropVal(long memberId, String dimProp) {
        MemberPropValList vlist = this.memberPropMap.get(memberId);
        DimPropList plist = DimPropList.getDimPropList(this.dimensionId);
        String fieldName = plist.getFieldMapped(dimProp);
        if (vlist != null && fieldName != null) {
            return vlist.getPropVal(fieldName);
        }
        return null;
    }
}

