/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.SqlParameter;

public class SQLBuilder4RDB {
    private List<Object> params = new ArrayList<Object>();
    private List<SqlParameter> sqlParams = new ArrayList<SqlParameter>();
    private StringBuilder sql;
    private static final int defaultCapacity = 500;
    private static final String JOIN_INNER = " INNER JOIN ";
    private static final String JOIN_LEFT = " JOIN LEFT ";
    private static final String JOIN_RIGHT = " JOIN RIGHT ";
    private static final String TOKEN_EQUAL = " = ";
    private static final String TOKEN_QUEST = " ? ";
    private static final String TOKEN_GREAT = " > ";
    private static final String TOKEN_LESS = " < ";
    private static final String TOKEN_GREATEQUAL = " > ";
    private static final String TOKEN_LESSEQUAL = " < ";
    private static final String KW_IN = " IN ";
    private static final String KW_NOTIN = " NOT IN ";
    private static final String KW_ON = " ON ";
    private static final String KW_SELECT = "SELECT ";
    private static final String KW_FROM = " FROM ";
    private static final String KW_WHERE = " WHERE ";
    private static final String KW_GROUPBY = " GROUP BY ";
    private static final String KW_AND = " AND ";

    public SQLBuilder4RDB() {
        this.sql = new StringBuilder(500);
    }

    public SQLBuilder4RDB(int capacity) {
        this.sql = new StringBuilder(capacity);
    }

    public SQLBuilder4RDB append(String sqlPart) {
        this.sql.append(sqlPart);
        return this;
    }

    public SQLBuilder4RDB select() {
        this.append(KW_SELECT);
        return this;
    }

    public SQLBuilder4RDB from() {
        this.append(KW_FROM);
        return this;
    }

    public SQLBuilder4RDB where() {
        this.append(KW_WHERE);
        return this;
    }

    public SQLBuilder4RDB groupBy() {
        this.append(KW_GROUPBY);
        return this;
    }

    public SQLBuilder4RDB and() {
        this.append(KW_AND);
        return this;
    }

    public SQLBuilder4RDB equal(String colName, Object val) {
        this.blank().append(colName + TOKEN_EQUAL + TOKEN_QUEST, val);
        return this;
    }

    public SQLBuilder4RDB great(String colName, Object val) {
        this.blank().append(colName + " > " + TOKEN_QUEST, val);
        return this;
    }

    public SQLBuilder4RDB less(String colName, Object val) {
        this.blank().append(colName + " < " + TOKEN_QUEST, val);
        return this;
    }

    public SQLBuilder4RDB greatEqual(String colName, Object val) {
        this.blank().append(colName + " > " + TOKEN_QUEST, val);
        return this;
    }

    public SQLBuilder4RDB lessEqual(String colName, Object val) {
        this.blank().append(colName + " < " + TOKEN_QUEST, val);
        return this;
    }

    public SQLBuilder4RDB in(String colName, Collection<?> params) {
        this.blank().append(colName + KW_IN, params);
        return this;
    }

    public SQLBuilder4RDB notIn(String colName, Collection<?> params) {
        this.blank().append(colName + KW_NOTIN, params);
        return this;
    }

    public SQLBuilder4RDB joinInner(String table, String leftCol, String rightCol) {
        this.wrapperJoinSql(JOIN_INNER, table, leftCol, rightCol);
        return this;
    }

    public SQLBuilder4RDB joinLeft(String table, String leftCol, String rightCol) {
        this.wrapperJoinSql(JOIN_LEFT, table, leftCol, rightCol);
        return this;
    }

    public SQLBuilder4RDB joinRight(String table, String leftCol, String rightCol) {
        this.wrapperJoinSql(JOIN_RIGHT, table, leftCol, rightCol);
        return this;
    }

    private void wrapperJoinSql(String joinType, String table, String leftCol, String rightCol) {
        this.blank().append(joinType).blank().append(table).blank().append(KW_ON).append(leftCol).append(TOKEN_EQUAL).append(rightCol);
    }

    public SQLBuilder4RDB blank() {
        this.sql.append(' ');
        return this;
    }

    public SQLBuilder4RDB newLine() {
        this.sql.append('\n');
        return this;
    }

    public SQLBuilder4RDB append(Object sqlPart) {
        this.sql.append(sqlPart);
        return this;
    }

    public SQLBuilder4RDB append(String sqlPart, Object param) {
        this.sql.append(sqlPart);
        this.params.add(this.getPrimitiveValue(param));
        return this;
    }

    public SQLBuilder4RDB append(String sqlPart, String fieldName, int colType, Object param) {
        this.sql.append(sqlPart);
        this.sqlParams.add(new SqlParameter(fieldName, colType, param));
        return this;
    }

    public SQLBuilder4RDB append(String sqlPart, String fieldName, int colType, Collection<?> coll) {
        this.append(sqlPart, fieldName, colType, coll.toArray());
        return this;
    }

    public SQLBuilder4RDB append(String sqlPart, String fieldName, int colType, Object[] param) {
        this.sql.append(sqlPart);
        StringBuilder paramSql = new StringBuilder("(");
        boolean hasMoreOne = false;
        for (Object obj : param) {
            this.sqlParams.add(new SqlParameter(fieldName, colType, obj));
            if (hasMoreOne) {
                paramSql.append(',');
            }
            paramSql.append('?');
            hasMoreOne = true;
        }
        paramSql.append(')');
        this.sql.append((CharSequence)paramSql);
        return this;
    }

    public Object[] getSQLParams() {
        return this.sqlParams.toArray();
    }

    private Object getPrimitiveValue(Object obj) {
        if (obj instanceof Enum) {
            throw new IllegalArgumentException("Not support param is typeof Enum!");
        }
        return obj;
    }

    public SQLBuilder4RDB append(String sqlPart, Collection<?> coll) {
        this.append(sqlPart, coll.toArray());
        return this;
    }

    public SQLBuilder4RDB append(String sqlPart, Object[] param) {
        this.sql.append(sqlPart);
        StringBuilder paramSql = new StringBuilder("(");
        boolean hasMoreOne = false;
        for (Object obj : param) {
            this.params.add(this.getPrimitiveValue(obj));
            if (hasMoreOne) {
                paramSql.append(',');
            }
            paramSql.append('?');
            hasMoreOne = true;
        }
        paramSql.append(')');
        this.sql.append((CharSequence)paramSql);
        return this;
    }

    public String getSQL() {
        return this.sql.toString();
    }

    public Object[] getParams() {
        return this.params.toArray();
    }

    public void reset() {
        this.sql.setLength(0);
        this.params.clear();
    }

    public String toString() {
        return this.sql.toString();
    }

    public static enum TestEnum {
        E1(1),
        E2(2);

        private int val;

        private TestEnum(int val) {
            this.val = val;
        }
    }
}

