/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum AccountDirectionEnum {
    DEBIT(AccountDirectionEnum.getDEBIT(), 5),
    CREDIT(AccountDirectionEnum.getCREDIT(), 6),
    NONE(AccountDirectionEnum.getNONE(), 0);

    public final MultiLangEnumBridge bridge;
    public final int index;

    private AccountDirectionEnum(MultiLangEnumBridge bridge, int index) {
        this.bridge = bridge;
        this.index = index;
    }

    public static AccountDirectionEnum getEnum(int direct) {
        switch (direct) {
            case 5: {
                return DEBIT;
            }
            case 6: {
                return CREDIT;
            }
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public int getIndex() {
        return this.index;
    }

    private static MultiLangEnumBridge getDEBIT() {
        return new MultiLangEnumBridge("\u501f", "AccountDirectionEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCREDIT() {
        return new MultiLangEnumBridge("\u8d37", "AccountDirectionEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getNONE() {
        return new MultiLangEnumBridge("\u65e0", "AccountDirectionEnum_2", "epm-eb-common");
    }

    public boolean isOppositeDC(AccountDirectionEnum accountDirectionEnum) {
        if (accountDirectionEnum != null) {
            if (accountDirectionEnum == DEBIT) {
                return this == CREDIT;
            }
            if (accountDirectionEnum == CREDIT) {
                return this == DEBIT;
            }
        }
        return false;
    }

    public boolean isSameDC(AccountDirectionEnum accountDirectionEnum) {
        return accountDirectionEnum == this;
    }
}

