/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.StringUtils;

public enum AccountTypeEnum {
    ASSET(AccountTypeEnum.getASSET(), "1"),
    DEBT(AccountTypeEnum.getDEBT(), "2"),
    RIGHTS(AccountTypeEnum.getRIGHTS(), "3"),
    INCOME(AccountTypeEnum.getINCOME(), "10"),
    COST(AccountTypeEnum.getCOST(), "10"),
    EXPENSES(AccountTypeEnum.getEXPENSES(), "10"),
    LOSS(AccountTypeEnum.getLOSS(), "10"),
    CASHFLOW(AccountTypeEnum.getCASHFLOW(), "7"),
    EXCHANGERATE(AccountTypeEnum.getEXCHANGERATE(), "8"),
    UNFINNANCE(AccountTypeEnum.getUNFINNANCE(), "9"),
    OTHERS(AccountTypeEnum.getOTHERS(), "11"),
    EB_NOTYPE(AccountTypeEnum.getEB_NOTYPE(), "12"),
    EB_INCOME(AccountTypeEnum.getEB_INCOME(), "15"),
    EB_COST(AccountTypeEnum.getEB_COST(), "16"),
    EB_EXPENSES(AccountTypeEnum.getEB_EXPENSES(), "17");

    public final MultiLangEnumBridge bridge;
    public final String index;

    private AccountTypeEnum(MultiLangEnumBridge bridge, String index) {
        this.bridge = bridge;
        this.index = index;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getIndex() {
        return this.index;
    }

    public static List<AccountTypeEnum> getAccountTypeEnums() {
        ArrayList<AccountTypeEnum> accountTypeEnum = new ArrayList<AccountTypeEnum>();
        accountTypeEnum.add(ASSET);
        accountTypeEnum.add(DEBT);
        accountTypeEnum.add(RIGHTS);
        accountTypeEnum.add(LOSS);
        accountTypeEnum.add(CASHFLOW);
        accountTypeEnum.add(EXCHANGERATE);
        accountTypeEnum.add(UNFINNANCE);
        accountTypeEnum.add(OTHERS);
        return accountTypeEnum;
    }

    public static AccountTypeEnum getEnum(String str) {
        for (AccountTypeEnum value : AccountTypeEnum.values()) {
            if (!StringUtils.equals(value.getIndex(), str)) continue;
            return value;
        }
        return null;
    }

    private static MultiLangEnumBridge getASSET() {
        return new MultiLangEnumBridge("\u8d44\u4ea7", "AccountTypeEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getDEBT() {
        return new MultiLangEnumBridge("\u8d1f\u503a", "AccountTypeEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRIGHTS() {
        return new MultiLangEnumBridge("\u6743\u76ca", "AccountTypeEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getINCOME() {
        return new MultiLangEnumBridge("\u6536\u5165", "AccountTypeEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCOST() {
        return new MultiLangEnumBridge("\u6210\u672c", "AccountTypeEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEXPENSES() {
        return new MultiLangEnumBridge("\u8d39\u7528", "AccountTypeEnum_5", "epm-eb-common");
    }

    private static MultiLangEnumBridge getLOSS() {
        return new MultiLangEnumBridge("\u635f\u76ca", "AccountTypeEnum_6", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCASHFLOW() {
        return new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf", "AccountTypeEnum_7", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEXCHANGERATE() {
        return new MultiLangEnumBridge("\u6c47\u7387\u7c7b", "AccountTypeEnum_8", "epm-eb-common");
    }

    private static MultiLangEnumBridge getUNFINNANCE() {
        return new MultiLangEnumBridge("\u975e\u8d22\u52a1\u7c7b", "AccountTypeEnum_9", "epm-eb-common");
    }

    private static MultiLangEnumBridge getOTHERS() {
        return new MultiLangEnumBridge("\u5176\u4ed6", "AccountTypeEnum_10", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEB_NOTYPE() {
        return new MultiLangEnumBridge("\u4e0d\u5206\u7c7b\u578b", "AccountTypeEnum_11", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEB_INCOME() {
        return new MultiLangEnumBridge("\u6536\u5165", "AccountTypeEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEB_COST() {
        return new MultiLangEnumBridge("\u6210\u672c", "AccountTypeEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEB_EXPENSES() {
        return new MultiLangEnumBridge("\u8d39\u7528", "AccountTypeEnum_5", "epm-eb-common");
    }
}

