/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.StringUtils;

public enum AccountUseEnum {
    MAIN(AccountUseEnum.getMAIN(), "1"),
    NOTE(AccountUseEnum.getNOTE(), "2"),
    OFFSET(AccountUseEnum.getOFFSET(), "3"),
    OTHER(AccountUseEnum.getOTHER(), "4");

    public final MultiLangEnumBridge bridge;
    public final String index;

    private AccountUseEnum(MultiLangEnumBridge bridge, String index) {
        this.bridge = bridge;
        this.index = index;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getIndex() {
        return this.index;
    }

    public static List<AccountUseEnum> getAccountUseEnums() {
        ArrayList<AccountUseEnum> accountUseEnums = new ArrayList<AccountUseEnum>();
        accountUseEnums.add(MAIN);
        accountUseEnums.add(NOTE);
        accountUseEnums.add(OFFSET);
        accountUseEnums.add(OTHER);
        return accountUseEnums;
    }

    public static AccountUseEnum getEnum(String str) {
        for (AccountUseEnum value : AccountUseEnum.values()) {
            if (!StringUtils.equals(value.getIndex(), str)) continue;
            return value;
        }
        return null;
    }

    private static MultiLangEnumBridge getMAIN() {
        return new MultiLangEnumBridge("\u4e3b\u8868", "AccountUseEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getNOTE() {
        return new MultiLangEnumBridge("\u9644\u6ce8", "AccountUseEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getOFFSET() {
        return new MultiLangEnumBridge("\u62b5\u9500\u8868", "AccountUseEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getOTHER() {
        return new MultiLangEnumBridge("\u5176\u4ed6", "AccountUseEnum_3", "epm-eb-common");
    }
}

