/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.NewEbAppUtil;

public enum ApplicationTypeEnum {
    CM(ApplicationTypeEnum.getCM(), "1", "cm"),
    RPT(ApplicationTypeEnum.getRPT(), "2", "rpt"),
    UNRPT(ApplicationTypeEnum.getUNRPT(), "3", "unrpt"),
    EB(ApplicationTypeEnum.getEB(), "4", "eb"),
    BG(ApplicationTypeEnum.getEB(), "6", "eb"),
    PUB(ApplicationTypeEnum.getPUB(), "5", "rpt"),
    IEP(ApplicationTypeEnum.getIEP(), "99", "iep"),
    BGBD(ApplicationTypeEnum.getBGBD(), "9", "bgbd"),
    BGMD(ApplicationTypeEnum.getBGMD(), "7", "bgmd"),
    BGM(ApplicationTypeEnum.getBGM(), "10", "bgm"),
    BGC(ApplicationTypeEnum.getBGC(), "11", "bgc"),
    WF(ApplicationTypeEnum.getWF(), "13", "wftask"),
    WF2(ApplicationTypeEnum.getWF(), "14", "wf");

    public final MultiLangEnumBridge name;
    public final String index;
    public final String appnum;

    private ApplicationTypeEnum(MultiLangEnumBridge name, String index, String appnum) {
        this.name = name;
        this.index = index;
        this.appnum = appnum;
    }

    public String getName() {
        switch (this.index) {
            case "1": {
                return ApplicationTypeEnum.getCM().loadKDString();
            }
            case "2": {
                return ApplicationTypeEnum.getRPT().loadKDString();
            }
            case "3": {
                return ApplicationTypeEnum.getUNRPT().loadKDString();
            }
            case "4": 
            case "6": {
                return ApplicationTypeEnum.getEB().loadKDString();
            }
            case "5": {
                return ApplicationTypeEnum.getPUB().loadKDString();
            }
            case "99": {
                return ApplicationTypeEnum.getIEP().loadKDString();
            }
            case "9": {
                return ApplicationTypeEnum.getBGBD().loadKDString();
            }
            case "7": {
                return ApplicationTypeEnum.getBGMD().loadKDString();
            }
            case "10": {
                return ApplicationTypeEnum.getBGM().loadKDString();
            }
            case "11": {
                return ApplicationTypeEnum.getBGC().loadKDString();
            }
            case "13": 
            case "14": {
                return ApplicationTypeEnum.getWF().loadKDString();
            }
        }
        return this.name.loadKDString();
    }

    public String getOIndex() {
        return this.index;
    }

    public String getAppnum() {
        return this.appnum;
    }

    public static ApplicationTypeEnum getApplication(String application) {
        if (StringUtils.isEmpty((String)application)) {
            return CM;
        }
        for (ApplicationTypeEnum typeEnum : ApplicationTypeEnum.values()) {
            if (!application.equals(typeEnum.index)) continue;
            return typeEnum;
        }
        return CM;
    }

    public static ApplicationTypeEnum getEnumByNumber(String appNum) {
        return ApplicationTypeEnum.getEnumByNumber(appNum, null);
    }

    public static ApplicationTypeEnum getEnumByNumber(String appNum, IFormView formView) {
        if (StringUtils.isEmpty((String)appNum)) {
            return CM;
        }
        if (ApplicationTypeEnum.EB.appnum.equals(appNum) && NewEbAppUtil.isNewEbApp(formView)) {
            return BG;
        }
        for (ApplicationTypeEnum typeEnum : ApplicationTypeEnum.values()) {
            if (!appNum.equals(typeEnum.appnum)) continue;
            return typeEnum;
        }
        if (appNum.equals("bg")) {
            return EB;
        }
        return CM;
    }

    public static ApplicationTypeEnum getEnumByIndex(String index) {
        if (StringUtils.isEmpty((String)index)) {
            return CM;
        }
        for (ApplicationTypeEnum typeEnum : ApplicationTypeEnum.values()) {
            if (!index.equals(typeEnum.index)) continue;
            return typeEnum;
        }
        return CM;
    }

    public static boolean isEBOrBGMDOrBGBDOrBGM(String reporttype) {
        return ApplicationTypeEnum.EB.index.equals(reporttype) || ApplicationTypeEnum.BGMD.index.equals(reporttype) || ApplicationTypeEnum.BGBD.index.equals(reporttype) || ApplicationTypeEnum.BGM.index.equals(reporttype) || ApplicationTypeEnum.WF.index.equals(reporttype) || ApplicationTypeEnum.WF2.index.equals(reporttype);
    }

    public static boolean isEBOrBGMDOrBGBDOrBGMByApp(String appnum) {
        return ApplicationTypeEnum.EB.appnum.equals(appnum) || ApplicationTypeEnum.BGMD.appnum.equals(appnum) || ApplicationTypeEnum.BGBD.appnum.equals(appnum) || ApplicationTypeEnum.BGM.appnum.equals(appnum) || "bg".equals(appnum) || ApplicationTypeEnum.WF.appnum.equals(appnum) || ApplicationTypeEnum.WF2.appnum.equals(appnum);
    }

    public static boolean isEBOrBGMDOrBGBDOrBGM(ApplicationTypeEnum app) {
        return EB == app || BGMD == app || BGBD == app || BGM == app || WF == app || WF2 == app;
    }

    public static boolean isBGMDOrBGBDOrBGM(ApplicationTypeEnum app) {
        return BGMD == app || BGBD == app || BGM == app;
    }

    public static boolean isEB(ApplicationTypeEnum app) {
        return EB == app || WF == app || WF2 == app;
    }

    private static MultiLangEnumBridge getCM() {
        return new MultiLangEnumBridge("\u5408\u5e76\u62a5\u8868", "ApplicationTypeEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRPT() {
        return new MultiLangEnumBridge("\u4e2a\u522b\u62a5\u8868", "ApplicationTypeEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getUNRPT() {
        return new MultiLangEnumBridge("\u4e2a\u522b\u62a5\u8868\u672a\u5b8c\u6210", "ApplicationTypeEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEB() {
        return new MultiLangEnumBridge("\u8d39\u7528\u9884\u7b97", "ApplicationTypeEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getPUB() {
        return new MultiLangEnumBridge("\u4e2a\u522b\u62a5\u8868\u516c\u7528", "ApplicationTypeEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getIEP() {
        return new MultiLangEnumBridge("\u667a\u80fd\u6838\u7b97", "ApplicationTypeEnum_5", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGBD() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u57fa\u7840\u8d44\u6599", "ApplicationTypeEnum_6", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGMD() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u9884\u7b97\u4f53\u7cfb", "ApplicationTypeEnum_7", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGM() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u5168\u9762\u9884\u7b97", "ApplicationTypeEnum_8", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGC() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u9884\u7b97\u63a7\u5236", "ApplicationTypeEnum_9", "epm-eb-common");
    }

    private static MultiLangEnumBridge getWF() {
        return new MultiLangEnumBridge("\u5de5\u4f5c\u6d41", "ApplicationTypeEnum_10", "epm-eb-common");
    }
}

