/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum DimTypesEnum {
    ENTITY(new MultiLangEnumBridge("\u7ec4\u7ec7", "DimTypesEnum_0", "epm-eb-common"), "Entity", "E", true),
    ACCOUNT(new MultiLangEnumBridge("\u79d1\u76ee", "DimTypesEnum_1", "epm-eb-common"), "Account", "A", true),
    YEAR(new MultiLangEnumBridge("\u8d22\u5e74", "DimTypesEnum_2", "epm-eb-common"), "Year", "FY", true),
    PERIOD(new MultiLangEnumBridge("\u671f\u95f4", "DimTypesEnum_3", "epm-eb-common"), "Period", "P", true),
    SCENARIO(new MultiLangEnumBridge("\u60c5\u666f", "DimTypesEnum_4", "epm-eb-common"), "Scenario", "S", true),
    PROCESS(new MultiLangEnumBridge("\u8fc7\u7a0b", "DimTypesEnum_5", "epm-eb-common"), "Process", "BP", true),
    CURRENCY(new MultiLangEnumBridge("\u5e01\u79cd", "DimTypesEnum_6", "epm-eb-common"), "Currency", "C", true),
    AUDITTRIAL(new MultiLangEnumBridge("\u5ba1\u8ba1\u7ebf\u7d22", "DimTypesEnum_7", "epm-eb-common"), "AuditTrail", "AT", true),
    CHANGETYPE(new MultiLangEnumBridge("\u53d8\u52a8\u7c7b\u578b", "DimTypesEnum_8", "epm-eb-common"), "ChangeType", "CT", true),
    INTERCOMPANY(new MultiLangEnumBridge("\u5f80\u6765\u7ec4\u7ec7", "DimTypesEnum_9", "epm-eb-common"), "InternalCompany", "IC", true),
    MULTIGAAP(new MultiLangEnumBridge("\u51c6\u5219", "DimTypesEnum_10", "epm-eb-common"), "MultiGAAP", "MG", false),
    PROJECT(new MultiLangEnumBridge("\u9879\u76ee", "DimTypesEnum_11", "epm-eb-common"), "Project", "PRO", false),
    BUSINESSPARTNER(new MultiLangEnumBridge("\u5546\u52a1\u4f19\u4f34", "DimTypesEnum_12", "epm-eb-common"), "BusinessPartner", "CBP", false),
    MULTIBOOK(new MultiLangEnumBridge("\u591a\u8d26\u7c3f", "DimTypesEnum_13", "epm-eb-common"), "MultiBook", "MB", false),
    VERSION(new MultiLangEnumBridge("\u7248\u672c", "DimTypesEnum_14", "epm-eb-common"), "Version", "V", false),
    DATASORT(new MultiLangEnumBridge("\u6570\u636e\u5206\u7c7b", "DimTypesEnum_15", "epm-eb-common"), "DataSort", "DS", false),
    DATATYPE(new MultiLangEnumBridge("\u6570\u636e\u7c7b\u578b", "DimTypesEnum_16", "epm-eb-common"), "DataType", "DT", true),
    MYCOMPANY(new MultiLangEnumBridge("\u6211\u65b9\u7ec4\u7ec7", "DimTypesEnum_17", "epm-eb-common"), "MyCompany", "MC", true),
    METRIC(new MultiLangEnumBridge("\u5ea6\u91cf", "DimTypesEnum_18", "epm-eb-common"), "Metric", "M", true);

    private MultiLangEnumBridge bridge;
    private String number;
    private String shortNumber;
    private boolean isPreSeted;

    private DimTypesEnum(MultiLangEnumBridge bridge, String number, String shortNumber, boolean isPreSeted) {
        this.bridge = bridge;
        this.number = number;
        this.shortNumber = shortNumber;
        this.isPreSeted = isPreSeted;
    }

    public boolean isPreSeted() {
        return this.isPreSeted;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public String getShortNumber() {
        return this.shortNumber;
    }

    public static String getShortNumberByNumber(String number) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!number.equals(t.getNumber())) continue;
            return t.getShortNumber();
        }
        return "";
    }

    public static DimTypesEnum getDimTypesEnumByNumber(String number) {
        for (DimTypesEnum d : DimTypesEnum.values()) {
            if (!d.getNumber().equals(number)) continue;
            return d;
        }
        throw new RuntimeException(String.format("not found DimTypesEnum by number:%s", number));
    }

    public static boolean include(String dimension) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!dimension.equals(t.getNumber())) continue;
            return true;
        }
        return false;
    }

    public static String getDimNumber(String shortNum, long modelId) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!shortNum.equals(t.getShortNumber())) continue;
            return t.getNumber();
        }
        QFilter filter = new QFilter("shortnumber", "=", (Object)shortNum);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{filter, modelFilter});
        if (dy != null) {
            return dy.getString("number");
        }
        throw new RuntimeException(String.format("not found DimTypesEnum by shortnumber:%s", shortNum));
    }
}

