/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum ElimTypeEnum {
    EICA("EICA", 1, ElimTypeEnum.getEICA()),
    EIT("EIT", 2, ElimTypeEnum.getEIT()),
    EOE("EOE", 3, ElimTypeEnum.getEOE()),
    ECF("ECF", 4, ElimTypeEnum.getECF()),
    ADJ("ADJ", 20, ElimTypeEnum.getADJ()),
    EOTHER("EOther", 9, ElimTypeEnum.getEOTHER()),
    EJE("EJE", 0, ElimTypeEnum.getEJE());

    private String number;
    private int value;
    private MultiLangEnumBridge name;

    private ElimTypeEnum(String number, int value, MultiLangEnumBridge name) {
        this.number = number;
        this.value = value;
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public static ElimTypeEnum getEnum(Integer type) {
        if (type == null) {
            return null;
        }
        for (ElimTypeEnum e : ElimTypeEnum.values()) {
            if (e.getValue() != type.intValue()) continue;
            return e;
        }
        throw new RuntimeException(ElimTypeEnum.class.getName() + "error value:" + type);
    }

    public static ElimTypeEnum getEnum(String number) {
        if (number == null) {
            return null;
        }
        for (ElimTypeEnum e : ElimTypeEnum.values()) {
            if (!e.getNumber().equals(number)) continue;
            return e;
        }
        throw new RuntimeException(ElimTypeEnum.class.getName() + "error value:" + number);
    }

    private static MultiLangEnumBridge getEJE() {
        return new MultiLangEnumBridge("\u62b5\u9500", "ElimTypeEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEICA() {
        return new MultiLangEnumBridge("\u5f80\u6765\u7c7b", "ElimTypeEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEIT() {
        return new MultiLangEnumBridge("\u4ea4\u6613\u7c7b", "ElimTypeEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEOE() {
        return new MultiLangEnumBridge("\u6295\u8d44\u7c7b", "ElimTypeEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getECF() {
        return new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u7c7b", "ElimTypeEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getADJ() {
        return new MultiLangEnumBridge("\u8c03\u6574", "ElimTypeEnum_5", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEOTHER() {
        return new MultiLangEnumBridge("\u5176\u4ed6", "ElimTypeEnum_6", "epm-eb-common");
    }
}

