/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum StorageTypeEnum {
    DEFAULT("", "0"),
    LABEL(StorageTypeEnum.getLABELStr(), "1"),
    STORAGE(StorageTypeEnum.getSTORAGEStr(), "2"),
    SHARE(StorageTypeEnum.getSHAREStr(), "3"),
    UNSHARE(StorageTypeEnum.getUNSHAREStr(), "4"),
    DYNAMIC(StorageTypeEnum.getDYNAMICStr(), "5");

    public final MultiLangEnumBridge name;
    public final String index;

    private StorageTypeEnum(MultiLangEnumBridge name, String index) {
        this.name = name;
        this.index = index;
    }

    private StorageTypeEnum(String name, String index) {
        this.name = new MultiLangEnumBridge(name, "", "");
        this.index = index;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getOIndex() {
        return this.index;
    }

    public static StorageTypeEnum stringToStorageType(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        if (value.length() > 1) {
            throw new RuntimeException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b\u201c%1\u201d\u3002", (String)"StorageTypeEnum_0", (String)"epm-eb-common", (Object[])new Object[]{value}));
        }
        switch (value.charAt(0)) {
            case '1': {
                return LABEL;
            }
            case '2': {
                return STORAGE;
            }
            case '3': {
                return SHARE;
            }
            case '4': {
                return UNSHARE;
            }
            case '5': {
                return DYNAMIC;
            }
        }
        throw new RuntimeException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b\u201c%1\u201d\u3002", (String)"StorageTypeEnum_0", (String)"epm-eb-common", (Object[])new Object[]{value}));
    }

    public static boolean isShare(String storageType) {
        return StorageTypeEnum.isShare(StorageTypeEnum.stringToStorageType(storageType));
    }

    public static boolean isShare(StorageTypeEnum storageType) {
        return SHARE == storageType;
    }

    public static StorageTypeEnum getStorageTypeEnumByIndex(String index) {
        for (StorageTypeEnum storageTypeEnum : StorageTypeEnum.values()) {
            if (!storageTypeEnum.getOIndex().equals(index)) continue;
            return storageTypeEnum;
        }
        throw new RuntimeException(ResManager.loadResFormat((String)"\u9519\u8bef\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b\u201c%1\u201d\u3002", (String)"StorageTypeEnum_0", (String)"epm-eb-common", (Object[])new Object[]{index}));
    }

    public static MultiLangEnumBridge getLABELStr() {
        return new MultiLangEnumBridge("\u6807\u7b7e", "StorageTypeEnum_1", "epm-eb-common");
    }

    public static MultiLangEnumBridge getSTORAGEStr() {
        return new MultiLangEnumBridge("\u5b58\u50a8", "StorageTypeEnum_2", "epm-eb-common");
    }

    public static MultiLangEnumBridge getSHAREStr() {
        return new MultiLangEnumBridge("\u5171\u4eab", "StorageTypeEnum_3", "epm-eb-common");
    }

    public static MultiLangEnumBridge getUNSHAREStr() {
        return new MultiLangEnumBridge("\u4e0d\u5171\u4eab", "StorageTypeEnum_4", "epm-eb-common");
    }

    public static MultiLangEnumBridge getDYNAMICStr() {
        return new MultiLangEnumBridge("\u52a8\u6001\u8ba1\u7b97", "StorageTypeEnum_5", "epm-eb-common");
    }
}

