/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.log;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class DebugHelper {
    private static final Log log = LogFactory.getLog(DebugHelper.class);

    public static void debugDataObjectType(String ... types) {
        for (String type : types) {
            log.error("query DataEntityType[" + type + "] from db -->" + DebugHelper.doQueryMeta(type, type, RuntimeMetaType.Entity));
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)type);
            log.error("query DataEntityType[" + type + "] JSON-->" + EntityItemTypes.toJsonString((IDataEntityType)entityType));
        }
    }

    private static String doQueryMeta(String number, String ctlKey, RuntimeMetaType type) {
        String sql = "select FDATA from T_META_ENTITY where FNUMBER = ? and FKEY = ? and FTYPE = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number), new SqlParameter(":FKEY", 12, (Object)ctlKey), new SqlParameter(":FTYPE", 5, (Object)type.getValue())};
        ResultSetHandler<Object> callBackHanlder = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                String sFdata = null;
                try {
                    if (rs.next()) {
                        sFdata = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return sFdata;
            }
        };
        String sRet = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        if (StringUtils.isBlank((CharSequence)sRet)) {
            sRet = "";
        }
        return sRet;
    }
}

