/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.log;

import com.google.common.base.Ticker;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class WatchLogger {
    private Log log;

    public WatchLogger(Class<?> clazz) {
        this.log = LogFactory.getLog(clazz);
    }

    public void startWatch() {
        this.getStopwatch().start(true);
    }

    public void resetWatch() {
        this.getStopwatch().resetWatch();
    }

    protected abstract FragmentStopwatch getStopwatch();

    public void warn(String msg) {
        msg = this.addWatchTime(msg, false);
        this.log.warn(msg);
        this.getStopwatch().start(false);
    }

    public void info(String msg) {
        msg = this.addWatchTime(msg, false);
        this.log.info(msg);
        this.getStopwatch().start(false);
    }

    public void debug(String msg) {
        msg = this.addWatchTime(msg, false);
        this.log.debug(msg);
        this.getStopwatch().start(false);
    }

    public void infoEnd(String msg) {
        msg = this.addWatchTime(msg, true);
        this.log.info(msg);
    }

    public void debugEnd(String msg) {
        msg = this.addWatchTime(msg, true);
        this.log.debug(msg);
    }

    private String addWatchTime(String msg, boolean isEnd) {
        StackTraceElement[] lvStacks = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(100);
        sb.append("--epm--").append(this.getStopwatch().elapsed(TimeUnit.MILLISECONDS, isEnd)).append("ms ----");
        if (lvStacks[4].getClassName().contains(".epm.")) {
            String superClassName = this.getSuperClassName(lvStacks[4]);
            sb.append(superClassName).append('.').append(lvStacks[4].getMethodName()).append('[').append(lvStacks[4].getLineNumber() - 1).append(']');
        }
        sb.append('.').append(lvStacks[3].getMethodName()).append("()[").append(lvStacks[3].getLineNumber() - 1).append(']').append(msg);
        return sb.toString();
    }

    private String getSuperClassName(StackTraceElement s) {
        String[] packs = s.getClassName().split("\\.");
        return packs[packs.length - 1];
    }

    public void error(String msg) {
        msg = this.addWatchTime(msg, false);
        this.log.error(msg);
        this.getStopwatch().start(false);
    }

    public void error(Throwable e) {
        this.log.error(e);
    }

    public void error(String msg, Throwable e) {
        this.log.error(msg, e);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public static WatchLogger getInstanceLog(boolean isSyncro, Class<?> clazz) {
        return isSyncro ? new WatchLoggerSyncro(clazz) : new WatchLoggerNew(clazz);
    }

    private static class FragmentStopwatch {
        private Stack<Long> watchTimeStack = new Stack();
        private Stack<Long> startStack = new Stack();
        private Stack<Long> preEndTimeStack = new Stack();
        private static final Ticker ticker = Ticker.systemTicker();

        private FragmentStopwatch() {
        }

        protected void start(boolean isStartWatch) {
            long time = ticker.read();
            if (isStartWatch) {
                this.startStack.push(time);
                this.preEndTimeStack.push(this.watchTimeStack.isEmpty() ? Long.valueOf(time) : this.watchTimeStack.peek());
            }
            this.watchTimeStack.push(time);
        }

        protected long elapsed(TimeUnit unit, boolean isEnd) {
            return unit.convert(ticker.read() - this.calculateTime(isEnd), TimeUnit.NANOSECONDS);
        }

        long calculateTime(boolean isEnd) {
            long time;
            if (this.startStack.isEmpty() || this.watchTimeStack.isEmpty()) {
                return ticker.read();
            }
            long startTime = this.startStack.peek();
            long watchTime = this.watchTimeStack.peek();
            if (isEnd) {
                this.startStack.pop();
            }
            if (startTime == watchTime) {
                return this.watchTimeStack.pop();
            }
            long l = time = isEnd ? startTime : this.watchTimeStack.pop();
            if (isEnd && !this.preEndTimeStack.isEmpty()) {
                long temp;
                long presTime = this.preEndTimeStack.pop();
                while (!this.watchTimeStack.isEmpty() && presTime != (temp = this.watchTimeStack.peek().longValue())) {
                    this.watchTimeStack.pop();
                }
            }
            return time;
        }

        void resetWatch() {
            this.watchTimeStack.clear();
            this.startStack.clear();
        }

        private static FragmentStopwatch createUnstarted() {
            return new FragmentStopwatch();
        }
    }

    public static class WatchLoggerSyncro
    extends WatchLogger {
        private static ThreadLocal<FragmentStopwatch> localStopwatches = new ThreadLocal<FragmentStopwatch>(){

            @Override
            protected FragmentStopwatch initialValue() {
                return FragmentStopwatch.createUnstarted();
            }
        };

        public WatchLoggerSyncro(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected FragmentStopwatch getStopwatch() {
            return localStopwatches.get();
        }
    }

    public static class WatchLoggerNew
    extends WatchLogger {
        private FragmentStopwatch watch = FragmentStopwatch.access$000();

        public WatchLoggerNew(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected FragmentStopwatch getStopwatch() {
            return this.watch;
        }
    }
}

