/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.util;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.PairList;
import kd.epm.eb.common.ebcommon.common.util.ChineseUtil;

public class BizRuleScriptAnalyzer {
    private String script;
    private static final Set<Character> leftBraket = ImmutableSet.of((Object)Character.valueOf('['), (Object)Character.valueOf('{'), (Object)Character.valueOf('('));
    private static final Set<Character> rightBraket = ImmutableSet.of((Object)Character.valueOf(']'), (Object)Character.valueOf('}'), (Object)Character.valueOf(')'));
    private static final Map<Character, Character> braketMap = new HashMap<Character, Character>(8);

    public BizRuleScriptAnalyzer(String script) {
        this.script = script;
    }

    public String checkValidate() {
        if (this.script == null || this.script.trim().length() == 0) {
            return "";
        }
        PairList<String, Integer> lines = this.parseValidateLine();
        if (lines.size() == 0) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        this.checkChinessPunctuation(msg, lines);
        this.checkBraket(msg, lines);
        return msg.toString();
    }

    public void checkBraket(StringBuilder msg, PairList<String, Integer> lines) {
        Stack<Pair> braket = new Stack<Pair>();
        block0: for (Pair<String, Integer> l2 : lines.toList()) {
            char[] chars = ((String)l2.p1).toCharArray();
            int size = chars.length;
            for (int i = 0; i < size; ++i) {
                if (leftBraket.contains(Character.valueOf(chars[i]))) {
                    braket.push(Pair.onePair(Character.valueOf(chars[i]), l2.p2));
                    continue;
                }
                if (!rightBraket.contains(Character.valueOf(chars[i]))) continue;
                if (braket.isEmpty()) {
                    this.nextLine(msg);
                    msg.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7f3a\u5c11%2\u4e0e\u4e4b\u5339\u914d\u7684\u7b26\u53f7%3;", (String)"BizRuleScriptAnalyzer_0", (String)"epm-eb-common", (Object[])new Object[]{l2.p2, Character.valueOf(chars[i]), braketMap.get(Character.valueOf(chars[i]))}));
                    braket.clear();
                    break block0;
                }
                Pair p = (Pair)braket.pop();
                if (braketMap.get(p.p1).charValue() == chars[i]) continue;
                this.nextLine(msg);
                msg.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7f3a\u5c11%2\u4e0e\u4e4b\u5339\u914d\u7684\u7b26\u53f7%3;", (String)"BizRuleScriptAnalyzer_0", (String)"epm-eb-common", (Object[])new Object[]{l2.p2, Character.valueOf(chars[i]), braketMap.get(Character.valueOf(chars[i]))}));
                braket.clear();
                break block0;
            }
        }
        if (!braket.isEmpty()) {
            braket.forEach(l -> {
                this.nextLine(msg);
                msg.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7f3a\u5c11\u4e0e\u201c%2\u201d\u5339\u914d\u7684\u7b26\u53f7\u201c%3\u201d\u3002", (String)"BizRuleScriptAnalyzer_1", (String)"epm-eb-common", (Object[])new Object[]{l.p2, l.p1, braketMap.get(l.p1)}));
            });
        }
    }

    private void nextLine(StringBuilder msg) {
        if (msg.length() > 0) {
            msg.append("\n");
        }
    }

    private void checkChinessPunctuation(StringBuilder msg, PairList<String, Integer> lines) {
        StringBuilder lineMsg = new StringBuilder();
        lines.forEach(l -> {
            lineMsg.setLength(0);
            char[] chars = ((String)l.p1).toCharArray();
            int size = chars.length;
            for (int i = 0; i < size; ++i) {
                if (!ChineseUtil.isChinesePunctuation(chars[i])) continue;
                lineMsg.append(ResManager.loadResFormat((String)"\u7b2c%d\u5b57\u7b26%s\u4e3a\u5168\u89d2\u5b57\u7b26;", (String)"BizRuleScriptAnalyzer_2", (String)"epm-eb-common", (Object[])new Object[]{i + 1, Character.valueOf(chars[i])}));
            }
            if (lineMsg.length() > 0) {
                this.nextLine(msg);
                msg.append(ResManager.loadResFormat((String)"\u7b2c1d\u884c%2", (String)"BizRuleScriptAnalyzer_3", (String)"epm-eb-common", (Object[])new Object[]{l.p2, lineMsg}));
            }
        });
    }

    private PairList<String, Integer> parseValidateLine() {
        StringBuilder line = new StringBuilder();
        int lineNumber = 1;
        char preChar = ' ';
        boolean isLineAnnotationSign = false;
        boolean isValidateChar = false;
        PairList<String, Integer> plist = new PairList<String, Integer>();
        Stack<String> areaAnnotationStack = new Stack<String>();
        for (char c : this.script.toCharArray()) {
            isValidateChar = false;
            if (c == '\n') {
                isLineAnnotationSign = false;
                String temp = line.toString().trim();
                if (temp.length() > 0 && !"\r".equals(temp)) {
                    plist.addPair(line.toString(), lineNumber);
                }
                ++lineNumber;
                line.setLength(0);
            } else if ('/' == preChar && c == '*') {
                areaAnnotationStack.push("left");
                if (line.length() > 0) {
                    line.deleteCharAt(line.length() - 1);
                }
            } else if (c == '/' && preChar == '/' && !this.isAreaAnnotationSign(areaAnnotationStack)) {
                if (line.length() > 0) {
                    line.deleteCharAt(line.length() - 1);
                }
                isLineAnnotationSign = true;
            } else if (preChar == '*' && c == '/' && this.isAreaAnnotationSign(areaAnnotationStack)) {
                areaAnnotationStack.pop();
            } else if (!this.isAreaAnnotationSign(areaAnnotationStack) && !isLineAnnotationSign) {
                isValidateChar = true;
            }
            if (isValidateChar) {
                line.append(c);
            }
            preChar = c;
        }
        if (line.length() > 0) {
            plist.addPair(line.toString(), lineNumber);
        }
        return plist;
    }

    private boolean isAreaAnnotationSign(Stack<String> areaAnnotationStack) {
        return !areaAnnotationStack.isEmpty() && areaAnnotationStack.peek().equals("left");
    }

    public static void main(String[] args) {
        String content = "//\u5982\u9700\u5199\u6ce8\u91ca\uff0c\u8bf7\u5728\u6bcf\u884c\u4ee5\u201c//\u201d\u5f00\u5934\u3002nvar params = new Array(Account[\"QCF39222\"].base()n);//\u5b9a\u4e49\u6570\u7ec4\uff0c\u628a\u9650\u5b9a\u79d1\u76ee\u4f5c\u4e3a\u53c2\u6570\uff0c\u4e5f\u53ef\u4ee5\u4e0d\u653enparams.push(Account[\"QCF392\"].base());//\u53ef\u4ee5\u5f80\u6570\u7ec4\u4e2d\u8ffd\u52a0nparams.push(C1[\"C1QB137010101\"].base());//\u53ef\u4ee5\u5f80\u6570\u7ec4\u4e2d\u8ffd\u52a0nvar scope1 = scope(params);//\u6570\u7ec4\u4f5c\u4e3ascope\u53c2\u6570nvar scope2 = \n    scope(Account[\"QCF39222\"].base());//\u76f4\u63a5\u628a\u6210\u5458\u5bf9\u8c61\u4f5c\u4e3ascopenif(\"\u6211\" === \"\" /*\u6211*/){n  \n}\n/**\n/*\n*/";
        BizRuleScriptAnalyzer analyzer = new BizRuleScriptAnalyzer(content);
        System.out.println(analyzer.checkValidate());
    }

    static {
        braketMap.put(Character.valueOf('['), Character.valueOf(']'));
        braketMap.put(Character.valueOf(']'), Character.valueOf('['));
        braketMap.put(Character.valueOf('('), Character.valueOf(')'));
        braketMap.put(Character.valueOf(')'), Character.valueOf('('));
        braketMap.put(Character.valueOf('{'), Character.valueOf('}'));
        braketMap.put(Character.valueOf('}'), Character.valueOf('{'));
    }
}

