/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;

public class DataEntityUtils {
    public static boolean checkExistInherentAttribute(String entity, String properityNum) {
        DataEntityPropertyCollection dy = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
        return dy.get((Object)properityNum) != null;
    }

    public static void removeMaimEntityInvalidataPropItem(DynamicObjectType type, DynamicProperty prop) {
        Field field = DataEntityUtils.getClassField(type.getClass(), "_properties");
        if (field == null) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            DynamicPropertyCollection properties = (DynamicPropertyCollection)field.get(type);
            properties.remove((Object)prop);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] fields;
        Field field = null;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            field = f;
            break;
        }
        if (field == null && clazz != Object.class) {
            field = DataEntityUtils.getClassField(clazz.getSuperclass(), fieldName);
        }
        return field;
    }

    public static void addBasedataF7ToMainEntity(Container targContainer, MainEntityType targetEntity, String f7key, String basedataEntity, IDataModel model, IFormView view) {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(f7key);
        basedataProp.setBaseEntityId(basedataEntity);
        basedataProp.setDisplayProp("name");
        basedataProp.setNumberProp("number");
        LongProp idprop = new LongProp();
        idprop.setName(f7key + "_id");
        if (ApplicationTypeEnum.BGMD.getAppnum().equals(view.getFormShowParameter().getAppId())) {
            idprop.setDbIgnore(true);
        }
        basedataProp.setRefIdProp((IDataEntityProperty)idprop);
        basedataProp.setRefIdPropName(idprop.getName());
        targetEntity.addProperty((DynamicProperty)basedataProp);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
        DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)idprop);
        } else {
            targetEntity.addProperty((DynamicProperty)basedataProp);
            targetEntity.addProperty((DynamicProperty)idprop);
        }
        BasedataEdit bsEdit = new BasedataEdit();
        bsEdit.setKey(f7key);
        bsEdit.setFieldKey(f7key);
        bsEdit.setModel(model);
        bsEdit.setView(view);
        bsEdit.setDisplayProp("name");
        targContainer.getItems().add(bsEdit);
    }

    public static void addComboToMainEntity(Container targContainer, MainEntityType targetEntity, String comboKey, List<ValueMapItem> valueMapItemList, EntityMetadata entityMetadata, IDataModel model, IFormView view) {
        ComboProp comboProp = new ComboProp();
        comboProp.setName(comboKey);
        comboProp.setComboItems(valueMapItemList);
        targetEntity.addProperty((DynamicProperty)comboProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)comboProp);
        }
        FieldAp fieldAp = new FieldAp();
        fieldAp.setName(new LocaleString(comboKey));
        fieldAp.setKey(comboKey);
        ComboField comboField = new ComboField();
        comboField.setKey(comboKey);
        comboField.setEntityMetadata(entityMetadata);
        entityMetadata.getItems().add(comboField);
        fieldAp.setField((kd.bos.metadata.entity.commonfield.Field)comboField);
        FieldEdit control = fieldAp.createRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public static void addMultiBasedataF7ToMainEntity(Container targContainer, MainEntityType targetEntity, String f7key, String basedataEntity, IDataModel model, IFormView view) {
        MainEntityType originalType = EntityMetadataCache.getDataEntityType((String)basedataEntity);
        DynamicObjectType multiSelcType = new DynamicObjectType(f7key);
        multiSelcType.setAlias(originalType.getAlias());
        multiSelcType.setDbIgnore(StringUtils.isBlank((CharSequence)originalType.getAlias()));
        multiSelcType.setDBRouteKey(StringUtils.isNotBlank((CharSequence)originalType.getAlias()) ? originalType.getDBRouteKey() : "");
        multiSelcType.setExtendName(basedataEntity);
        DataEntityUtils.registerProperties(multiSelcType, basedataEntity);
        MulBasedataProp basedataProp = new MulBasedataProp(f7key, multiSelcType);
        basedataProp.setName(f7key);
        basedataProp.setBaseEntityId(basedataEntity);
        basedataProp.setDisplayProp("name");
        DataEntityUtils.makeUnmodifiable((IDataEntityType)targetEntity);
        if (targetEntity.getParent() != null) {
            DataEntityUtils.makeUnmodifiable(targetEntity.getParent());
        }
        targetEntity.addProperty((DynamicProperty)basedataProp);
        DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
        } else {
            targetEntity.addProperty((DynamicProperty)basedataProp);
        }
        MulBasedataEdit bsEdit = new MulBasedataEdit();
        bsEdit.setKey(f7key);
        bsEdit.setFieldKey(f7key);
        bsEdit.setDisplayProp("name");
        bsEdit.setModel(model);
        bsEdit.setView(view);
        targContainer.getItems().add(bsEdit);
    }

    private static void makeUnmodifiable(IDataEntityType dt) {
        try {
            Method setUnmodifiable = DynamicObjectType.class.getDeclaredMethod("setUnmodifiable", Boolean.TYPE);
            ReflectionUtils.makeAccessible((Method)setUnmodifiable);
            setUnmodifiable.invoke((Object)dt, Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerProperties(DynamicObjectType type, String basedataEntity) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        baseProp.setBaseEntityId(basedataEntity);
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
        baseProp.setDisplayProp("name,number");
        LongProp idprop = new LongProp();
        idprop.setName("fbasedataid_id");
        idprop.setAlias("FBasedataId");
        baseProp.setRefIdProp((IDataEntityProperty)idprop);
        baseProp.setRefIdPropName(idprop.getName());
        type.addProperty((DynamicProperty)baseProp);
        type.addProperty((DynamicProperty)idprop);
    }

    public static boolean isIncludeShareField(String dimEntityNum) {
        return !"epm_processmembertree".equals(dimEntityNum) && !"epm_currencymembertree".equals(dimEntityNum);
    }

    public static BasedataEdit createF7Component(String ctrlKey, IDataModel model, IFormView view, QFilter qfilter, IComponentMoreSetting<BasedataEdit> f7) {
        BasedataEdit bsEdit = new BasedataEdit();
        bsEdit.setKey(ctrlKey);
        bsEdit.setModel(model);
        bsEdit.setView(view);
        bsEdit.setFieldKey(ctrlKey);
        bsEdit.setDisplayProp("name");
        if (qfilter != null) {
            bsEdit.setQFilter(qfilter);
        }
        if (f7 != null) {
            f7.setting(bsEdit);
        }
        return bsEdit;
    }

    public static interface IComponentMoreSetting<T> {
        public void setting(T var1);
    }
}

