/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.common.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import kd.bos.util.ExceptionUtils;
import kd.epm.eb.common.utils.StringUtils;

public class ThrowableHelper {
    public static String getMessage(Exception e) {
        if (e != null) {
            if (StringUtils.isNotEmpty(e.getMessage())) {
                return e.getMessage();
            }
            return ThrowableHelper.toString(e);
        }
        return null;
    }

    public static String toString(Exception exception) {
        return ExceptionUtils.getExceptionStackTraceMessage((Exception)exception);
    }

    public static String toString(Throwable t) {
        return ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)t));
    }

    public static String[] generatekernelMessage(Throwable throwable, int level) {
        String[] result = new String[]{};
        if (throwable == null) {
            return result;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            LineNumberReader reader = new LineNumberReader(new StringReader(ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)throwable))));
            String line = reader.readLine();
            boolean foundCased = false;
            while (line != null) {
                if (line.contains("Caused By") || line.contains("Exception") || foundCased) {
                    lines.add(line);
                    foundCased = true;
                }
                if (lines.size() < level) {
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            lines.add(ex.toString());
        }
        return lines.toArray(result);
    }

    public static String generatekernelMessageInfo(Throwable throwable, int level) {
        CharSequence[] msgs = ThrowableHelper.generatekernelMessage(throwable, level);
        return String.join((CharSequence)"\n", msgs);
    }

    public static String generateFirstThreadCauseMessageInfo(Throwable throwable, int level) {
        while (throwable != null && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ThrowableHelper.generatekernelMessageInfo(throwable, level);
    }

    public static String printError(Throwable t) {
        return ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)t));
    }
}

