/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.spread.formula;

import java.util.List;
import java.util.Stack;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Area3DExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.AreaExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.BinaryOperationExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.BoolExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.EmptyArgExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Expression;
import kd.epm.eb.common.ebcommon.spread.formula.expr.FunctionExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.IntExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.NameExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.NumberExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Ref3DExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.ReferenceExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.StringExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.UnaryOperationExpr;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.AddPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.Area3DPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.AreaPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.BoolPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.ConcatPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.DividePtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.EmptyArgPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.EqualPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.FuncVarPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.GreaterEqualPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.GreaterThanPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.IntPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.LessEqualPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.LessThanPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.MultiplyPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.NamePtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.NotEqualPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.NumberPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.OperationPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.PercentPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.PowerPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.Ptg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.Ref3DPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.ReferencePtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.StringPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.SubtractPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.UnaryMinusPtg;
import kd.epm.eb.common.ebcommon.spread.formula.ptg.UnaryPlusPtg;

public class ExcelFormulaParser {
    private final List<Object> tokens;

    public ExcelFormulaParser(List<Object> tokens) {
        this.tokens = tokens;
    }

    public Expression parse() throws Exception {
        if (this.tokens == null || 0 == this.tokens.size()) {
            return null;
        }
        Stack<Expression> stack = new Stack<Expression>();
        int numPtgs = this.tokens.size();
        for (int i = 0; i < numPtgs; ++i) {
            Ptg p;
            Expression e;
            Object object = this.tokens.get(i);
            if (object instanceof OperationPtg) {
                if (object instanceof AddPtg) {
                    this.buildBinaryOp(stack, 7);
                    continue;
                }
                if (object instanceof SubtractPtg) {
                    this.buildBinaryOp(stack, 8);
                    continue;
                }
                if (object instanceof MultiplyPtg) {
                    this.buildBinaryOp(stack, 5);
                    continue;
                }
                if (object instanceof DividePtg) {
                    this.buildBinaryOp(stack, 6);
                    continue;
                }
                if (object instanceof PowerPtg) {
                    this.buildBinaryOp(stack, 4);
                    continue;
                }
                if (object instanceof LessEqualPtg) {
                    this.buildBinaryOp(stack, 13);
                    continue;
                }
                if (object instanceof EqualPtg) {
                    this.buildBinaryOp(stack, 10);
                    continue;
                }
                if (object instanceof LessThanPtg) {
                    this.buildBinaryOp(stack, 14);
                    continue;
                }
                if (object instanceof NotEqualPtg) {
                    this.buildBinaryOp(stack, 15);
                    continue;
                }
                if (object instanceof GreaterEqualPtg) {
                    this.buildBinaryOp(stack, 11);
                    continue;
                }
                if (object instanceof GreaterThanPtg) {
                    this.buildBinaryOp(stack, 12);
                    continue;
                }
                if (object instanceof ConcatPtg) {
                    this.buildBinaryOp(stack, 9);
                    continue;
                }
                if (object instanceof FuncVarPtg) {
                    FunctionExpr bop = new FunctionExpr(((FuncVarPtg)object).getName());
                    int numOperands = ((FuncVarPtg)object).getNumberOfOperands();
                    for (int j = 0; j < numOperands; ++j) {
                        bop.getParameters().add(0, stack.pop());
                    }
                    stack.push(bop);
                    continue;
                }
                if (!(object instanceof UnaryMinusPtg) && !(object instanceof UnaryPlusPtg) && !(object instanceof PercentPtg)) continue;
                Expression expr = stack.pop();
                int type = 3;
                if (object instanceof UnaryPlusPtg) {
                    type = 1;
                } else if (object instanceof UnaryMinusPtg) {
                    type = 2;
                } else if (object instanceof PercentPtg) {
                    type = 3;
                }
                UnaryOperationExpr e2 = new UnaryOperationExpr(type);
                e2.setOperand(expr);
                stack.push(e2);
                continue;
            }
            if (object instanceof IntPtg) {
                e = new IntExpr();
                e.setValue(((IntPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof NumberPtg) {
                e = new NumberExpr(((NumberPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof StringPtg) {
                e = new StringExpr(((StringPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof BoolPtg) {
                e = new BoolExpr(((BoolPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof AreaPtg) {
                p = (AreaPtg)object;
                AreaExpr exp = new AreaExpr(((AreaPtg)p).getFirstRow(), ((AreaPtg)p).getFirstColumn(), ((AreaPtg)p).getLastRow(), ((AreaPtg)p).getLastColumn());
                exp.setFirstColRel(((AreaPtg)p).isFirstColRelative());
                exp.setLastColRel(((AreaPtg)p).isLastColRelative());
                exp.setFirstRowRel(((AreaPtg)p).isFirstRowRelative());
                exp.setLastRowRel(((AreaPtg)p).isLastRowRelative());
                stack.push(exp);
                continue;
            }
            if (object instanceof ReferencePtg) {
                p = (ReferencePtg)object;
                ReferenceExpr exp = new ReferenceExpr();
                exp.col = ((ReferencePtg)p).getColumn();
                exp.row = ((ReferencePtg)p).getRow();
                exp.setColRel(((ReferencePtg)p).isColRelative());
                exp.setRowRel(((ReferencePtg)p).isRowRelative());
                stack.push(exp);
                continue;
            }
            if (object instanceof Area3DPtg) {
                p = (Area3DPtg)object;
                Area3DExpr exp = new Area3DExpr();
                exp.setSheetName(((Area3DPtg)p).getSheetName());
                AreaExpr area = new AreaExpr(((Area3DPtg)p).getFirstRow(), ((Area3DPtg)p).getFirstColumn(), ((Area3DPtg)p).getLastRow(), ((Area3DPtg)p).getLastColumn());
                area.setFirstColRel(((Area3DPtg)p).isFirstColRelative());
                area.setLastColRel(((Area3DPtg)p).isLastColRelative());
                area.setFirstRowRel(((Area3DPtg)p).isFirstRowRelative());
                area.setLastRowRel(((Area3DPtg)p).isLastRowRelative());
                exp.setArea(area);
                stack.push(exp);
                continue;
            }
            if (object instanceof Ref3DPtg) {
                p = (Ref3DPtg)object;
                Ref3DExpr expr = new Ref3DExpr();
                expr.setSheetName(((Ref3DPtg)p).getSheetName());
                ReferenceExpr ref = new ReferenceExpr();
                ref.row = ((Ref3DPtg)p).getRow();
                ref.col = ((Ref3DPtg)p).getColumn();
                ref.setColRel(((Ref3DPtg)p).isColRelative());
                ref.setRowRel(((Ref3DPtg)p).isRowRelative());
                expr.setRef(ref);
                stack.push(expr);
                continue;
            }
            if (object instanceof NamePtg) {
                stack.push(new NameExpr(((NamePtg)object).getText()));
                continue;
            }
            if (!(object instanceof EmptyArgPtg)) continue;
            stack.push(new EmptyArgExpr());
        }
        return (Expression)stack.pop();
    }

    public void buildBinaryOp(Stack<Expression> stack, int type) {
        BinaryOperationExpr bop = new BinaryOperationExpr(type);
        bop.setRight(stack.pop());
        bop.setLeft(stack.pop());
        stack.push(bop);
    }
}

