/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.spread.formula;

import java.util.List;
import kd.epm.eb.common.ebcommon.spread.formula.ExcelFormulaParser;
import kd.epm.eb.common.ebcommon.spread.formula.IBreakableExpressionHandler;
import kd.epm.eb.common.ebcommon.spread.formula.IEditableExpressionHandler;
import kd.epm.eb.common.ebcommon.spread.formula.IExpressionHandler;
import kd.epm.eb.common.ebcommon.spread.formula.Parse2RPN;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Area3DExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.AreaExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.BinaryOperationExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Expression;
import kd.epm.eb.common.ebcommon.spread.formula.expr.FunctionExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Ref3DExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.ReferenceExpr;
import kd.epm.eb.common.ebcommon.spread.formula.expr.UnaryOperationExpr;

public class ExcelFormulaPaserHelper {
    public static Expression parse(String line) throws Exception {
        if (line == null) {
            throw new NullPointerException("invalid line: null is not allowed");
        }
        if (line.trim().length() > 0 && line.charAt(0) == '=') {
            line = line.substring(1);
        }
        Parse2RPN p = new Parse2RPN(line);
        p.parse();
        ExcelFormulaParser fp = new ExcelFormulaParser(p.getTokens());
        return fp.parse();
    }

    public static FunctionExpr getOuterLastFunction(String line) throws Exception {
        if (line == null) {
            throw new NullPointerException("invalid line: null is not allowed");
        }
        if (line.trim().length() > 0 && line.charAt(0) == '=') {
            line = line.substring(1);
        }
        Expression ex = ExcelFormulaPaserHelper.parse(line);
        return ExcelFormulaPaserHelper.getOuterLastFunction(ex);
    }

    public static FunctionExpr getOuterLastFunction(Expression ex) throws Exception {
        return (FunctionExpr)ExcelFormulaPaserHelper.walkToLast(ex);
    }

    private static Expression walkToLast(Expression ex) {
        if (ex instanceof FunctionExpr) {
            return ex;
        }
        if (ex instanceof BinaryOperationExpr) {
            Expression expression = ((BinaryOperationExpr)ex).getRight();
            return ExcelFormulaPaserHelper.walkToLast(expression);
        }
        return null;
    }

    public static void walk(Expression exp, IExpressionHandler handler) {
        handler.handle(exp);
        if (exp instanceof BinaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).getLeft(), handler);
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).getRight(), handler);
        } else if (exp instanceof UnaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).getOperand(), handler);
        } else if (exp instanceof FunctionExpr) {
            List<Object> ps = ((FunctionExpr)exp).getParameters();
            for (int i = 0; i < ps.size(); ++i) {
                ExcelFormulaPaserHelper.walk((Expression)ps.get(i), handler);
            }
        } else if (exp instanceof Area3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).getArea(), handler);
        } else if (exp instanceof Ref3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).getRef(), handler);
        }
    }

    public static void walk(Expression exp, IBreakableExpressionHandler handler) {
        boolean b = handler.handle(exp);
        if (!b) {
            return;
        }
        if (exp instanceof BinaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).getLeft(), handler);
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).getRight(), handler);
        } else if (exp instanceof UnaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).getOperand(), handler);
        } else if (exp instanceof FunctionExpr) {
            List<Object> ps = ((FunctionExpr)exp).getParameters();
            for (int i = 0; i < ps.size(); ++i) {
                ExcelFormulaPaserHelper.walk((Expression)ps.get(i), handler);
            }
        } else if (exp instanceof Area3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).getArea(), handler);
        } else if (exp instanceof Ref3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).getRef(), handler);
        }
    }

    public static Expression walk(Expression exp, IEditableExpressionHandler handler) {
        Expression expression = handler.handle(exp);
        if (exp instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)exp).setLeft(ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).getLeft(), handler));
            ((BinaryOperationExpr)exp).setRight(ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).getRight(), handler));
        } else if (exp instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)exp).setOperand(ExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).getOperand(), handler));
        } else if (exp instanceof FunctionExpr) {
            List<Object> ps = ((FunctionExpr)exp).getParameters();
            for (int i = 0; i < ps.size(); ++i) {
                Expression param = (Expression)ps.get(i);
                ps.set(i, ExcelFormulaPaserHelper.walk(param, handler));
            }
        } else if (exp instanceof Area3DExpr) {
            ((Area3DExpr)exp).setArea((AreaExpr)ExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).getArea(), handler));
        } else if (exp instanceof Ref3DExpr) {
            ((Ref3DExpr)exp).setRef((ReferenceExpr)ExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).getRef(), handler));
        }
        return expression;
    }

    public static String toReducedBracketsString(Expression exp) {
        StringBuffer sb = new StringBuffer();
        ExcelFormulaPaserHelper.reducedBrackets(sb, exp, -1);
        return sb.toString();
    }

    private static void reducedBrackets(StringBuffer sb, Expression expr, int lastOperationType) {
        if (expr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expr;
            sb.append(functionExpr.getFuncionName());
            sb.append('(');
            for (int i = 0; i < functionExpr.getParameters().size(); ++i) {
                Object obj = functionExpr.getParameters().get(i);
                if (i > 0) {
                    sb.append(',').append(' ');
                }
                ExcelFormulaPaserHelper.reducedBrackets(sb, (Expression)obj, -1);
            }
            sb.append(')');
        } else if (expr instanceof BinaryOperationExpr) {
            ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, (BinaryOperationExpr)expr, lastOperationType);
        } else if (expr instanceof UnaryOperationExpr) {
            ExcelFormulaPaserHelper.reducedUnaryBrackets(sb, (UnaryOperationExpr)expr, lastOperationType);
        } else {
            sb.append(expr);
        }
    }

    private static void reducedUnaryBrackets(StringBuffer sb, UnaryOperationExpr expr, int lastOperationType) {
        sb.append(expr.getOperation());
        if (expr.getOperand() instanceof BinaryOperationExpr) {
            BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expr.getOperand();
            if ((binaryExpr.getOperationType() == 5 || binaryExpr.getOperationType() == 6) && expr.getOperationType() != 3) {
                ExcelFormulaPaserHelper.reducedBrackets(sb, expr.getOperand(), expr.getOperationType());
            } else {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBrackets(sb, expr.getOperand(), expr.getOperationType());
                sb.append(')');
            }
        } else {
            sb.append('(');
            ExcelFormulaPaserHelper.reducedBrackets(sb, expr.getOperand(), expr.getOperationType());
            sb.append(')');
        }
    }

    private static void reducedBinaryBrackets(StringBuffer sb, BinaryOperationExpr expr, int lastOperationType) {
        ExcelFormulaPaserHelper.reducedLeftBrackets(sb, expr.getLeft(), expr.getOperationType());
        sb.append(expr.getOperation());
        ExcelFormulaPaserHelper.reducedRightBrackets(sb, expr.getRight(), expr.getOperationType());
    }

    private static void reducedLeftBrackets(StringBuffer sb, Expression left, int lastOperationType) {
        if (left instanceof BinaryOperationExpr) {
            BinaryOperationExpr expr = (BinaryOperationExpr)left;
            int operationType = expr.getOperationType();
            if (!(lastOperationType != 5 && lastOperationType != 6 || operationType != 7 && operationType != 8)) {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else {
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
            }
        } else {
            ExcelFormulaPaserHelper.reducedBrackets(sb, left, lastOperationType);
        }
    }

    private static void reducedRightBrackets(StringBuffer sb, Expression right, int lastOperationType) {
        if (right instanceof BinaryOperationExpr) {
            BinaryOperationExpr expr = (BinaryOperationExpr)right;
            int operationType = expr.getOperationType();
            if (6 == lastOperationType) {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else if (!(lastOperationType != 5 && lastOperationType != 8 || operationType != 7 && operationType != 8)) {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else {
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
            }
        } else {
            ExcelFormulaPaserHelper.reducedBrackets(sb, right, lastOperationType);
        }
    }

    public static boolean isHavSpecialExpr(Expression exp) {
        if (ExcelFormulaPaserHelper.isReferenceExprORareaExpr(exp)) {
            return true;
        }
        if (exp instanceof BinaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavSpecialExpr(((BinaryOperationExpr)exp).getLeft())) {
                return true;
            }
            if (ExcelFormulaPaserHelper.isHavSpecialExpr(((BinaryOperationExpr)exp).getRight())) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavSpecialExpr(((UnaryOperationExpr)exp).getOperand())) {
                return true;
            }
        } else if (exp instanceof FunctionExpr) {
            List<Object> ps = ((FunctionExpr)exp).getParameters();
            for (int i = 0; i < ps.size(); ++i) {
                if (!ExcelFormulaPaserHelper.isHavSpecialExpr((Expression)ps.get(i))) continue;
                return true;
            }
        } else if (exp instanceof Area3DExpr ? ExcelFormulaPaserHelper.isHavSpecialExpr(((Area3DExpr)exp).getArea()) : exp instanceof Ref3DExpr && ExcelFormulaPaserHelper.isHavSpecialExpr(((Ref3DExpr)exp).getRef())) {
            return true;
        }
        return false;
    }

    public static boolean isHavCommonRptExpr(Expression exp) {
        if (exp instanceof BinaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavCommonRptExpr(((BinaryOperationExpr)exp).getLeft())) {
                return true;
            }
            if (ExcelFormulaPaserHelper.isHavCommonRptExpr(((BinaryOperationExpr)exp).getRight())) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavCommonRptExpr(((UnaryOperationExpr)exp).getOperand())) {
                return true;
            }
        } else if (exp instanceof FunctionExpr) {
            List<Object> ps = ((FunctionExpr)exp).getParameters();
            for (int i = 0; i < ps.size(); ++i) {
                if (!ExcelFormulaPaserHelper.isHavCommonRptExpr((Expression)ps.get(i))) continue;
                return true;
            }
        } else if (exp instanceof Area3DExpr ? ExcelFormulaPaserHelper.isHavCommonRptExpr(((Area3DExpr)exp).getArea()) : exp instanceof Ref3DExpr && ExcelFormulaPaserHelper.isHavCommonRptExpr(((Ref3DExpr)exp).getRef())) {
            return true;
        }
        return false;
    }

    private static boolean isReferenceExprORareaExpr(Expression expr) {
        return expr instanceof ReferenceExpr || expr instanceof AreaExpr;
    }
}

