/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.spread.formula.expr;

import java.util.function.Consumer;
import kd.epm.eb.common.ebcommon.spread.formula.ICodeSupplier;
import kd.epm.eb.common.ebcommon.spread.formula.ICustomerFormat;
import kd.epm.eb.common.ebcommon.spread.formula.IValueSupplier;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Expression;
import kd.epm.eb.common.ebcommon.spread.formula.expr.OperationExpr;

public class BinaryOperationExpr
extends OperationExpr {
    private Expression left;
    private Expression right;

    public BinaryOperationExpr(int type) {
        this.setOperationType(type);
    }

    @Override
    public void output(StringBuffer buffer, ICustomerFormat c) {
        if (c != null) {
            c.beforeOutput(this, buffer);
        }
        if (this.left instanceof OperationExpr) {
            this.packOperationExprWalk(buffer, (OperationExpr)this.left, expr -> expr.output(buffer, c));
        } else {
            this.left.output(buffer, c);
        }
        String op = this.getOperation();
        if (c != null) {
            buffer.append(c.formatOP(op));
        } else {
            buffer.append(op);
        }
        if (this.right instanceof OperationExpr) {
            boolean needBracelet = false;
            if (this.right instanceof BinaryOperationExpr) {
                boolean bl = needBracelet = ((BinaryOperationExpr)this.right).getOperationType() <= this.getOperationType();
            }
            if (needBracelet) {
                buffer.append('(');
            }
            this.packOperationExprWalk(buffer, (OperationExpr)this.right, expr -> expr.output(buffer, c));
            if (needBracelet) {
                buffer.append(')');
            }
        } else {
            this.right.output(buffer, c);
        }
        if (c != null) {
            c.afterOutput(this, buffer);
        }
    }

    @Override
    public void outputCalcuteExpr(StringBuffer buffer, IValueSupplier<String, ?> s) {
        if (this.left instanceof OperationExpr) {
            boolean needBracelet = false;
            if (this.right instanceof BinaryOperationExpr) {
                boolean bl = needBracelet = ((BinaryOperationExpr)this.right).getOperationType() <= this.getOperationType();
            }
            if (needBracelet) {
                buffer.append('(');
            }
            this.packOperationExprWalk(buffer, (OperationExpr)this.left, expr -> expr.outputCalcuteExpr(buffer, s));
            if (needBracelet) {
                buffer.append(')');
            }
        } else {
            this.left.outputCalcuteExpr(buffer, s);
        }
        String op = this.getOperation();
        buffer.append(op);
        if (this.right instanceof OperationExpr) {
            boolean needBracelet = false;
            if (this.right instanceof BinaryOperationExpr) {
                boolean bl = needBracelet = ((BinaryOperationExpr)this.right).getOperationType() <= this.getOperationType();
            }
            if (needBracelet) {
                buffer.append('(');
            }
            this.packOperationExprWalk(buffer, (OperationExpr)this.right, expr -> expr.outputCalcuteExpr(buffer, s));
            if (needBracelet) {
                buffer.append(')');
            }
        } else {
            this.right.outputCalcuteExpr(buffer, s);
        }
    }

    @Override
    public void outputEncodeExpr(StringBuffer buffer, ICodeSupplier s) {
        if (this.left instanceof OperationExpr) {
            this.packOperationExprWalk(buffer, (OperationExpr)this.left, expr -> expr.outputEncodeExpr(buffer, s));
        } else {
            this.left.outputEncodeExpr(buffer, s);
        }
        String op = this.getOperation();
        buffer.append(op);
        if (this.right instanceof OperationExpr) {
            boolean needBracelet = false;
            if (this.right instanceof BinaryOperationExpr) {
                boolean bl = needBracelet = ((BinaryOperationExpr)this.right).getOperationType() <= this.getOperationType();
            }
            if (needBracelet) {
                buffer.append('(');
            }
            this.packOperationExprWalk(buffer, (OperationExpr)this.right, expr -> expr.outputEncodeExpr(buffer, s));
            if (needBracelet) {
                buffer.append(')');
            }
        } else {
            this.right.outputEncodeExpr(buffer, s);
        }
    }

    private void packOperationExprWalk(StringBuffer buffer, OperationExpr boexpr, Consumer<OperationExpr> c) {
        boolean isLowPriority;
        boolean bl = isLowPriority = this.isLowPriorityOprt(boexpr) && (this.getOperationType() == 5 || this.getOperationType() == 6);
        if (isLowPriority) {
            buffer.append('(');
        }
        c.accept(boexpr);
        if (isLowPriority) {
            buffer.append(')');
        }
    }

    private boolean isLowPriorityOprt(OperationExpr oprt) {
        return !oprt.getOperation().equals("/") && !oprt.getOperation().equals("*");
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }
}

