/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.spread.formula.expr;

import kd.epm.eb.common.ebcommon.spread.formula.ICodeSupplier;
import kd.epm.eb.common.ebcommon.spread.formula.ICustomerFormat;
import kd.epm.eb.common.ebcommon.spread.formula.IValueSupplier;
import kd.epm.eb.common.ebcommon.spread.formula.expr.Expression;
import kd.epm.eb.common.ebcommon.spread.formula.expr.OperationExpr;

public class UnaryOperationExpr
extends OperationExpr {
    private Expression operand;

    public UnaryOperationExpr(int type) {
        if (type != 1 && type != 2 && type != 3) {
            throw new RuntimeException("Unsupported unary operation type :" + type);
        }
        this.setOperationType(type);
    }

    @Override
    public void output(StringBuffer buffer, ICustomerFormat c) {
        if (c != null) {
            c.beforeOutput(this, buffer);
        }
        if (this.getOperationType() == 1) {
            buffer.append('+');
        } else if (this.getOperationType() == 2) {
            buffer.append('-');
        }
        if (this.operand instanceof OperationExpr) {
            buffer.append('(');
        }
        this.operand.output(buffer, c);
        if (this.operand instanceof OperationExpr) {
            buffer.append(')');
        }
        if (this.getOperationType() == 3) {
            buffer.append('%');
        }
        if (c != null) {
            c.afterOutput(this, buffer);
        }
    }

    @Override
    public void outputCalcuteExpr(StringBuffer buffer, IValueSupplier<String, ?> s) {
        if (this.getOperationType() == 1) {
            buffer.append('+');
        } else if (this.getOperationType() == 2) {
            buffer.append('-');
        }
        if (this.operand instanceof OperationExpr) {
            buffer.append('(');
        }
        this.operand.outputCalcuteExpr(buffer, s);
        if (this.operand instanceof OperationExpr) {
            buffer.append(')');
        }
        if (this.getOperationType() == 3) {
            buffer.append('%');
        }
    }

    @Override
    public void outputEncodeExpr(StringBuffer buffer, ICodeSupplier s) {
        if (this.getOperationType() == 1) {
            buffer.append('+');
        } else if (this.getOperationType() == 2) {
            buffer.append('-');
        }
        if (this.operand instanceof OperationExpr) {
            buffer.append('(');
        }
        this.operand.outputEncodeExpr(buffer, s);
        if (this.operand instanceof OperationExpr) {
            buffer.append(')');
        }
        if (this.getOperationType() == 3) {
            buffer.append('%');
        }
    }

    public Expression getOperand() {
        return this.operand;
    }

    public void setOperand(Expression operand) {
        this.operand = operand;
    }
}

