/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.spread.formula.ptg;

import kd.epm.eb.common.ebcommon.spread.formula.ptg.Ptg;
import kd.epm.eb.common.ebcommon.spread.formula.util.BitField;
import kd.epm.eb.common.ebcommon.spread.formula.util.CellReference;

public class Ref3DPtg
extends Ptg {
    public static final byte sid = 58;
    private static final int SIZE = 7;
    private int field_1_index_extern_sheet;
    private int field_2_row;
    private int field_3_column;
    private BitField rowRelative = new BitField(32768);
    private BitField colRelative = new BitField(16384);
    private BitField column = new BitField(16383);
    private String sheetName;

    public Ref3DPtg() {
    }

    public Ref3DPtg(byte[] data, int offset) {
    }

    public Ref3DPtg(String cellref, String sheetName) {
        CellReference c = new CellReference(cellref);
        this.setRow(c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
        this.sheetName = sheetName;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Ref3dPtg\n");
        buffer.append("Index to Extern Sheet = " + this.getExternSheetIndex()).append('\n');
        buffer.append("Row = " + this.getRow()).append('\n');
        buffer.append("Col  = " + this.getColumn()).append('\n');
        buffer.append("ColRowRel= " + this.isRowRelative()).append('\n');
        buffer.append("ColRel   = " + this.isColRelative()).append('\n');
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
    }

    public int getSize() {
        return 7;
    }

    public int getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short index) {
        this.field_1_index_extern_sheet = index;
    }

    public int getRow() {
        return this.field_2_row;
    }

    public final void setRow(int row) {
        this.field_2_row = row;
    }

    public int getColumn() {
        return this.column.getValue(this.field_3_column);
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_3_column);
    }

    public final void setRowRelative(boolean rel) {
        this.field_3_column = this.rowRelative.setBoolean(this.field_3_column, rel);
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_3_column);
    }

    public final void setColRelative(boolean rel) {
        this.field_3_column = this.colRelative.setBoolean(this.field_3_column, rel);
    }

    public final void setColumn(int col) {
        this.field_3_column = this.column.setValue(this.field_3_column, col);
    }

    @Override
    public String toFormulaString() {
        return null;
    }

    @Override
    public byte getDefaultOperandClass() {
        return 0;
    }

    @Override
    public Object clone() {
        Ref3DPtg ptg = new Ref3DPtg();
        ptg.field_1_index_extern_sheet = this.field_1_index_extern_sheet;
        ptg.field_2_row = this.field_2_row;
        ptg.field_3_column = this.field_3_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public String getSheetName() {
        return this.sheetName;
    }
}

