/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.ebcommon.spread.formula.util;

import kd.epm.eb.common.ebcommon.spread.formula.util.CellReference;

public class AreaReference {
    private CellReference[] cells;
    private int dim;

    public AreaReference(int row1, int col1, int row2, int col2) {
        this.cells = new CellReference[2];
        CellReference ref1 = new CellReference(row1, col1);
        CellReference ref2 = new CellReference(row2, col2);
        this.cells[0] = ref1;
        this.cells[1] = ref2;
        this.dim = 2;
    }

    public AreaReference(String reference) {
        String[] refs = this.seperateAreaRefs(reference);
        this.dim = refs.length;
        this.cells = new CellReference[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.cells[i] = new CellReference(refs[i]);
        }
    }

    public int getDim() {
        return this.dim;
    }

    public CellReference[] getCells() {
        return this.cells;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < this.dim; ++i) {
            retval.append(':');
            retval.append(this.cells[i]);
        }
        retval.deleteCharAt(0);
        return retval.toString();
    }

    private String[] seperateAreaRefs(String reference) {
        String[] retval = null;
        int loc = reference.indexOf(58, 0);
        if (loc == -1) {
            retval = new String[]{reference};
        } else {
            retval = new String[2];
            int sheetStart = reference.indexOf(33);
            retval[0] = reference.substring(0, sheetStart + 1) + reference.substring(sheetStart + 1, loc);
            retval[1] = reference.substring(0, sheetStart + 1) + reference.substring(loc + 1);
        }
        return retval;
    }
}

