/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.elasticsearch;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Objects;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.elasticsearch.OlapDataBusinessEvent;
import kd.epm.eb.common.mq.publisher.AuditPublisher;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.epbs.business.log.IOlapOpTarget;
import kd.epm.epbs.business.log.IOlapOpType;
import kd.epm.epbs.business.log.audit.OlapAuditServiceHelper;
import kd.epm.epbs.business.log.trace.BaseOlapOpTarget;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class OlapDataAuditService {
    private static final Log LOG = LogFactory.getLog(OlapDataAuditService.class);

    public void insertDoc(OlapDataBusinessEvent event) {
        AuditPublisher.publishMessage(event, false);
    }

    public static OlapDataAuditService getInstance() {
        return InnerClass.instance;
    }

    public void clearCache(String modelNumber) {
        String cacheKey = modelNumber + "isOpenOlapDataAudit";
        CacheServiceHelper.remove(cacheKey);
    }

    public void enhanceCommandWithAudit(String modelNumber, String cubeNumber, CommandInfo commandInfo) {
        DynamicObject modelDyn;
        Objects.requireNonNull(commandInfo, "parameter commandInfo can not be null");
        SaveDataContext saveDataContext = OlapContext.getSaveDataContext();
        OperationContext operationContext = OperationContext.get();
        if (operationContext != null) {
            OlapTraceServiceHelper.setTraceOpInfo((IOlapOpType)(null != saveDataContext ? saveDataContext.getEventEnum() : null), (IOlapOpTarget)new BaseOlapOpTarget(operationContext.getFormId()));
        }
        if (null != (modelDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray()))) {
            OlapAuditServiceHelper.enhanceCommandWithAudit((Long)modelDyn.getLong("id"), (String)cubeNumber, (Collection)Lists.newArrayList((Object[])new CommandInfo[]{commandInfo}));
        }
    }

    public void setOperationContextDefaultFormId(String formId) {
        OperationContext context = OperationContext.get();
        if (context == null) {
            context = new OperationContext();
            context.setFormId(formId);
            OperationContext.set((OperationContext)context);
        }
    }

    private static class InnerClass {
        private static OlapDataAuditService instance = new OlapDataAuditService();

        private InnerClass() {
        }
    }
}

