/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extension.ConcurrentHashSet;
import kd.epm.eb.common.elasticsearch.ElasticSearchService;
import org.apache.commons.io.IOUtils;

public class OlapDataLogEsUtils {
    private static final Set<String> EXISTING_INDICES = new ConcurrentHashSet(10);

    private OlapDataLogEsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndCreateIndexs(String businessIndexName, String olapIndexName) {
        Map<String, Integer> settingsMap;
        ErrorCode errorCode;
        if (OlapDataLogEsUtils.isIndexNotExists(businessIndexName)) {
            errorCode = ElasticSearchService.AUDIT_ERROR_CODE;
            synchronized (errorCode) {
                if (OlapDataLogEsUtils.isIndexNotExists(businessIndexName)) {
                    settingsMap = ElasticSearchService.getInstance().getDefaultIndexSettings();
                    String businessIndexMap = OlapDataLogEsUtils.getResourceFileAsString("esmapping/eb/audit_business.json");
                    ElasticSearchService.getInstance().createIndex(businessIndexName, "_doc", settingsMap, businessIndexMap);
                    EXISTING_INDICES.add(businessIndexName);
                }
            }
        }
        if (OlapDataLogEsUtils.isIndexNotExists(olapIndexName)) {
            errorCode = ElasticSearchService.AUDIT_ERROR_CODE;
            synchronized (errorCode) {
                if (OlapDataLogEsUtils.isIndexNotExists(olapIndexName)) {
                    settingsMap = ElasticSearchService.getInstance().getDefaultIndexSettings();
                    String olapIndexMap = OlapDataLogEsUtils.getResourceFileAsString("esmapping/eb/audit_olap.json");
                    ElasticSearchService.getInstance().createIndex(olapIndexName, "_doc", settingsMap, olapIndexMap);
                    EXISTING_INDICES.add(olapIndexName);
                }
            }
        }
    }

    private static boolean isIndexNotExists(String indexName) {
        return !EXISTING_INDICES.contains(indexName) && !ElasticSearchService.getInstance().isIndexExist(indexName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceFileAsString(String resourceFilePath) {
        try (InputStream summaryInputStream = OlapDataLogEsUtils.class.getClassLoader().getResourceAsStream(resourceFilePath);){
            String string = IOUtils.toString((InputStream)summaryInputStream);
            return string;
        }
        catch (IOException var15) {
            throw new KDBizException(ElasticSearchService.AUDIT_ERROR_CODE, new Object[]{"resource file:" + resourceFilePath + " read error."});
        }
    }

    public static String toEn(String ipStr) {
        return ipStr.trim().toLowerCase(Locale.ENGLISH);
    }
}

