/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.entity.property;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CustomPropertyUtils {
    private static final Log log = LogFactory.getLog(CustomPropertyUtils.class);
    private static final String PROP_VALUE_FIELDS = "id,name,number,property.id,property.number";

    public static boolean hasCustomProperty(String dimensionNumber) {
        boolean re;
        boolean bl = re = StringUtils.equals("Entity", dimensionNumber) || StringUtils.equals("Account", dimensionNumber);
        if (!re) {
            SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByNumber(dimensionNumber);
            re = dimEnum == null || dimEnum == SysDimensionEnum.Project;
        }
        return re;
    }

    public static boolean hasCustomPropertyByEntityNumber(String entityNumber) {
        return StringUtils.equals("epm_entitymembertree", entityNumber) || StringUtils.equals("epm_accountmembertree", entityNumber) || StringUtils.equals("epm_userdefinedmembertree", entityNumber);
    }

    public static Map<Object, DynamicObject> getCustomProperty(@NotNull Long modelId, @NotNull Long dimensionId) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("dimension", "=", dimensionId);
        return BusinessDataServiceHelper.loadFromCache((String)"eb_customproperty", (String)"id,name,number", (QFilter[])builder.toArray(), (String)"dseq");
    }

    public static Map<Long, Set<Long>> queryPropertyValue(Collection<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return null;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fpropertyvalueid from t_eb_memberpropertyvalue where ", new Object[0]).appendIn("fid", memberIds.toArray());
        HashMap propValueMap = Maps.newHashMapWithExpectedSize((int)memberIds.size());
        try (DataSet ds = DB.queryDataSet((String)"queryPropertyValueId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Set valueIds = propValueMap.computeIfAbsent(row.getLong("fid"), f -> new HashSet());
                    valueIds.add(row.getLong("fpropertyvalueid"));
                }
            }
        }
        return propValueMap;
    }

    public static List<Map<String, Object>> queryAllPropertyValue(List<Object> memberIds) {
        List<Map<String, Object>> rst;
        if (memberIds == null || memberIds.isEmpty()) {
            return null;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fentryid, fseq, fpropertyvalueid from t_eb_memberpropertyvalue where ", new Object[0]).appendIn("fid", memberIds);
        try (DataSet ds = DB.queryDataSet((String)"queryPropertyValueId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            rst = CommonServiceHelper.transDataSet(ds);
        }
        return rst;
    }

    public static Map<Long, Set<Long>> queryAllPropertyValue(Long modelId, Long dimensionId, String dimensionTable) {
        if (IDUtils.isNull(modelId) || IDUtils.isNull(dimensionId) || StringUtils.isEmpty(dimensionTable)) {
            return Collections.emptyMap();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select v.fid, v.fpropertyvalueid from t_eb_memberpropertyvalue v ", new Object[0]);
        sql.append("where exists (select fid from " + dimensionTable + " where fmodelid = ? and fdimensionid = ? and v.fid = fid)", new Object[]{modelId, dimensionId});
        LinkedHashMap propValues = Maps.newLinkedHashMap();
        try (DataSet ds = DB.queryDataSet((String)"queryAllPropertyValue", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Set tmpSet = propValues.computeIfAbsent(row.getLong("fid"), f -> Sets.newHashSet());
                    tmpSet.add(row.getLong("fpropertyvalueid"));
                }
            }
        }
        return propValues;
    }

    public static Map<Object, DynamicObject> getCustomPropertyValue(@NotNull Set<Long> propValueIds, String fields) {
        if (propValueIds.isEmpty()) {
            return Collections.emptyMap();
        }
        if (fields == null) {
            fields = PROP_VALUE_FIELDS;
        }
        return BusinessDataServiceHelper.loadFromCache((String)"eb_custompropertyvalue", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", propValueIds)});
    }

    public static Map<Object, DynamicObject> getCustomPropertyValueByProperty(@NotNull Set<Long> propIds, String fields) {
        if (propIds.isEmpty()) {
            return Collections.emptyMap();
        }
        if (fields == null) {
            fields = PROP_VALUE_FIELDS;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("property", "in", propIds);
        return BusinessDataServiceHelper.loadFromCache((String)"eb_custompropertyvalue", (String)fields, (QFilter[])builder.toArray());
    }

    public static String checkRefCustomPropertyValue(Set<Long> cusPropertiesValueIds) {
        List<Member> members = CustomPropertyUtils.queryRefCustomPropertyValue(cusPropertiesValueIds);
        if (!members.isEmpty()) {
            ArrayList<String> msg = new ArrayList<String>(members.size());
            for (Member member : members) {
                msg.add(member.getName() + '-' + member.getNumber());
            }
            return ResManager.loadResFormat((String)"\u5f53\u524d\u9009\u62e9\u7684\u5c5e\u6027\u503c\u88ab\u201c%1\u201d\u9884\u7b97\u7ef4\u5ea6\u6210\u5458\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CustomPropertySetPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join(msg, ',')});
        }
        return null;
    }

    public static List<Member> queryRefCustomPropertyValue(Set<Long> cusPropertiesValueIds) {
        if (cusPropertiesValueIds == null || cusPropertiesValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fpropertyvalueid from t_eb_memberpropertyvalue where ", new Object[0]);
        sql.appendIn("fpropertyvalueid", cusPropertiesValueIds.toArray());
        LinkedHashMap<Long, Set> memberIds = new LinkedHashMap<Long, Set>(cusPropertiesValueIds.size());
        try (DataSet ds = DB.queryDataSet((String)"queryRef", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Set cusPropertyIds = memberIds.computeIfAbsent(row.getLong("fid"), f -> new HashSet());
                    cusPropertyIds.add(row.getLong("fpropertyvalueid"));
                }
            }
        }
        if (memberIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(memberIds.size());
        QFilter filter = new QFilter("id", "in", memberIds.keySet());
        CustomPropertyUtils.queryRefMember(SysDimensionEnum.Entity.getMemberTreemodel(), filter, members);
        CustomPropertyUtils.queryRefMember(SysDimensionEnum.Account.getMemberTreemodel(), filter, members);
        CustomPropertyUtils.queryRefMember("epm_userdefinedmembertree", filter, members);
        return members;
    }

    private static void queryRefMember(String entityNumber, QFilter filter, List<Member> members) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryUserDef", (String)entityNumber, (String)"id,name,number", (QFilter[])new QFilter[]{filter}, null);){
            if (ds != null) {
                for (Row row : ds) {
                    members.add(new Member(row.getLong("id"), row.getString("name"), row.getString("number")));
                }
            }
        }
    }

    public static void deletePropertyByRef(Collection<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from t_eb_memberpropertyvalue where ", new Object[0]).appendIn("fid", new HashSet<Long>(memberIds).toArray());
        DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
    }

    public static void clearErrorPropertyByRef() {
        LogStats stats = new LogStats("member-log:");
        stats.addInfo("begin-clearErrorPropertyByRef.");
        LinkedHashSet memberIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryPropertyMemberIds", (DBRoute)BgBaseConstant.epm, (String)"select fid from t_eb_memberpropertyvalue");){
            if (ds != null) {
                for (Row row : ds) {
                    memberIds.add(row.getLong("fid"));
                }
            }
        }
        if (memberIds.isEmpty()) {
            return;
        }
        stats.addInfo("memberIds size = " + memberIds.size());
        for (SysDimensionEnum _enum : SysDimensionEnum.values()) {
            CustomPropertyUtils.clearErrorPropertyByRef(_enum.getMemberTreetable(), memberIds);
            stats.addInfo("dimNumber = " + _enum.getNumber() + ",after memberIds size = " + memberIds.size());
        }
        CustomPropertyUtils.clearErrorPropertyByRef("epm_userdefinedmembertree", memberIds);
        stats.addInfo("dimNumber = userdefinedmembertree,after memberIds size = " + memberIds.size());
        stats.addInfo("delete error members Ref size = " + memberIds.size());
        CustomPropertyUtils.deletePropertyByRef(memberIds);
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_customproperty where fmodelid not in (select fid from t_eb_model)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_customproperty where fdimensionid not in (select fid from t_eb_dimension)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_custompropertyvalue where fpropertyid not in (select fid from t_eb_customproperty)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_memberpropertyvalue where fpropertyvalueid not in (select fid from t_eb_custompropertyvalue)");
        stats.addInfo("end-clearErrorPropertyByRef.");
        log.info(stats.toString());
    }

    private static void clearErrorPropertyByRef(String tableName, @NotNull Set<Long> memberIds) {
        if (StringUtils.isEmpty(tableName) || memberIds.isEmpty()) {
            return;
        }
        if (!SqlBatchUtils.hasTable(tableName)) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from ", new Object[0]).append(tableName, new Object[0]);
        if (memberIds.size() <= 1000) {
            sql.append(" where ", new Object[0]).appendIn("fid", memberIds.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)"queryMemberIds", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    memberIds.remove(row.getLong("fid"));
                }
            }
        }
    }
}

