/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.AppUtil;
import kd.epm.eb.common.utils.NewEbAppUtil;
import org.jetbrains.annotations.NotNull;

public enum ApplicationTypeEnum {
    EB(ApplicationTypeEnum.getEB(), "4", "eb"),
    BG(ApplicationTypeEnum.getBG(), "6", "eb"),
    BGBD(ApplicationTypeEnum.getBGBD(), "9", "bgbd"),
    BGMD(ApplicationTypeEnum.getBGMD(), "7", "bgmd"),
    BGM(ApplicationTypeEnum.getBGM(), "10", "bgm"),
    BGC(ApplicationTypeEnum.getBGC(), "11", "bgc"),
    BGRP(ApplicationTypeEnum.getBGRP(), "12", "bgrp"),
    WF(ApplicationTypeEnum.getWF(), "13", "wftask"),
    WF2(ApplicationTypeEnum.getWF(), "14", "wf");

    private MultiLangEnumBridge name;
    private String index;
    private String appnum;
    private static final ApplicationTypeEnum[] values;

    private ApplicationTypeEnum(MultiLangEnumBridge name, String index, String appnum) {
        this.name = name;
        this.index = index;
        this.appnum = appnum;
    }

    public static List<String> getAllAppnum() {
        ApplicationTypeEnum[] values = ApplicationTypeEnum.values();
        ArrayList<String> appNums = new ArrayList<String>(values.length);
        for (ApplicationTypeEnum app : values) {
            appNums.add(app.getAppnum());
        }
        return appNums;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getIndex() {
        return this.index;
    }

    public String getAppnum() {
        return this.appnum;
    }

    public void setAppnum(String appnum) {
        this.appnum = appnum;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public static ApplicationTypeEnum getEnumByNumber(String appNum) {
        return ApplicationTypeEnum.getEnumByNumber(appNum, null);
    }

    public static ApplicationTypeEnum getEnumByNumber(String appNum, IFormView formView) {
        if (StringUtils.isEmpty((String)appNum)) {
            return BGMD;
        }
        if (BGRP.getAppnum().equals(appNum)) {
            return NewEbAppUtil.isSpecialBGRPApp(formView) ? BGRP : BGMD;
        }
        if (ApplicationTypeEnum.EB.appnum.equals(appNum) && NewEbAppUtil.isNewEbApp(formView)) {
            return BG;
        }
        for (ApplicationTypeEnum typeEnum : ApplicationTypeEnum.values()) {
            if (!appNum.equals(typeEnum.appnum)) continue;
            return typeEnum;
        }
        return ApplicationTypeEnum.getEnumByNumber(AppUtil.getAppId(formView));
    }

    public static ApplicationTypeEnum getEnumByIndex(@NotNull String index) {
        for (ApplicationTypeEnum typeEnum : values) {
            if (!index.equals(typeEnum.index)) continue;
            return typeEnum;
        }
        throw new KDBizException("error ApplicationTypeEnum index : " + index);
    }

    public static boolean isEB(ApplicationTypeEnum app) {
        return EB == app || WF == app || WF2 == app;
    }

    public static boolean isNewBG(ApplicationTypeEnum app) {
        return BG == app;
    }

    public static boolean isEB(String reportType) {
        return EB.getIndex().equals(reportType) || WF.getIndex().equals(reportType) || WF2.getIndex().equals(reportType);
    }

    public static boolean isBGMD(String reportType) {
        return BGMD.getIndex().equals(reportType);
    }

    private static MultiLangEnumBridge getEB() {
        return new MultiLangEnumBridge("\u8d39\u7528\u9884\u7b97", "ApplicationTypeEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBG() {
        return new MultiLangEnumBridge("\u8d39\u7528\u9884\u7b97", "ApplicationTypeEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGBD() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u57fa\u7840\u8d44\u6599", "ApplicationTypeEnum_6", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGMD() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u9884\u7b97\u4f53\u7cfb", "ApplicationTypeEnum_7", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGM() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u5168\u9762\u9884\u7b97", "ApplicationTypeEnum_8", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGC() {
        return new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u9884\u7b97\u63a7\u5236", "ApplicationTypeEnum_9", "epm-eb-common");
    }

    private static MultiLangEnumBridge getBGRP() {
        return new MultiLangEnumBridge("\u5458\u5de5\u670d\u52a1\u4e91\u9884\u7b97\u7533\u62a5", "ApplicationTypeEnum_11", "epm-eb-common");
    }

    private static MultiLangEnumBridge getWF() {
        return new MultiLangEnumBridge("\u5de5\u4f5c\u6d41", "ApplicationTypeEnum_10", "epm-eb-common");
    }

    static {
        values = ApplicationTypeEnum.values();
    }
}

