/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum BgControlSettingTypeEnum {
    MONTH(BgControlSettingTypeEnum.getMONTH(), "MONTH", 1),
    QUARTER(BgControlSettingTypeEnum.getQUARTER(), "QUARTER", 2),
    HALFYEAR(BgControlSettingTypeEnum.getHALFYEAR(), "HALFYEAR", 12),
    YEAR(BgControlSettingTypeEnum.getYEAR(), "YEAR", 3),
    MONTH_ADDUP(BgControlSettingTypeEnum.getMONTH_ADDUP(), "MONTH_ADDUP", 4),
    QUARTER_ADDUP(BgControlSettingTypeEnum.getQUARTER_ADDUP(), "QUARTER_ADDUP", 5),
    HALFYEAR_ADDUP(BgControlSettingTypeEnum.getHALFYEAR_ADDUP(), "HALFYEAR_ADDUP", 16),
    MONTH_HALFYEAR_ADDUP(BgControlSettingTypeEnum.getMONTH_HALFYEAR_ADDUP(), "MONTH_HALFYEAR_ADDUP", 6),
    QUARTER_HALFYEAR_ADDUP(BgControlSettingTypeEnum.getQUARTER_HALFYEAR_ADDUP(), "QUARTER_HALFYEAR_ADDUP", 7),
    MONTH_QUARTER_ADDUP(BgControlSettingTypeEnum.getMONTH_QUARTER_ADDUP(), "MONTH_QUARTER_ADDUP", 8),
    YEAR_MODEL_ADDIP(BgControlSettingTypeEnum.getYEAR_MODEL_ADDIP(), "YEAR_MODEL_ADDIP", 9),
    QUARTER_MODEL_ADDUP(BgControlSettingTypeEnum.getQUARTER_MODEL_ADDUP(), "QUARTER_MODEL_ADDUP", 10),
    MONTH_MODEL_ADDUP(BgControlSettingTypeEnum.getMONTH_MODEL_ADDUP(), "MONTH_MODEL_ADDUP", 11),
    MONTH_BY_YEAR_CURR_GROSS(BgControlSettingTypeEnum.getMONTH_BY_YEAR_CURR_GROSS(), "MONTH_BY_YEAR_CURR_GROSS", 15),
    QUARTER_BY_YEAR_CURR_GROSS(BgControlSettingTypeEnum.getQUARTER_BY_YEAR_CURR_GROSS(), "MONTH_BY_YEAR_CURR_GROSS", 16),
    HALFYEAR_BY_YEAR_CURR_GROSS(BgControlSettingTypeEnum.getHALFYEAR_BY_YEAR_CURR_GROSS(), "MONTH_BY_YEAR_CURR_GROSS", 17);

    private MultiLangEnumBridge name = null;
    private String number = null;
    private int index = 0;
    private static final Map<Integer, List<Integer>> relationMap;

    private BgControlSettingTypeEnum(MultiLangEnumBridge name, String number, int index) {
        this.name = name;
        this.number = number;
        this.index = index;
    }

    private static MultiLangEnumBridge getMONTH() {
        return new MultiLangEnumBridge("\u6309\u6708\u63a7\u5236", "BgControlSettingTypeEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getQUARTER() {
        return new MultiLangEnumBridge("\u6309\u5b63\u63a7\u5236", "BgControlSettingTypeEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getHALFYEAR() {
        return new MultiLangEnumBridge("\u6309\u534a\u5e74\u63a7\u5236", "BgControlSettingTypeEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getYEAR() {
        return new MultiLangEnumBridge("\u5e74\u5ea6\u603b\u91cf", "BgControlSettingTypeEnum_17", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMONTH_ADDUP() {
        return new MultiLangEnumBridge("\u6309\u6708\u7d2f\u8ba1\uff08\u5e74\u5ea6\uff09", "BgControlSettingTypeEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getQUARTER_ADDUP() {
        return new MultiLangEnumBridge("\u6309\u5b63\u7d2f\u8ba1", "BgControlSettingTypeEnum_5", "epm-eb-common");
    }

    private static MultiLangEnumBridge getHALFYEAR_ADDUP() {
        return new MultiLangEnumBridge("\u6309\u534a\u5e74\u7d2f\u8ba1", "BgControlSettingTypeEnum_16", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMONTH_HALFYEAR_ADDUP() {
        return new MultiLangEnumBridge("\u6309\u6708\u7d2f\u8ba1\uff08\u534a\u5e74\uff09", "BgControlSettingTypeEnum_6", "epm-eb-common");
    }

    private static MultiLangEnumBridge getQUARTER_HALFYEAR_ADDUP() {
        return new MultiLangEnumBridge("\u534a\u5e74\u5185\u5b63\u7d2f\u8ba1", "BgControlSettingTypeEnum_7", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMONTH_QUARTER_ADDUP() {
        return new MultiLangEnumBridge("\u6309\u6708\u7d2f\u8ba1\uff08\u5b63\u5ea6\uff09", "BgControlSettingTypeEnum_8", "epm-eb-common");
    }

    private static MultiLangEnumBridge getYEAR_MODEL_ADDIP() {
        return new MultiLangEnumBridge("\u4f53\u7cfb\u5185\u5e74\u7d2f\u8ba1", "BgControlSettingTypeEnum_9", "epm-eb-common");
    }

    private static MultiLangEnumBridge getQUARTER_MODEL_ADDUP() {
        return new MultiLangEnumBridge("\u4f53\u7cfb\u5185\u5b63\u7d2f\u8ba1", "BgControlSettingTypeEnum_10", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMONTH_MODEL_ADDUP() {
        return new MultiLangEnumBridge("\u4f53\u7cfb\u5185\u6708\u7d2f\u8ba1", "BgControlSettingTypeEnum_11", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMONTH_BY_YEAR_CURR_GROSS() {
        return new MultiLangEnumBridge("\u5f53\u524d\u5e74\u6309\u6708\u603b\u91cf\u5230\u5f53\u524d", "BgControlSettingTypeEnum_12", "epm-eb-common");
    }

    private static MultiLangEnumBridge getQUARTER_BY_YEAR_CURR_GROSS() {
        return new MultiLangEnumBridge("\u5f53\u524d\u5e74\u6309\u5b63\u5ea6\u603b\u91cf\u5230\u5f53\u524d", "BgControlSettingTypeEnum_15", "epm-eb-common");
    }

    private static MultiLangEnumBridge getHALFYEAR_BY_YEAR_CURR_GROSS() {
        return new MultiLangEnumBridge("\u5f53\u524d\u5e74\u6309\u534a\u5e74\u603b\u91cf\u5230\u5f53\u524d", "BgControlSettingTypeEnum_18", "epm-eb-common");
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public int getIndex() {
        return this.index;
    }

    public static BgControlSettingTypeEnum valueOf(int value) {
        for (BgControlSettingTypeEnum _enum : BgControlSettingTypeEnum.values()) {
            if (_enum.getIndex() != value) continue;
            return _enum;
        }
        return null;
    }

    public static String getNameByValue(int value) {
        for (BgControlSettingTypeEnum bgControlSettingTypeEnum : BgControlSettingTypeEnum.values()) {
            if (bgControlSettingTypeEnum.getIndex() != value) continue;
            return bgControlSettingTypeEnum.getName();
        }
        return "";
    }

    private static Map<Integer, List<Integer>> getRelationMap() {
        if (relationMap.size() < 1) {
            relationMap.put(1, Lists.newArrayList((Object[])new Integer[]{1}));
            relationMap.put(2, Lists.newArrayList((Object[])new Integer[]{1, 2}));
            relationMap.put(3, Lists.newArrayList((Object[])new Integer[]{1, 2, 3}));
            relationMap.put(4, Lists.newArrayList((Object[])new Integer[]{1}));
            relationMap.put(5, Lists.newArrayList((Object[])new Integer[]{1, 2}));
        }
        return relationMap;
    }

    public static String validateRelation(int controlTypeValue, int periodClassifyValue) {
        List<Integer> periodClassifyList = BgControlSettingTypeEnum.getRelationMap().get(controlTypeValue);
        if (!CollectionUtils.isEmpty(periodClassifyList) && !periodClassifyList.contains(periodClassifyValue)) {
            String controlTypeName = BgControlSettingTypeEnum.getNameByValue(controlTypeValue);
            StringBuilder periodClassifyName = new StringBuilder();
            for (Integer s : periodClassifyList) {
                periodClassifyName.append(BgControlPeriodTypeEnum.getNameByValue(s)).append(',');
            }
            if (periodClassifyName.length() > 0) {
                periodClassifyName.deleteCharAt(periodClassifyName.length() - 1);
            }
            return ResManager.loadResFormat((String)"\u63a7\u5236\u65b9\u5f0f\uff1a'%1',\u53ea\u80fd\u9009\u62e9\u7684\u533a\u95f4\u660e\u7ec6\u5206\u7c7b\u4e3a\uff1a'%2'", (String)"BgControlSettingTypeEnum_13", (String)"epm-eb-common", (Object[])new Object[]{controlTypeName, periodClassifyName});
        }
        return "";
    }

    public static Boolean isMonthAddUp(String controlType) {
        return Lists.newArrayList((Object[])new String[]{MONTH_ADDUP.getNumber(), MONTH_HALFYEAR_ADDUP.getNumber(), MONTH_QUARTER_ADDUP.getNumber()}).contains(controlType);
    }

    static {
        relationMap = Maps.newHashMap();
    }
}

