/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum DataUnitEnum {
    YUAN(DataUnitEnum.getYUAN(), "yuan", 0, "1"),
    THOUSAND(DataUnitEnum.getTHOUSAND(), "thousand", 3, "1000"),
    TENTHOUSAND(DataUnitEnum.getTENTHOUSAND(), "tenthousand", 4, "10000"),
    MILLIONS(DataUnitEnum.getMILLIONS(), "millions", 6, "1000000"),
    BILLIONS(DataUnitEnum.getBILLIONS(), "billion", 8, "100000000");

    private MultiLangEnumBridge name;
    private String number;
    private int index;
    private String value;

    private static MultiLangEnumBridge getBILLIONS() {
        return new MultiLangEnumBridge("\u4ebf", "DataUnitEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMILLIONS() {
        return new MultiLangEnumBridge("\u767e\u4e07", "DataUnitEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getTENTHOUSAND() {
        return new MultiLangEnumBridge("\u4e07", "DataUnitEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getTHOUSAND() {
        return new MultiLangEnumBridge("\u5343", "DataUnitEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getYUAN() {
        return new MultiLangEnumBridge("--", "DataUnitEnum_0", "epm-eb-common");
    }

    private DataUnitEnum(MultiLangEnumBridge name, String number, int index, String value) {
        this.name = name;
        this.number = number;
        this.index = index;
        this.value = value;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    public static String getIndexByNumber(String number) {
        for (DataUnitEnum value : DataUnitEnum.values()) {
            if (!value.getNumber().equals(number)) continue;
            return String.valueOf(value.index);
        }
        return number;
    }

    public static DataUnitEnum getEnumByIndex(int index) {
        for (DataUnitEnum value : DataUnitEnum.values()) {
            if (value.getIndex() != index) continue;
            return value;
        }
        return null;
    }
}

