/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum DimensionViewEnum {
    ENTITYVIEW("E001", DimensionViewEnum.getENTITYVIEW(), "Entity", "epm_entitymembertree", "1"),
    INTERNALCOMPANYVIEW("IC_E001", DimensionViewEnum.getINTERNALCOMPANYVIEW(), "InternalCompany", "epm_icmembertree", "1"),
    CTVIEW("CT001", DimensionViewEnum.getCTVIEW(), "ChangeType", "epm_changetypemembertree", "1"),
    TRAILVIEW("T001", DimensionViewEnum.getTRAILVIEW(), "AuditTrail", "epm_audittrialmembertree", "1");

    private String number;
    private MultiLangEnumBridge name;
    private String dimensionNumber;
    private String dimMemberTree;
    private String source;

    private static MultiLangEnumBridge getTRAILVIEW() {
        return new MultiLangEnumBridge("\u7ebf\u7d22\u57fa\u51c6\u89c6\u56fe", "DimensionViewEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCTVIEW() {
        return new MultiLangEnumBridge("\u53d8\u52a8\u7c7b\u578b\u57fa\u51c6\u89c6\u56fe", "DimensionViewEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getINTERNALCOMPANYVIEW() {
        return new MultiLangEnumBridge("\u5f80\u6765\u7ec4\u7ec7\u57fa\u51c6\u89c6\u56fe", "DimensionViewEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getENTITYVIEW() {
        return new MultiLangEnumBridge("\u7ec4\u7ec7\u57fa\u51c6\u89c6\u56fe", "DimensionViewEnum_0", "epm-eb-common");
    }

    private DimensionViewEnum(String number, MultiLangEnumBridge name, String dimensionNumber, String dimMemberTree, String source) {
        this.number = number;
        this.name = name;
        this.dimensionNumber = dimensionNumber;
        this.dimMemberTree = dimMemberTree;
        this.source = source;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public MultiLangEnumBridge getNameKey() {
        return this.name;
    }

    public String getDimMemberTree() {
        return this.dimMemberTree;
    }

    public String getSource() {
        return this.source;
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public static List<DimensionViewEnum> getAll() {
        ArrayList<DimensionViewEnum> list = new ArrayList<DimensionViewEnum>();
        list.add(ENTITYVIEW);
        list.add(TRAILVIEW);
        list.add(CTVIEW);
        list.add(INTERNALCOMPANYVIEW);
        return list;
    }

    public static DimensionViewEnum getByDimNumber(String dimNumber) {
        for (DimensionViewEnum value : DimensionViewEnum.values()) {
            if (!value.getDimensionNumber().equals(dimNumber)) continue;
            return value;
        }
        return null;
    }

    public static List<String> getAllNumber() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)DimensionViewEnum.values().length);
        for (DimensionViewEnum value : DimensionViewEnum.values()) {
            list.add(value.getDimensionNumber());
        }
        return list;
    }
}

