/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum DimensionViewGroupEnum {
    ENTITY_VIEW_GROUP("E001", DimensionViewGroupEnum.getEntityViewGroup(), "Entity", "epm_entitymembertree"),
    INTERNAL_COMPANY_VIEW_GROUP("IC_E001", DimensionViewGroupEnum.getInternalCompanyViewGroup(), "InternalCompany", "epm_icmembertree"),
    CT_VIEW_GROUP("CT001", DimensionViewGroupEnum.getCtViewGroup(), "ChangeType", "epm_changetypemembertree");

    private String number;
    private MultiLangEnumBridge name;
    private String dimensionNumber;
    private String dimMemberTree;

    private static MultiLangEnumBridge getCtViewGroup() {
        return new MultiLangEnumBridge("\u53d8\u52a8\u7c7b\u578b\u9884\u7f6e\u89c6\u56fe\u7ec4", "DimensionViewGroupEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getInternalCompanyViewGroup() {
        return new MultiLangEnumBridge("\u5f80\u6765\u7ec4\u7ec7\u9884\u7f6e\u89c6\u56fe\u7ec4", "DimensionViewGroupEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getEntityViewGroup() {
        return new MultiLangEnumBridge("\u7ec4\u7ec7\u9884\u7f6e\u89c6\u56fe\u7ec4", "DimensionViewGroupEnum_0", "epm-eb-common");
    }

    private DimensionViewGroupEnum(String number, MultiLangEnumBridge name, String dimensionNumber, String dimMemberTree) {
        this.number = number;
        this.name = name;
        this.dimensionNumber = dimensionNumber;
        this.dimMemberTree = dimMemberTree;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public MultiLangEnumBridge getNameKey() {
        return this.name;
    }

    public String getDimMemberTree() {
        return this.dimMemberTree;
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public static List<DimensionViewGroupEnum> getAll() {
        ArrayList<DimensionViewGroupEnum> list = new ArrayList<DimensionViewGroupEnum>();
        list.add(ENTITY_VIEW_GROUP);
        list.add(CT_VIEW_GROUP);
        list.add(INTERNAL_COMPANY_VIEW_GROUP);
        return list;
    }

    public static DimensionViewGroupEnum getByDimNumber(String dimNumber) {
        for (DimensionViewGroupEnum value : DimensionViewGroupEnum.values()) {
            if (!value.getDimensionNumber().equals(dimNumber)) continue;
            return value;
        }
        return null;
    }

    public static List<String> getAllNumber() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)DimensionViewGroupEnum.values().length);
        for (DimensionViewGroupEnum value : DimensionViewGroupEnum.values()) {
            list.add(value.getDimensionNumber());
        }
        return list;
    }
}

