/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import kd.epm.eb.common.enums.MultiLangEnumBridge;

public enum OffsetCatalogEnum {
    INTEROFFSET("interoffset", 10, OffsetCatalogEnum.getINTEROFFSET()),
    TRADEOFFSET("tradeoffset", 20, OffsetCatalogEnum.getTRADEOFFSET());

    private String number;
    private int value;
    private MultiLangEnumBridge bridge;

    private static MultiLangEnumBridge getTRADEOFFSET() {
        return new MultiLangEnumBridge("\u4ea4\u6613\u62b5\u9500", "OffsetCatalogEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getINTEROFFSET() {
        return new MultiLangEnumBridge("\u5f80\u6765\u62b5\u9500", "OffsetCatalogEnum_2", "epm-eb-common");
    }

    private OffsetCatalogEnum(String number, int value, MultiLangEnumBridge bridge) {
        this.number = number;
        this.value = value;
        this.bridge = bridge;
    }

    public String getNumber() {
        return this.number;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static OffsetCatalogEnum getEnum(Integer type) {
        if (type == null) {
            return null;
        }
        for (OffsetCatalogEnum e : OffsetCatalogEnum.values()) {
            if (e.getValue() != type.intValue()) continue;
            return e;
        }
        throw new RuntimeException(OffsetCatalogEnum.class.getName() + "error value:" + type);
    }

    public static OffsetCatalogEnum getEnum(String number) {
        if (number == null) {
            return null;
        }
        for (OffsetCatalogEnum e : OffsetCatalogEnum.values()) {
            if (!e.getNumber().equals(number)) continue;
            return e;
        }
        throw new RuntimeException(OffsetCatalogEnum.class.getName() + "error value:" + number);
    }
}

